/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenAbstractEntryReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenColumnBulkEntry;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenColumnBulkInput;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenEntryDictionaryReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenEntryReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenFixedEntryReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenNullableDictionaryReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenNullableEntryReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenNullableFixedEntryReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenOverflowReader;
import org.apache.drill.exec.store.parquet.columnreaders.batchsizing.RecordBatchSizerManager;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

final class VarLenBulkPageReader {
    static final int BUFF_SZ = 4096;
    static final int PADDING = 64;
    private final ByteBuffer buffer = ByteBuffer.allocate(4160);
    private final VarLenColumnBulkInput.PageDataInfo pageInfo = new VarLenColumnBulkInput.PageDataInfo();
    private final VarLenColumnBulkInput.ColumnPrecisionInfo columnPrecInfo;
    private final VarLenColumnBulkEntry entry;
    private final VarLenColumnBulkInput.VarLenColumnBulkInputCallback containerCallback;
    private RecordBatchSizerManager.FieldOverflowStateContainer fieldOverflowStateContainer;
    final VarLenAbstractEntryReader fixedReader;
    final VarLenAbstractEntryReader nullableFixedReader;
    final VarLenAbstractEntryReader variableLengthReader;
    final VarLenAbstractEntryReader nullableVLReader;
    final VarLenAbstractEntryReader dictionaryReader;
    final VarLenAbstractEntryReader nullableDictionaryReader;
    private VarLenOverflowReader overflowReader;

    VarLenBulkPageReader(VarLenColumnBulkInput.PageDataInfo pageInfoInput, VarLenColumnBulkInput.ColumnPrecisionInfo columnPrecInfoInput, VarLenColumnBulkInput.VarLenColumnBulkInputCallback containerCallbackInput, RecordBatchSizerManager.FieldOverflowStateContainer fieldOverflowStateContainer) {
        this.buffer.order(ByteOrder.nativeOrder());
        if (pageInfoInput != null) {
            this.set(pageInfoInput, false);
        }
        this.columnPrecInfo = columnPrecInfoInput;
        this.entry = new VarLenColumnBulkEntry(this.columnPrecInfo);
        this.containerCallback = containerCallbackInput;
        this.fieldOverflowStateContainer = fieldOverflowStateContainer;
        this.fixedReader = new VarLenFixedEntryReader(this.buffer, this.pageInfo, this.columnPrecInfo, this.entry, this.containerCallback);
        this.nullableFixedReader = new VarLenNullableFixedEntryReader(this.buffer, this.pageInfo, this.columnPrecInfo, this.entry, this.containerCallback);
        this.variableLengthReader = new VarLenEntryReader(this.buffer, this.pageInfo, this.columnPrecInfo, this.entry, this.containerCallback);
        this.nullableVLReader = new VarLenNullableEntryReader(this.buffer, this.pageInfo, this.columnPrecInfo, this.entry, this.containerCallback);
        this.dictionaryReader = new VarLenEntryDictionaryReader(this.buffer, this.pageInfo, this.columnPrecInfo, this.entry, this.containerCallback);
        this.nullableDictionaryReader = new VarLenNullableDictionaryReader(this.buffer, this.pageInfo, this.columnPrecInfo, this.entry, this.containerCallback);
        this.overflowReader = this.fieldOverflowStateContainer == null ? null : new VarLenOverflowReader(this.buffer, this.entry, this.containerCallback, fieldOverflowStateContainer);
    }

    final void set(VarLenColumnBulkInput.PageDataInfo pageInfoInput, boolean clear) {
        this.pageInfo.pageData = pageInfoInput.pageData;
        this.pageInfo.pageDataOff = pageInfoInput.pageDataOff;
        this.pageInfo.pageDataLen = pageInfoInput.pageDataLen;
        this.pageInfo.numPageFieldsRead = pageInfoInput.numPageFieldsRead;
        this.pageInfo.definitionLevels = pageInfoInput.definitionLevels;
        this.pageInfo.encodedValueReader = pageInfoInput.encodedValueReader;
        this.pageInfo.numPageValues = pageInfoInput.numPageValues;
        if (clear) {
            this.buffer.clear();
        }
    }

    final VarLenColumnBulkEntry getEntry(int valuesToRead) {
        Preconditions.checkArgument(valuesToRead > 0, "Number of values to read [%s] should be greater than zero", valuesToRead);
        VarLenColumnBulkEntry entry = null;
        if (this.overflowDataAvailable()) {
            entry = this.overflowReader.getEntry(valuesToRead);
            entry.setReadFromPage(false);
            return entry;
        }
        this.deinitOverflowDataIfNeeded();
        if (VarLenColumnBulkInput.ColumnPrecisionType.isPrecTypeFixed(this.columnPrecInfo.columnPrecisionType)) {
            entry = this.getFixedEntry(valuesToRead);
            if (entry == null) {
                if (this.pageInfo.definitionLevels.hasDefinitionLevels()) {
                    try {
                        this.containerCallback.resetDefinitionLevelReader(this.pageInfo.numPageFieldsRead);
                        this.pageInfo.definitionLevels.set(this.containerCallback.getDefinitionLevelsReader(), this.pageInfo.numPageValues - this.pageInfo.numPageFieldsRead);
                    }
                    catch (IOException ie) {
                        throw new DrillRuntimeException(ie);
                    }
                }
                this.columnPrecInfo.columnPrecisionType = VarLenColumnBulkInput.ColumnPrecisionType.DT_PRECISION_IS_VARIABLE;
                entry = this.getVarLenEntry(valuesToRead);
            }
        } else {
            entry = this.getVarLenEntry(valuesToRead);
        }
        if (entry != null) {
            entry.setReadFromPage(true);
            this.pageInfo.numPageFieldsRead += entry.getNumValues();
        }
        return entry;
    }

    private final VarLenColumnBulkEntry getFixedEntry(int valuesToRead) {
        if (this.pageInfo.definitionLevels.hasDefinitionLevels()) {
            return this.nullableFixedReader.getEntry(valuesToRead);
        }
        return this.fixedReader.getEntry(valuesToRead);
    }

    private final VarLenColumnBulkEntry getVarLenEntry(int valuesToRead) {
        if (!this.pageInfo.encodedValueReader.isDefined()) {
            if (this.pageInfo.definitionLevels.hasDefinitionLevels()) {
                return this.nullableVLReader.getEntry(valuesToRead);
            }
            return this.variableLengthReader.getEntry(valuesToRead);
        }
        if (this.pageInfo.definitionLevels.hasDefinitionLevels()) {
            return this.nullableDictionaryReader.getEntry(valuesToRead);
        }
        return this.dictionaryReader.getEntry(valuesToRead);
    }

    private boolean overflowDataAvailable() {
        if (this.overflowReader == null) {
            return false;
        }
        return this.overflowReader.getRemainingOverflowData() > 0;
    }

    private void deinitOverflowDataIfNeeded() {
        if (this.overflowReader != null) {
            this.containerCallback.deinitOverflowData();
            this.overflowReader = null;
            this.fieldOverflowStateContainer = null;
        }
    }
}

