/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.store.parquet.ParquetReaderStats;
import org.apache.drill.exec.store.parquet.columnreaders.ColumnReader;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetColumnMetadata;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetRecordReader;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetSchema;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenBinaryReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLengthColumn;
import org.apache.drill.exec.store.parquet.columnreaders.batchsizing.RecordBatchSizerManager;
import org.apache.drill.exec.vector.NullableIntVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;

public class ReadState {
    private final ParquetSchema schema;
    private final RecordBatchSizerManager batchSizerMgr;
    private final ParquetReaderStats parquetReaderStats;
    private VarLenBinaryReader varLengthReader;
    private List<NullableIntVector> nullFilledVectors;
    private List<ColumnReader<?>> fixedLenColumnReaders = new ArrayList();
    private final long totalNumRecordsToRead;
    private int valuesReadInCurrentBatch;
    private long totalRecordsRead;
    private boolean useAsyncColReader;

    public ReadState(ParquetSchema schema, RecordBatchSizerManager batchSizerMgr, ParquetReaderStats parquetReaderStats, long numRecordsToRead, boolean useAsyncColReader) {
        this.schema = schema;
        this.batchSizerMgr = batchSizerMgr;
        this.parquetReaderStats = parquetReaderStats;
        this.useAsyncColReader = useAsyncColReader;
        if (!schema.isStarQuery()) {
            this.nullFilledVectors = new ArrayList<NullableIntVector>();
        }
        this.totalNumRecordsToRead = numRecordsToRead;
    }

    public void buildReader(ParquetRecordReader reader, OutputMutator output) throws Exception {
        if (this.totalNumRecordsToRead == 0L) {
            for (ParquetColumnMetadata columnMetadata : this.schema.getColumnMetadata()) {
                columnMetadata.buildVector(output);
            }
        } else {
            ArrayList<VarLengthColumn<? extends ValueVector>> varLengthColumns = new ArrayList<VarLengthColumn<? extends ValueVector>>();
            BlockMetaData rowGroupMetadata = this.schema.getRowGroupMetadata();
            if (rowGroupMetadata != null) {
                Map<String, Integer> columnChunkMetadataPositionsInList = this.schema.buildChunkMap(rowGroupMetadata);
                for (ParquetColumnMetadata columnMetadata : this.schema.getColumnMetadata()) {
                    ColumnDescriptor column = columnMetadata.column;
                    columnMetadata.columnChunkMetaData = (ColumnChunkMetaData)rowGroupMetadata.getColumns().get(columnChunkMetadataPositionsInList.get(Arrays.toString(column.getPath())));
                    columnMetadata.buildVector(output);
                    if (!columnMetadata.isFixedLength()) {
                        varLengthColumns.add(columnMetadata.makeVariableWidthReader(reader));
                        continue;
                    }
                    if (columnMetadata.isRepeated()) {
                        varLengthColumns.add(columnMetadata.makeRepeatedFixedWidthReader(reader));
                        continue;
                    }
                    this.fixedLenColumnReaders.add(columnMetadata.makeFixedWidthReader(reader));
                }
                this.varLengthReader = new VarLenBinaryReader(reader, varLengthColumns);
            }
        }
        if (!this.schema.isStarQuery()) {
            this.schema.createNonExistentColumns(output, this.nullFilledVectors);
        }
    }

    public ColumnReader<?> getFirstColumnReader() {
        if (this.fixedLenColumnReaders.size() > 0) {
            return this.fixedLenColumnReaders.get(0);
        }
        if (this.varLengthReader != null && this.varLengthReader.columns.size() > 0) {
            return this.varLengthReader.columns.get(0);
        }
        return null;
    }

    public void resetBatch() {
        for (ColumnReader<?> columnReader : this.fixedLenColumnReaders) {
            columnReader.valuesReadInCurrentPass = 0;
        }
        if (this.varLengthReader != null) {
            for (VarLengthColumn varLengthColumn : this.varLengthReader.columns) {
                varLengthColumn.valuesReadInCurrentPass = 0;
            }
        }
        this.setValuesReadInCurrentPass(0);
    }

    public ParquetSchema schema() {
        return this.schema;
    }

    public RecordBatchSizerManager batchSizerMgr() {
        return this.batchSizerMgr;
    }

    public List<ColumnReader<?>> getFixedLenColumnReaders() {
        return this.fixedLenColumnReaders;
    }

    public long recordsRead() {
        return this.totalRecordsRead;
    }

    public VarLenBinaryReader varLengthReader() {
        return this.varLengthReader;
    }

    public long getTotalRecordsToRead() {
        return this.totalNumRecordsToRead;
    }

    public boolean useAsyncColReader() {
        return this.useAsyncColReader;
    }

    public ParquetReaderStats parquetReaderStats() {
        return this.parquetReaderStats;
    }

    public int getValuesReadInCurrentPass() {
        return this.valuesReadInCurrentBatch;
    }

    public int getRemainingValuesToRead() {
        assert (this.totalNumRecordsToRead >= this.totalRecordsRead);
        return (int)(this.totalNumRecordsToRead - this.totalRecordsRead);
    }

    public void setValuesReadInCurrentPass(int valuesReadInCurrentBatch) {
        this.valuesReadInCurrentBatch = valuesReadInCurrentBatch;
    }

    public void fillNullVectors(int readCount) {
        if (this.nullFilledVectors != null) {
            for (ValueVector valueVector : this.nullFilledVectors) {
                valueVector.getMutator().setValueCount(readCount);
            }
        }
    }

    public void updateCounts(int readCount) {
        this.totalRecordsRead += (long)readCount;
    }

    public void close() {
        if (this.fixedLenColumnReaders != null) {
            for (ColumnReader<?> columnReader : this.fixedLenColumnReaders) {
                columnReader.clear();
            }
            this.fixedLenColumnReaders.clear();
            this.fixedLenColumnReaders = null;
        }
        if (this.varLengthReader != null) {
            for (VarLengthColumn varLengthColumn : this.varLengthReader.columns) {
                varLengthColumn.clear();
            }
            this.varLengthReader.columns.clear();
            this.varLengthReader = null;
        }
    }
}

