/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.parquet.ParquetReaderUtility;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetColumnMetadata;
import org.apache.drill.exec.vector.NullableIntVector;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;

public final class ParquetSchema {
    private final Collection<SchemaPath> selectedCols;
    private final boolean[] columnsFound;
    private final OptionManager options;
    private final int rowGroupIndex;
    private final ParquetMetadata footer;
    private List<ParquetColumnMetadata> selectedColumnMetadata = new ArrayList<ParquetColumnMetadata>();
    private int bitWidthAllFixedFields;
    private boolean allFieldsFixedLength;
    private long groupRecordCount;

    public ParquetSchema(OptionManager options, int rowGroupIndex, ParquetMetadata footer, Collection<SchemaPath> selectedCols) {
        this.options = options;
        this.rowGroupIndex = rowGroupIndex;
        this.selectedCols = selectedCols;
        this.footer = footer;
        this.columnsFound = (boolean[])(selectedCols == null ? null : new boolean[selectedCols.size()]);
    }

    public void buildSchema() {
        BlockMetaData rowGroupMetadata = this.getRowGroupMetadata();
        this.groupRecordCount = rowGroupMetadata == null ? 0L : rowGroupMetadata.getRowCount();
        this.loadParquetSchema();
        this.computeFixedPart();
    }

    private void loadParquetSchema() {
        Map<String, SchemaElement> schemaElements = ParquetReaderUtility.getColNameToSchemaElementMapping(this.footer);
        for (ColumnDescriptor column : this.footer.getFileMetaData().getSchema().getColumns()) {
            ParquetColumnMetadata columnMetadata = new ParquetColumnMetadata(column);
            columnMetadata.resolveDrillType(schemaElements, this.options);
            if (!this.columnSelected(column)) continue;
            this.selectedColumnMetadata.add(columnMetadata);
        }
    }

    private void computeFixedPart() {
        this.allFieldsFixedLength = true;
        for (ParquetColumnMetadata colMd : this.selectedColumnMetadata) {
            if (colMd.isFixedLength()) {
                this.bitWidthAllFixedFields += colMd.length;
                continue;
            }
            this.allFieldsFixedLength = false;
        }
    }

    public boolean isStarQuery() {
        return this.selectedCols == null;
    }

    public ParquetMetadata footer() {
        return this.footer;
    }

    public int getBitWidthAllFixedFields() {
        return this.bitWidthAllFixedFields;
    }

    public boolean allFieldsFixedLength() {
        return this.allFieldsFixedLength;
    }

    public List<ParquetColumnMetadata> getColumnMetadata() {
        return this.selectedColumnMetadata;
    }

    public long getGroupRecordCount() {
        return this.groupRecordCount;
    }

    public BlockMetaData getRowGroupMetadata() {
        if (this.rowGroupIndex == -1) {
            return null;
        }
        return (BlockMetaData)this.footer.getBlocks().get(this.rowGroupIndex);
    }

    private boolean columnSelected(ColumnDescriptor column) {
        if (this.isStarQuery()) {
            return true;
        }
        int i = 0;
        for (SchemaPath expr : this.selectedCols) {
            if (ParquetReaderUtility.getFullColumnPath(column).equalsIgnoreCase(expr.getUnIndexed().toString())) {
                this.columnsFound[i] = true;
                return true;
            }
            ++i;
        }
        return false;
    }

    public void createNonExistentColumns(OutputMutator output, List<NullableIntVector> nullFilledVectors) throws SchemaChangeException {
        ArrayList<SchemaPath> projectedColumns = Lists.newArrayList(this.selectedCols);
        for (int i = 0; i < this.columnsFound.length; ++i) {
            SchemaPath col = (SchemaPath)projectedColumns.get(i);
            assert (col != null);
            if (this.columnsFound[i] || col.equals(SchemaPath.STAR_COLUMN)) continue;
            nullFilledVectors.add(this.createMissingColumn(col, output));
        }
    }

    private NullableIntVector createMissingColumn(SchemaPath col, OutputMutator output) throws SchemaChangeException {
        MaterializedField field = MaterializedField.create(col.toExpr(), Types.optional(TypeProtos.MinorType.INT));
        return (NullableIntVector)output.addField(field, TypeHelper.getValueVectorClass(TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL));
    }

    Map<String, Integer> buildChunkMap(BlockMetaData rowGroupMetadata) {
        HashMap<String, Integer> columnChunkMetadataPositionsInList = new HashMap<String, Integer>();
        int colChunkIndex = 0;
        for (ColumnChunkMetaData colChunk : rowGroupMetadata.getColumns()) {
            columnChunkMetadataPositionsInList.put(Arrays.toString(colChunk.getPath().toArray()), colChunkIndex);
            ++colChunkIndex;
        }
        return columnChunkMetadataPositionsInList;
    }
}

