/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.store.CommonParquetRecordReader;
import org.apache.drill.exec.store.parquet.ParquetReaderUtility;
import org.apache.drill.exec.store.parquet.columnreaders.BatchReader;
import org.apache.drill.exec.store.parquet.columnreaders.ColumnReader;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetSchema;
import org.apache.drill.exec.store.parquet.columnreaders.ReadState;
import org.apache.drill.exec.store.parquet.columnreaders.batchsizing.RecordBatchSizerManager;
import org.apache.drill.exec.util.record.RecordBatchStats;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetRecordReader
extends CommonParquetRecordReader {
    private static final Logger logger = LoggerFactory.getLogger(ParquetRecordReader.class);
    private static final List<SchemaPath> DEFAULT_COLS_TO_READ = ImmutableList.of(SchemaPath.getSimplePath("_DEFAULT_COL_TO_READ_"));
    private final FileSystem fileSystem;
    private final long numRecordsToRead;
    private final Path hadoopPath;
    private final CompressionCodecFactory codecFactory;
    private final int rowGroupIndex;
    private final ParquetReaderUtility.DateCorruptionStatus dateCorruptionStatus;
    private ReadState readState;
    private RecordBatchSizerManager batchSizerMgr;
    private BatchReader batchReader;
    final boolean useAsyncColReader;
    final boolean useAsyncPageReader;
    final boolean useBufferedReader;
    final int bufferedReadSize;
    final boolean useFadvise;
    final boolean enforceTotalSize;
    final long readQueueSize;
    private final boolean useBulkReader;

    public ParquetRecordReader(FragmentContext fragmentContext, Path path, int rowGroupIndex, long numRecordsToRead, FileSystem fs, CompressionCodecFactory codecFactory, ParquetMetadata footer, List<SchemaPath> columns, ParquetReaderUtility.DateCorruptionStatus dateCorruptionStatus) {
        this(fragmentContext, numRecordsToRead, path, rowGroupIndex, fs, codecFactory, footer, columns, dateCorruptionStatus);
    }

    public ParquetRecordReader(FragmentContext fragmentContext, Path path, int rowGroupIndex, FileSystem fs, CompressionCodecFactory codecFactory, ParquetMetadata footer, List<SchemaPath> columns, ParquetReaderUtility.DateCorruptionStatus dateCorruptionStatus) {
        this(fragmentContext, ((BlockMetaData)footer.getBlocks().get(rowGroupIndex)).getRowCount(), path, rowGroupIndex, fs, codecFactory, footer, columns, dateCorruptionStatus);
    }

    public ParquetRecordReader(FragmentContext fragmentContext, long numRecordsToRead, Path path, int rowGroupIndex, FileSystem fs, CompressionCodecFactory codecFactory, ParquetMetadata footer, List<SchemaPath> columns, ParquetReaderUtility.DateCorruptionStatus dateCorruptionStatus) {
        super(footer, fragmentContext);
        this.hadoopPath = path;
        this.fileSystem = fs;
        this.codecFactory = codecFactory;
        this.rowGroupIndex = rowGroupIndex;
        this.dateCorruptionStatus = dateCorruptionStatus;
        this.numRecordsToRead = this.initNumRecordsToRead(numRecordsToRead, rowGroupIndex, footer);
        this.useAsyncColReader = fragmentContext.getOptions().getOption((String)"store.parquet.reader.columnreader.async").bool_val;
        this.useAsyncPageReader = fragmentContext.getOptions().getOption((String)"store.parquet.reader.pagereader.async").bool_val;
        this.useBufferedReader = fragmentContext.getOptions().getOption((String)"store.parquet.reader.pagereader.bufferedread").bool_val;
        this.bufferedReadSize = fragmentContext.getOptions().getOption((String)"store.parquet.reader.pagereader.buffersize").num_val.intValue();
        this.useFadvise = fragmentContext.getOptions().getOption((String)"store.parquet.reader.pagereader.usefadvise").bool_val;
        this.readQueueSize = fragmentContext.getOptions().getOption((String)"store.parquet.reader.pagereader.queuesize").num_val;
        this.enforceTotalSize = fragmentContext.getOptions().getOption((String)"store.parquet.reader.pagereader.enforceTotalSize").bool_val;
        this.useBulkReader = fragmentContext.getOptions().getOption((String)"store.parquet.flat.reader.bulk").bool_val;
        this.setColumns(columns);
    }

    public ParquetReaderUtility.DateCorruptionStatus getDateCorruptionStatus() {
        return this.dateCorruptionStatus;
    }

    public CompressionCodecFactory getCodecFactory() {
        return this.codecFactory;
    }

    public Path getHadoopPath() {
        return this.hadoopPath;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public int getRowGroupIndex() {
        return this.rowGroupIndex;
    }

    public RecordBatchSizerManager getBatchSizesMgr() {
        return this.batchSizerMgr;
    }

    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    public FragmentContext getFragmentContext() {
        return this.fragmentContext;
    }

    public boolean useBulkReader() {
        return this.useBulkReader;
    }

    public ReadState getReadState() {
        return this.readState;
    }

    @Override
    public void setup(OperatorContext operatorContext, OutputMutator output) throws ExecutionSetupException {
        this.operatorContext = operatorContext;
        ParquetSchema schema = new ParquetSchema(this.fragmentContext.getOptions(), this.rowGroupIndex, this.footer, this.isStarQuery() ? null : this.getColumns());
        this.batchSizerMgr = new RecordBatchSizerManager(this.fragmentContext.getOptions(), schema, this.numRecordsToRead, new RecordBatchStats.RecordBatchStatsContext(this.fragmentContext, operatorContext));
        logger.debug("Reading {} records from row group({}) in file {}.", new Object[]{this.numRecordsToRead, this.rowGroupIndex, this.hadoopPath.toUri().getPath()});
        try {
            schema.buildSchema();
            this.batchSizerMgr.setup();
            this.readState = new ReadState(schema, this.batchSizerMgr, this.parquetReaderStats, this.numRecordsToRead, this.useAsyncColReader);
            this.readState.buildReader(this, output);
        }
        catch (Exception e) {
            throw this.handleAndRaise("Failure in setting up reader", e);
        }
        ColumnReader<?> firstColumnStatus = this.readState.getFirstColumnReader();
        this.batchReader = firstColumnStatus == null ? new BatchReader.MockBatchReader(this.readState) : (schema.allFieldsFixedLength() ? new BatchReader.FixedWidthReader(this.readState) : new BatchReader.VariableWidthReader(this.readState));
    }

    @Override
    public void allocate(Map<String, ValueVector> vectorMap) throws OutOfMemoryException {
        this.batchSizerMgr.allocate(vectorMap);
    }

    @Override
    public int next() {
        this.readState.resetBatch();
        Stopwatch timer = Stopwatch.createStarted();
        try {
            int n = this.batchReader.readBatch();
            return n;
        }
        catch (Exception e) {
            throw this.handleAndRaise("\nHadoop path: " + this.hadoopPath.toUri().getPath() + "\nTotal records read: " + this.readState.recordsRead() + "\nRow group index: " + this.rowGroupIndex + "\nRecords to read: " + this.numRecordsToRead, e);
        }
        finally {
            if (this.parquetReaderStats != null) {
                this.parquetReaderStats.timeProcess.addAndGet(timer.elapsed(TimeUnit.NANOSECONDS));
            } else {
                logger.warn("Cannot log batch read timing because no Parquet reader stats tracker is available (probably due to an earlier error during query execution).");
            }
        }
    }

    @Override
    public void close() {
        long recordsRead = this.readState == null ? 0L : this.readState.recordsRead();
        logger.debug("Read {} records out of row group({}) in file '{}'", new Object[]{recordsRead, this.rowGroupIndex, this.hadoopPath.toUri().getPath()});
        if (this.readState != null) {
            this.readState.close();
            this.readState = null;
        }
        if (this.batchSizerMgr != null) {
            this.batchSizerMgr.close();
            this.batchSizerMgr = null;
        }
        this.codecFactory.release();
        this.closeStats(logger, this.hadoopPath);
    }

    @Override
    protected List<SchemaPath> getDefaultColumnsToRead() {
        return DEFAULT_COLS_TO_READ;
    }

    @Override
    public String toString() {
        return "ParquetRecordReader[File=" + this.hadoopPath.toUri() + ", Row group index=" + this.rowGroupIndex + ", Records to read=" + this.numRecordsToRead + ", Total records read=" + (this.readState != null ? this.readState.recordsRead() : -1L) + ", Metadata" + this.footer + "]";
    }
}

