/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import java.util.Map;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.parquet.ParquetReaderUtility;
import org.apache.drill.exec.store.parquet.columnreaders.ColumnReader;
import org.apache.drill.exec.store.parquet.columnreaders.ColumnReaderFactory;
import org.apache.drill.exec.store.parquet.columnreaders.FixedWidthRepeatedReader;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetRecordReader;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetToDrillTypeConverter;
import org.apache.drill.exec.store.parquet.columnreaders.VarLengthValuesColumn;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.RepeatedValueVector;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.schema.PrimitiveType;

public class ParquetColumnMetadata {
    ColumnDescriptor column;
    private SchemaElement se;
    MaterializedField field;
    int length;
    private TypeProtos.MajorType type;
    ColumnChunkMetaData columnChunkMetaData;
    private ValueVector vector;
    public static final int UNDEFINED_LENGTH = -1;

    public ParquetColumnMetadata(ColumnDescriptor column) {
        this.column = column;
    }

    public void resolveDrillType(Map<String, SchemaElement> schemaElements, OptionManager options) {
        this.se = schemaElements.get(ParquetReaderUtility.getFullColumnPath(this.column));
        this.type = ParquetToDrillTypeConverter.toMajorType(this.column.getType(), this.column.getTypeLength(), this.getDataMode(this.column), this.se, options);
        this.field = MaterializedField.create(this.toFieldName(this.column.getPath()).getLastSegment().getNameSegment().getPath(), this.type);
        this.length = this.getDataTypeLength();
    }

    private SchemaPath toFieldName(String[] paths) {
        return SchemaPath.getCompoundPath(paths);
    }

    private TypeProtos.DataMode getDataMode(ColumnDescriptor column) {
        if (this.isRepeated()) {
            return TypeProtos.DataMode.REPEATED;
        }
        if (column.getMaxDefinitionLevel() == 0) {
            return TypeProtos.DataMode.REQUIRED;
        }
        return TypeProtos.DataMode.OPTIONAL;
    }

    public static int getTypeLengthInBits(PrimitiveType.PrimitiveTypeName type) {
        switch (type) {
            case INT64: {
                return 64;
            }
            case INT32: {
                return 32;
            }
            case BOOLEAN: {
                return 1;
            }
            case FLOAT: {
                return 32;
            }
            case DOUBLE: {
                return 64;
            }
            case INT96: {
                return 96;
            }
        }
        throw new IllegalStateException("Length cannot be determined for type " + type);
    }

    public int getDataTypeLength() {
        if (!this.isFixedLength()) {
            return -1;
        }
        if (this.isRepeated()) {
            return -1;
        }
        if (this.column.getType() == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) {
            return this.se.getType_length() * 8;
        }
        return ParquetColumnMetadata.getTypeLengthInBits(this.column.getType());
    }

    public boolean isFixedLength() {
        return this.column.getType() != PrimitiveType.PrimitiveTypeName.BINARY;
    }

    public boolean isRepeated() {
        return this.column.getMaxRepetitionLevel() > 0;
    }

    public MaterializedField getField() {
        return this.field;
    }

    ValueVector buildVector(OutputMutator output) throws SchemaChangeException {
        Class<? extends ValueVector> vectorClass = TypeHelper.getValueVectorClass(this.type.getMinorType(), this.type.getMode());
        this.vector = output.addField(this.field, vectorClass);
        return this.vector;
    }

    ColumnReader<?> makeFixedWidthReader(ParquetRecordReader reader) throws Exception {
        return ColumnReaderFactory.createFixedColumnReader(reader, true, this.column, this.columnChunkMetaData, this.vector, this.se);
    }

    FixedWidthRepeatedReader makeRepeatedFixedWidthReader(ParquetRecordReader reader) throws Exception {
        RepeatedValueVector repeatedVector = (RepeatedValueVector)RepeatedValueVector.class.cast(this.vector);
        ColumnReader<?> dataReader = ColumnReaderFactory.createFixedColumnReader(reader, true, this.column, this.columnChunkMetaData, repeatedVector.getDataVector(), this.se);
        return new FixedWidthRepeatedReader(reader, dataReader, ParquetColumnMetadata.getTypeLengthInBits(this.column.getType()), this.column, this.columnChunkMetaData, false, repeatedVector, this.se);
    }

    VarLengthValuesColumn<?> makeVariableWidthReader(ParquetRecordReader reader) throws ExecutionSetupException {
        return ColumnReaderFactory.getReader(reader, this.column, this.columnChunkMetaData, false, this.vector, this.se);
    }
}

