/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import io.netty.buffer.DrillBuf;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetRecordReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLengthValuesColumn;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;

public abstract class NullableVarLengthValuesColumn<V extends ValueVector>
extends VarLengthValuesColumn<V> {
    int nullsRead;
    boolean currentValNull = false;

    NullableVarLengthValuesColumn(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, V v, SchemaElement schemaElement) throws ExecutionSetupException {
        super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
    }

    @Override
    public abstract boolean setSafe(int var1, DrillBuf var2, int var3, int var4);

    @Override
    public abstract int capacity();

    @Override
    public void reset() {
        this.bytesReadInCurrentPass = 0;
        this.valuesReadInCurrentPass = 0;
        this.nullsRead = 0;
        this.pageReader.valuesReadyToRead = 0;
    }

    @Override
    protected void postPageRead() {
        this.currLengthDeterminingDictVal = null;
        this.pageReader.valuesReadyToRead = 0;
    }

    @Override
    protected boolean readAndStoreValueSizeInformation() {
        this.currentValNull = false;
        if (this.currDefLevel == -1) {
            this.currDefLevel = this.pageReader.definitionLevels.nextInt();
        }
        if (this.columnDescriptor.getMaxDefinitionLevel() > this.currDefLevel) {
            ++this.nullsRead;
            this.variableWidthVector.getMutator().setValueLengthSafe(this.valuesReadInCurrentPass + this.pageReader.valuesReadyToRead, 0);
            this.currentValNull = true;
            return false;
        }
        if (this.usingDictionary) {
            if (this.currLengthDeterminingDictVal == null) {
                this.currLengthDeterminingDictVal = this.pageReader.getDictionaryLengthDeterminingReader().readBytes();
            }
            this.currDecodedValToWrite = this.currLengthDeterminingDictVal;
            this.dataTypeLengthInBits = this.currLengthDeterminingDictVal.length();
        } else {
            this.dataTypeLengthInBits = this.pageReader.pageData.getInt((int)this.pageReader.readyToReadPosInBytes);
        }
        return !this.setSafe(this.valuesReadInCurrentPass + this.pageReader.valuesReadyToRead, this.pageReader.pageData, (int)this.pageReader.readyToReadPosInBytes + 4, this.dataTypeLengthInBits);
    }

    @Override
    public void updateReadyToReadPosition() {
        if (!this.currentValNull) {
            this.pageReader.readyToReadPosInBytes += (long)(this.dataTypeLengthInBits + 4);
        }
        ++this.pageReader.valuesReadyToRead;
        this.currLengthDeterminingDictVal = null;
    }

    @Override
    public void updatePosition() {
        if (!this.currentValNull) {
            this.pageReader.readPosInBytes += (long)(this.dataTypeLengthInBits + 4);
            this.bytesReadInCurrentPass += this.dataTypeLengthInBits;
        }
        this.currentValNull = false;
        ++this.valuesReadInCurrentPass;
    }

    @Override
    protected void readField(long recordsToRead) {
        this.currentValNull = this.variableWidthVector.getAccessor().isNull(this.valuesReadInCurrentPass);
        if (!this.currentValNull) {
            if (this.usingDictionary) {
                this.currDecodedValToWrite = this.pageReader.getDictionaryValueReader().readBytes();
            }
            this.dataTypeLengthInBits = this.variableWidthVector.getAccessor().getValueLength(this.valuesReadInCurrentPass);
            boolean success = this.setSafe(this.valuesReadInCurrentPass, this.pageReader.pageData, (int)this.pageReader.readPosInBytes + 4, this.dataTypeLengthInBits);
            assert (success);
        }
        this.updatePosition();
    }
}

