/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import java.io.IOException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.store.parquet.columnreaders.ColumnReader;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetRecordReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenColumnBulkInput;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.NullableVectorDefinitionSetter;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class NullableColumnReader<V extends ValueVector>
extends ColumnReader<V> {
    private static final Logger logger = LoggerFactory.getLogger(NullableColumnReader.class);
    protected BaseDataValueVector castedBaseVector;
    protected NullableVectorDefinitionSetter castedVectorMutator;
    private int currPageValuesProcessed = 0;
    private final VarLenColumnBulkInput.DefLevelReaderWrapper definitionLevelWrapper = new VarLenColumnBulkInput.DefLevelReaderWrapper();

    NullableColumnReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, V v, SchemaElement schemaElement) throws ExecutionSetupException {
        super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        this.castedBaseVector = (BaseDataValueVector)v;
        this.castedVectorMutator = (NullableVectorDefinitionSetter)((Object)v.getMutator());
    }

    @Override
    public void processPages(long recordsToReadInThisPass) throws IOException {
        if (!this.parentReader.useBulkReader()) {
            this.processPagesOrig(recordsToReadInThisPass);
        } else {
            this.processPagesBulk(recordsToReadInThisPass);
        }
    }

    private final void processPagesOrig(long recordsToReadInThisPass) throws IOException {
        this.readStartInBytes = 0L;
        this.readLength = 0L;
        this.readLengthInBits = 0L;
        this.recordsReadInThisIteration = 0L;
        this.vectorData = this.castedBaseVector.getBuffer();
        int runLength = -1;
        int nullRunLength = -1;
        int currentDefinitionLevel = -1;
        int readCount = 0;
        int writeCount = 0;
        while ((long)readCount < recordsToReadInThisPass && writeCount < this.valueVec.getValueCapacity()) {
            boolean haveMoreData;
            if (!this.pageReader.hasPage() || this.currPageValuesProcessed >= this.pageReader.pageValueCount) {
                if (!this.pageReader.next()) break;
                currentDefinitionLevel = -1;
                this.currPageValuesProcessed = 0;
                this.recordsReadInThisIteration = 0L;
                this.readStartInBytes = 0L;
            }
            nullRunLength = 0;
            runLength = 0;
            if (currentDefinitionLevel < 0) {
                currentDefinitionLevel = this.pageReader.definitionLevels.nextInt();
            }
            boolean bl = haveMoreData = (long)readCount < recordsToReadInThisPass && writeCount + nullRunLength < this.valueVec.getValueCapacity() && this.currPageValuesProcessed < this.pageReader.pageValueCount;
            while (haveMoreData && currentDefinitionLevel < this.columnDescriptor.getMaxDefinitionLevel()) {
                ++this.currPageValuesProcessed;
                if (!(haveMoreData = (long)(++readCount) < recordsToReadInThisPass && writeCount + ++nullRunLength < this.valueVec.getValueCapacity() && this.currPageValuesProcessed < this.pageReader.pageValueCount)) continue;
                currentDefinitionLevel = this.pageReader.definitionLevels.nextInt();
            }
            if (nullRunLength > 0) {
                int writerIndex = ((BaseDataValueVector)this.valueVec).getBuffer().writerIndex();
                this.castedBaseVector.getBuffer().setIndex(0, writerIndex + (int)Math.ceil((double)(nullRunLength * this.dataTypeLengthInBits) / 8.0));
                writeCount += nullRunLength;
                this.valuesReadInCurrentPass += nullRunLength;
                this.recordsReadInThisIteration += (long)nullRunLength;
            }
            boolean bl2 = haveMoreData = (long)readCount < recordsToReadInThisPass && writeCount + runLength < this.valueVec.getValueCapacity() && this.currPageValuesProcessed < this.pageReader.pageValueCount;
            while (haveMoreData && currentDefinitionLevel >= this.columnDescriptor.getMaxDefinitionLevel()) {
                ++this.currPageValuesProcessed;
                this.castedVectorMutator.setIndexDefined(writeCount + ++runLength - 1);
                if (!(haveMoreData = (long)(++readCount) < recordsToReadInThisPass && writeCount + runLength < this.valueVec.getValueCapacity() && this.currPageValuesProcessed < this.pageReader.pageValueCount)) continue;
                currentDefinitionLevel = this.pageReader.definitionLevels.nextInt();
            }
            if (runLength > 0) {
                this.recordsReadInThisIteration += (long)runLength;
                this.readStartInBytes = this.pageReader.readPosInBytes;
                this.readLengthInBits = (long)runLength * (long)this.dataTypeLengthInBits;
                this.readLength = (int)Math.ceil((double)this.readLengthInBits / 8.0);
                this.readField(runLength);
                writeCount += runLength;
                this.valuesReadInCurrentPass += runLength;
                this.pageReader.readPosInBytes = this.readStartInBytes + this.readLength;
            }
            this.pageReader.valuesRead += Math.toIntExact(this.recordsReadInThisIteration);
            this.totalValuesRead += runLength + nullRunLength;
            logger.trace("recordsToReadInThisPass: {} \t Run Length: {} \t Null Run Length: {} \t readCount: {} \t writeCount: {} \t recordsReadInThisIteration: {} \t valuesReadInCurrentPass: {} \t totalValuesRead: {} \t readStartInBytes: {} \t readLength: {} \t pageReader.byteLength: {} \t currPageValuesProcessed: {} \t pageReader.currentPageCount: {}", new Object[]{recordsToReadInThisPass, runLength, nullRunLength, readCount, writeCount, this.recordsReadInThisIteration, this.valuesReadInCurrentPass, this.totalValuesRead, this.readStartInBytes, this.readLength, this.pageReader.byteLength, this.currPageValuesProcessed, this.pageReader.pageValueCount});
        }
        this.valueVec.getMutator().setValueCount(this.valuesReadInCurrentPass);
    }

    private final void processPagesBulk(long recordsToReadInThisPass) throws IOException {
        this.readStartInBytes = 0L;
        this.readLength = 0L;
        this.readLengthInBits = 0L;
        this.recordsReadInThisIteration = 0L;
        this.vectorData = this.castedBaseVector.getBuffer();
        int valueCount = 0;
        int maxValuesToProcess = Math.min((int)recordsToReadInThisPass, this.valueVec.getValueCapacity());
        if (this.pageReader.definitionLevels != null && this.currPageValuesProcessed == 0) {
            this.definitionLevelWrapper.set(this.pageReader.definitionLevels, this.pageReader.pageValueCount);
        }
        while (valueCount < maxValuesToProcess) {
            int idx;
            if (!this.pageReader.hasPage() || this.currPageValuesProcessed == this.pageReader.pageValueCount) {
                if (!this.pageReader.next()) break;
                this.currPageValuesProcessed = 0;
                this.recordsReadInThisIteration = 0L;
                this.readStartInBytes = 0L;
                this.definitionLevelWrapper.set(this.pageReader.definitionLevels, this.pageReader.pageValueCount);
            }
            this.definitionLevelWrapper.readFirstIntegerIfNeeded();
            int numNullValues = 0;
            int numNonNullValues = 0;
            int remaining = maxValuesToProcess - valueCount;
            int currBatchSz = Math.min(remaining, this.pageReader.pageValueCount - this.currPageValuesProcessed);
            assert (currBatchSz > 0);
            for (idx = 0; idx < currBatchSz && this.definitionLevelWrapper.readCurrInteger() != 1; ++idx) {
                this.definitionLevelWrapper.nextIntegerIfNotEOF();
            }
            if ((numNullValues += idx) > 0) {
                int writerIndex = ((BaseDataValueVector)this.valueVec).getBuffer().writerIndex();
                this.castedBaseVector.getBuffer().setIndex(0, writerIndex + (int)Math.ceil((double)(numNullValues * this.dataTypeLengthInBits) / 8.0));
                currBatchSz -= numNullValues;
                this.valuesReadInCurrentPass += numNullValues;
                this.recordsReadInThisIteration += (long)numNullValues;
            }
            for (idx = 0; idx < currBatchSz && this.definitionLevelWrapper.readCurrInteger() != 0; ++idx) {
                this.definitionLevelWrapper.nextIntegerIfNotEOF();
            }
            if ((numNonNullValues += idx) > 0) {
                this.castedVectorMutator.setIndexDefined(valueCount + numNullValues, numNonNullValues);
                this.recordsReadInThisIteration += (long)numNonNullValues;
                this.readStartInBytes = this.pageReader.readPosInBytes;
                this.readLengthInBits = (long)numNonNullValues * (long)this.dataTypeLengthInBits;
                this.readLength = (int)Math.ceil((double)this.readLengthInBits / 8.0);
                this.readField(numNonNullValues);
                this.valuesReadInCurrentPass += numNonNullValues;
                this.pageReader.readPosInBytes = this.readStartInBytes + this.readLength;
            }
            this.pageReader.valuesRead += Math.toIntExact(this.recordsReadInThisIteration);
            this.totalValuesRead += numNonNullValues + numNullValues;
            this.currPageValuesProcessed += numNonNullValues + numNullValues;
            valueCount += numNonNullValues + numNullValues;
            if (!logger.isTraceEnabled()) continue;
            logger.trace("recordsToReadInThisPass: {} \t Run Length: {} \t Null Run Length: {} \t valueCount: {} \t recordsReadInThisIteration: {} \t valuesReadInCurrentPass: {} \t totalValuesRead: {} \t readStartInBytes: {} \t readLength: {} \t pageReader.byteLength: {} \t currPageValuesProcessed: {} \t pageReader.currentPageCount: {}", new Object[]{recordsToReadInThisPass, numNonNullValues, numNullValues, valueCount, this.recordsReadInThisIteration, this.valuesReadInCurrentPass, this.totalValuesRead, this.readStartInBytes, this.readLength, this.pageReader.byteLength, this.currPageValuesProcessed, this.pageReader.pageValueCount});
        }
        this.valueVec.getMutator().setValueCount(this.valuesReadInCurrentPass);
    }

    @Override
    protected abstract void readField(long var1);
}

