/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import io.netty.buffer.DrillBuf;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.store.parquet.columnreaders.AsyncPageReader;
import org.apache.drill.exec.store.parquet.columnreaders.PageReader;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetColumnMetadata;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetRecordReader;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableSet;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.schema.PrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ColumnReader<V extends ValueVector> {
    static final Logger logger = LoggerFactory.getLogger(ColumnReader.class);
    public static final Set<Encoding> DICTIONARY_ENCODINGS = ImmutableSet.of(Encoding.PLAIN_DICTIONARY, Encoding.RLE_DICTIONARY);
    public static final Set<Encoding> VALUE_ENCODINGS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(DICTIONARY_ENCODINGS)).add(Encoding.DELTA_BINARY_PACKED)).add(Encoding.DELTA_BYTE_ARRAY)).add(Encoding.DELTA_LENGTH_BYTE_ARRAY)).build();
    final ParquetRecordReader parentReader;
    final V valueVec;
    final ColumnDescriptor columnDescriptor;
    final ColumnChunkMetaData columnChunkMetaData;
    PageReader pageReader;
    final SchemaElement schemaElement;
    boolean usingDictionary;
    final boolean isFixedLength;
    int totalValuesRead;
    int valuesReadInCurrentPass;
    int dataTypeLengthInBits;
    int bytesReadInCurrentPass;
    protected DrillBuf vectorData;
    int currDefLevel;
    long readStartInBytes = 0L;
    long readLength = 0L;
    long readLengthInBits = 0L;
    long recordsReadInThisIteration = 0L;
    private ExecutorService threadPool;
    volatile boolean isShuttingDown;

    ColumnDescriptor getColumnDescriptor() {
        return this.columnDescriptor;
    }

    protected ColumnReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, V v, SchemaElement schemaElement) throws ExecutionSetupException {
        this.parentReader = parentReader;
        this.columnDescriptor = descriptor;
        this.columnChunkMetaData = columnChunkMetaData;
        this.isFixedLength = fixedLength;
        this.schemaElement = schemaElement;
        this.valueVec = v;
        this.pageReader = parentReader.useAsyncPageReader ? new AsyncPageReader(this, parentReader.getFileSystem(), parentReader.getHadoopPath()) : new PageReader(this, parentReader.getFileSystem(), parentReader.getHadoopPath());
        try {
            this.pageReader.init();
        }
        catch (IOException e) {
            UserException ex = UserException.dataReadError(e).message("Error initializing page reader for Parquet file", new Object[0]).pushContext("Row Group Start: ", this.columnChunkMetaData.getStartingPos()).pushContext("Column: ", this.schemaElement.getName()).pushContext("File: ", this.parentReader.getHadoopPath().toString()).build(logger);
            throw ex;
        }
        if (this.columnDescriptor.getType() != PrimitiveType.PrimitiveTypeName.BINARY) {
            this.dataTypeLengthInBits = this.columnDescriptor.getType() == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY ? this.columnDescriptor.getTypeLength() * 8 : ParquetColumnMetadata.getTypeLengthInBits(this.columnDescriptor.getType());
        }
        this.threadPool = parentReader.getOperatorContext().getScanDecodeExecutor();
    }

    public int getRecordsReadInCurrentPass() {
        return this.valuesReadInCurrentPass;
    }

    public Future<Long> processPagesAsync(long recordsToReadInThisPass) {
        Future<Long> r = this.isShuttingDown ? null : this.threadPool.submit(new ColumnReaderProcessPagesTask(recordsToReadInThisPass));
        return r;
    }

    public void processPages(long recordsToReadInThisPass) throws IOException {
        this.reset();
        if (recordsToReadInThisPass > 0L) {
            do {
                this.determineSize(recordsToReadInThisPass);
            } while ((long)this.valuesReadInCurrentPass < recordsToReadInThisPass && this.pageReader.hasPage());
        }
        logger.trace("Column Reader: {} - Values read in this pass: {} - ", (Object)this.getColumnDescriptor().toString(), (Object)this.valuesReadInCurrentPass);
        this.valueVec.getMutator().setValueCount(this.valuesReadInCurrentPass);
    }

    public void clear() {
        this.isShuttingDown = true;
        this.valueVec.clear();
        this.pageReader.clear();
    }

    public void readValues(long recordsToRead) {
        try {
            this.readField(recordsToRead);
            this.valuesReadInCurrentPass += (int)this.recordsReadInThisIteration;
            this.pageReader.valuesRead += (int)this.recordsReadInThisIteration;
            this.pageReader.readPosInBytes = this.readStartInBytes + this.readLength;
        }
        catch (Exception e) {
            UserException ex = UserException.dataReadError(e).message("Error reading from Parquet file", new Object[0]).pushContext("Row Group Start: ", this.columnChunkMetaData.getStartingPos()).pushContext("Column: ", this.schemaElement.getName()).pushContext("File: ", this.parentReader.getHadoopPath().toString()).build(logger);
            throw ex;
        }
    }

    protected abstract void readField(long var1);

    public boolean determineSize(long recordsReadInCurrentPass) throws IOException {
        if (this.readPage()) {
            return true;
        }
        if (this.processPageData((int)recordsReadInCurrentPass)) {
            return true;
        }
        return this.checkVectorCapacityReached();
    }

    protected Future<Integer> readRecordsAsync(int recordsToRead) {
        Future<Integer> r = this.isShuttingDown ? null : this.threadPool.submit(new ColumnReaderReadRecordsTask(recordsToRead));
        return r;
    }

    protected void readRecords(int recordsToRead) {
        for (int i = 0; i < recordsToRead; ++i) {
            this.readField(i);
        }
        this.pageReader.valuesRead += recordsToRead;
    }

    protected int readRecordsInBulk(int recordsToReadInThisPass) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected boolean recordsRequireDecoding() {
        return this.usingDictionary || !Collections.disjoint(VALUE_ENCODINGS, this.columnChunkMetaData.getEncodings());
    }

    protected boolean processPageData(int recordsToReadInThisPass) throws IOException {
        this.readValues(recordsToReadInThisPass);
        return true;
    }

    public void updatePosition() {
    }

    public void updateReadyToReadPosition() {
    }

    public void reset() {
        this.readStartInBytes = 0L;
        this.readLength = 0L;
        this.readLengthInBits = 0L;
        this.recordsReadInThisIteration = 0L;
        this.bytesReadInCurrentPass = 0;
        this.vectorData = ((BaseDataValueVector)this.valueVec).getBuffer();
    }

    public int capacity() {
        return (int)((double)(this.valueVec.getValueCapacity() * this.dataTypeLengthInBits) / 8.0);
    }

    public Future<Boolean> readPageAsync() {
        Future<Boolean> f = this.threadPool.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ColumnReader.this.readPage();
            }
        });
        return f;
    }

    public boolean readPage() throws IOException {
        if (!this.pageReader.hasPage() || this.totalValuesReadAndReadyToReadInPage() == this.pageReader.pageValueCount) {
            this.readRecords(this.pageReader.valuesReadyToRead);
            if (this.pageReader.hasPage()) {
                this.totalValuesRead += this.pageReader.pageValueCount;
            }
            if (!this.pageReader.next()) {
                this.hitRowGroupEnd();
                return true;
            }
            this.postPageRead();
        }
        return false;
    }

    protected int totalValuesReadAndReadyToReadInPage() {
        return this.pageReader.valuesRead + this.pageReader.valuesReadyToRead;
    }

    protected void postPageRead() {
        this.pageReader.valuesReadyToRead = 0;
    }

    protected void hitRowGroupEnd() {
    }

    protected boolean checkVectorCapacityReached() {
        if (this.bytesReadInCurrentPass + this.dataTypeLengthInBits > this.capacity()) {
            logger.debug("Reached the capacity of the data vector in a variable length value vector.");
            return true;
        }
        return this.valuesReadInCurrentPass > this.valueVec.getValueCapacity();
    }

    public static int readIntLittleEndian(DrillBuf in, int offset) {
        int ch4 = in.getByte(offset) & 0xFF;
        int ch3 = in.getByte(offset + 1) & 0xFF;
        int ch2 = in.getByte(offset + 2) & 0xFF;
        int ch1 = in.getByte(offset + 3) & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    private class ColumnReaderProcessPagesTask
    implements Callable<Long> {
        private final ColumnReader<V> parent;
        private final long recordsToReadInThisPass;

        public ColumnReaderProcessPagesTask(long recordsToReadInThisPass) {
            this.parent = ColumnReader.this;
            this.recordsToReadInThisPass = recordsToReadInThisPass;
        }

        @Override
        public Long call() throws IOException {
            String oldname = Thread.currentThread().getName();
            try {
                Thread.currentThread().setName(oldname + "Decode-" + this.parent.columnChunkMetaData.toString());
                this.parent.processPages(this.recordsToReadInThisPass);
                Long l = this.recordsToReadInThisPass;
                return l;
            }
            finally {
                Thread.currentThread().setName(oldname);
            }
        }
    }

    private class ColumnReaderReadRecordsTask
    implements Callable<Integer> {
        private final ColumnReader<V> parent;
        private final int recordsToRead;

        public ColumnReaderReadRecordsTask(int recordsToRead) {
            this.parent = ColumnReader.this;
            this.recordsToRead = recordsToRead;
        }

        @Override
        public Integer call() throws IOException {
            String oldname = Thread.currentThread().getName();
            try {
                Thread.currentThread().setName("Decode-" + this.parent.columnChunkMetaData.toString());
                this.parent.readRecords(this.recordsToRead);
                Integer n = this.recordsToRead;
                return n;
            }
            finally {
                Thread.currentThread().setName(oldname);
            }
        }
    }
}

