/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.drill.exec.store.parquet.columnreaders.ColumnReader;
import org.apache.drill.exec.store.parquet.columnreaders.ReadState;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public abstract class BatchReader {
    protected final ReadState readState;

    public BatchReader(ReadState readState) {
        this.readState = readState;
    }

    public int readBatch() throws Exception {
        ColumnReader<?> firstColumnStatus = this.readState.getFirstColumnReader();
        int currBatchNumRecords = this.readState.batchSizerMgr().getCurrentRecordsPerBatch();
        long recordsToRead = Math.min(currBatchNumRecords, this.readState.getRemainingValuesToRead());
        int readCount = recordsToRead > 0L ? this.readRecords(firstColumnStatus, recordsToRead) : 0;
        this.readState.fillNullVectors(readCount);
        return readCount;
    }

    protected abstract int readRecords(ColumnReader<?> var1, long var2) throws Exception;

    protected void readAllFixedFields(long recordsToRead) throws Exception {
        Stopwatch timer = Stopwatch.createStarted();
        if (this.readState.useAsyncColReader()) {
            this.readAllFixedFieldsParallel(recordsToRead);
        } else {
            this.readAllFixedFieldsSerial(recordsToRead);
        }
        this.readState.parquetReaderStats().timeFixedColumnRead.addAndGet(timer.elapsed(TimeUnit.NANOSECONDS));
    }

    protected void readAllFixedFieldsSerial(long recordsToRead) throws IOException {
        for (ColumnReader<?> colReader : this.readState.getFixedLenColumnReaders()) {
            colReader.processPages(recordsToRead);
        }
    }

    protected void readAllFixedFieldsParallel(long recordsToRead) throws Exception {
        ArrayList<Future> futures = Lists.newArrayList();
        for (ColumnReader<?> colReader : this.readState.getFixedLenColumnReaders()) {
            Future f = colReader.processPagesAsync(recordsToRead);
            if (f == null) continue;
            futures.add(f);
        }
        Exception exception = null;
        for (Future f : futures) {
            if (exception != null) {
                f.cancel(true);
                continue;
            }
            try {
                f.get();
            }
            catch (Exception e) {
                f.cancel(true);
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static class VariableWidthReader
    extends BatchReader {
        public VariableWidthReader(ReadState readState) {
            super(readState);
        }

        @Override
        protected int readRecords(ColumnReader<?> firstColumnStatus, long recordsToRead) throws Exception {
            long fixedRecordsToRead = this.readState.varLengthReader().readFields(recordsToRead);
            this.readAllFixedFields(fixedRecordsToRead);
            Preconditions.checkArgument(firstColumnStatus == null || firstColumnStatus.getRecordsReadInCurrentPass() == this.readState.getValuesReadInCurrentPass());
            this.readState.updateCounts((int)fixedRecordsToRead);
            return this.readState.getValuesReadInCurrentPass();
        }
    }

    public static class FixedWidthReader
    extends BatchReader {
        public FixedWidthReader(ReadState readState) {
            super(readState);
        }

        @Override
        protected int readRecords(ColumnReader<?> firstColumnStatus, long recordsToRead) throws Exception {
            this.readAllFixedFields(recordsToRead);
            Preconditions.checkNotNull(firstColumnStatus != null);
            this.readState.setValuesReadInCurrentPass(firstColumnStatus.getRecordsReadInCurrentPass());
            this.readState.updateCounts((int)recordsToRead);
            return this.readState.getValuesReadInCurrentPass();
        }
    }

    public static class MockBatchReader
    extends BatchReader {
        public MockBatchReader(ReadState readState) {
            super(readState);
        }

        @Override
        protected int readRecords(ColumnReader<?> firstColumnStatus, long recordsToRead) {
            this.readState.updateCounts((int)recordsToRead);
            return (int)recordsToRead;
        }
    }
}

