/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.StatisticsProvider;
import org.apache.drill.exec.planner.common.DrillStatsTable;
import org.apache.drill.exec.record.SchemaUtil;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.exec.resolver.TypeCastRules;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.ColumnExplorer;
import org.apache.drill.exec.store.parquet.ParquetReaderUtility;
import org.apache.drill.exec.store.parquet.metadata.MetadataBase;
import org.apache.drill.exec.store.parquet.metadata.MetadataVersion;
import org.apache.drill.exec.store.parquet.metadata.Metadata_V4;
import org.apache.drill.metastore.metadata.FileMetadata;
import org.apache.drill.metastore.metadata.MetadataInfo;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.metadata.NonInterestingColumnsMetadata;
import org.apache.drill.metastore.metadata.PartitionMetadata;
import org.apache.drill.metastore.metadata.RowGroupMetadata;
import org.apache.drill.metastore.metadata.TableInfo;
import org.apache.drill.metastore.statistics.BaseStatisticsKind;
import org.apache.drill.metastore.statistics.CollectableColumnStatisticsKind;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.apache.drill.metastore.statistics.ColumnStatisticsKind;
import org.apache.drill.metastore.statistics.StatisticsHolder;
import org.apache.drill.metastore.statistics.TableStatisticsKind;
import org.apache.drill.metastore.util.SchemaPathUtils;
import org.apache.drill.metastore.util.TableMetadataUtils;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.LinkedListMultimap;
import org.apache.drill.shaded.guava.com.google.common.collect.Multimap;
import org.apache.drill.shaded.guava.com.google.common.primitives.Longs;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class ParquetTableMetadataUtils {
    static final List<CollectableColumnStatisticsKind<?>> PARQUET_COLUMN_STATISTICS = ImmutableList.of(ColumnStatisticsKind.MAX_VALUE, ColumnStatisticsKind.MIN_VALUE, ColumnStatisticsKind.NULLS_COUNT);

    private ParquetTableMetadataUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static Map<SchemaPath, ColumnStatistics<?>> addImplicitColumnsStatistics(Map<SchemaPath, ColumnStatistics<?>> columnsStatistics, List<SchemaPath> columns, List<String> partitionValues, OptionManager optionManager, Path location, boolean supportsFileImplicitColumns) {
        ColumnExplorer columnExplorer = new ColumnExplorer(optionManager, columns);
        Map<String, String> implicitColValues = columnExplorer.populateImplicitColumns(location, partitionValues, supportsFileImplicitColumns);
        columnsStatistics = new HashMap(columnsStatistics);
        for (Map.Entry<String, String> partitionValue : implicitColValues.entrySet()) {
            columnsStatistics.put(SchemaPath.getCompoundPath(partitionValue.getKey()), StatisticsProvider.getConstantColumnStatistics(partitionValue.getValue(), TypeProtos.MinorType.VARCHAR));
        }
        return columnsStatistics;
    }

    public static Multimap<Path, RowGroupMetadata> getRowGroupsMetadata(MetadataBase.ParquetTableMetadataBase tableMetadata) {
        LinkedListMultimap<Path, RowGroupMetadata> rowGroups = LinkedListMultimap.create();
        for (MetadataBase.ParquetFileMetadata parquetFileMetadata : tableMetadata.getFiles()) {
            int index = 0;
            for (MetadataBase.RowGroupMetadata rowGroupMetadata : parquetFileMetadata.getRowGroups()) {
                int newIndex;
                if (rowGroupMetadata.isEmpty()) {
                    Preconditions.checkState(parquetFileMetadata.getRowGroups().size() == 1, "Only one empty / fake row group is allowed per file");
                    newIndex = -1;
                } else {
                    newIndex = index++;
                }
                Path filePath = Path.getPathWithoutSchemeAndAuthority((Path)parquetFileMetadata.getPath());
                rowGroups.put(filePath, ParquetTableMetadataUtils.getRowGroupMetadata(tableMetadata, rowGroupMetadata, newIndex, filePath));
            }
        }
        return rowGroups;
    }

    public static RowGroupMetadata getRowGroupMetadata(MetadataBase.ParquetTableMetadataBase tableMetadata, MetadataBase.RowGroupMetadata rowGroupMetadata, int rgIndexInFile, Path location) {
        Map<SchemaPath, ColumnStatistics<?>> columnsStatistics = ParquetTableMetadataUtils.getRowGroupColumnStatistics(tableMetadata, rowGroupMetadata);
        ArrayList rowGroupStatistics = new ArrayList();
        rowGroupStatistics.add(new StatisticsHolder<Long>(rowGroupMetadata.getRowCount(), (BaseStatisticsKind<?>)TableStatisticsKind.ROW_COUNT));
        rowGroupStatistics.add(new StatisticsHolder<Long>(rowGroupMetadata.getStart(), new BaseStatisticsKind("start", true)));
        rowGroupStatistics.add(new StatisticsHolder<Long>(rowGroupMetadata.getLength(), new BaseStatisticsKind("length", true)));
        Map<SchemaPath, TypeProtos.MajorType> columns = ParquetTableMetadataUtils.getRowGroupFields(tableMetadata, rowGroupMetadata);
        Map<SchemaPath, TypeProtos.MajorType> intermediateColumns = ParquetTableMetadataUtils.getIntermediateFields(tableMetadata, rowGroupMetadata);
        TupleSchema schema = new TupleSchema();
        columns.forEach((schemaPath, majorType) -> SchemaPathUtils.addColumnMetadata(schema, schemaPath, majorType, intermediateColumns));
        MetadataInfo metadataInfo = MetadataInfo.builder().type(MetadataType.ROW_GROUP).build();
        return ((RowGroupMetadata.RowGroupMetadataBuilder)((RowGroupMetadata.RowGroupMetadataBuilder)((RowGroupMetadata.RowGroupMetadataBuilder)((RowGroupMetadata.RowGroupMetadataBuilder)((RowGroupMetadata.RowGroupMetadataBuilder)RowGroupMetadata.builder().tableInfo(TableInfo.UNKNOWN_TABLE_INFO)).metadataInfo(metadataInfo)).schema(schema)).columnsStatistics(columnsStatistics)).metadataStatistics(rowGroupStatistics)).hostAffinity(rowGroupMetadata.getHostAffinity()).rowGroupIndex(rgIndexInFile).path(location).build();
    }

    public static FileMetadata getFileMetadata(Collection<RowGroupMetadata> rowGroups) {
        if (rowGroups.isEmpty()) {
            return null;
        }
        ArrayList fileStatistics = new ArrayList();
        fileStatistics.add(new StatisticsHolder<Long>(TableStatisticsKind.ROW_COUNT.mergeStatistics(rowGroups), (BaseStatisticsKind<?>)TableStatisticsKind.ROW_COUNT));
        RowGroupMetadata rowGroupMetadata = rowGroups.iterator().next();
        TupleMetadata schema = rowGroupMetadata.getSchema();
        Set<SchemaPath> columns = rowGroupMetadata.getColumnsStatistics().keySet();
        MetadataInfo metadataInfo = MetadataInfo.builder().type(MetadataType.FILE).build();
        return ((FileMetadata.FileMetadataBuilder)((FileMetadata.FileMetadataBuilder)((FileMetadata.FileMetadataBuilder)((FileMetadata.FileMetadataBuilder)((FileMetadata.FileMetadataBuilder)FileMetadata.builder().tableInfo(rowGroupMetadata.getTableInfo())).metadataInfo(metadataInfo)).path(rowGroupMetadata.getPath()).schema(schema)).columnsStatistics(TableMetadataUtils.mergeColumnsStatistics(rowGroups, columns, PARQUET_COLUMN_STATISTICS))).metadataStatistics(fileStatistics)).build();
    }

    public static PartitionMetadata getPartitionMetadata(SchemaPath partitionColumn, List<FileMetadata> files) {
        HashSet<Path> locations = new HashSet<Path>();
        HashSet<SchemaPath> columns = new HashSet<SchemaPath>();
        for (FileMetadata file : files) {
            columns.addAll(file.getColumnsStatistics().keySet());
            locations.add(file.getPath());
        }
        FileMetadata fileMetadata = files.iterator().next();
        MetadataInfo metadataInfo = MetadataInfo.builder().type(MetadataType.PARTITION).build();
        return ((PartitionMetadata.PartitionMetadataBuilder)((PartitionMetadata.PartitionMetadataBuilder)((PartitionMetadata.PartitionMetadataBuilder)((PartitionMetadata.PartitionMetadataBuilder)((PartitionMetadata.PartitionMetadataBuilder)PartitionMetadata.builder().tableInfo(fileMetadata.getTableInfo())).metadataInfo(metadataInfo)).column(partitionColumn).schema(fileMetadata.getSchema())).columnsStatistics(TableMetadataUtils.mergeColumnsStatistics(files, columns, PARQUET_COLUMN_STATISTICS))).metadataStatistics(Collections.singletonList(new StatisticsHolder<Long>(TableStatisticsKind.ROW_COUNT.mergeStatistics(files), (BaseStatisticsKind<?>)TableStatisticsKind.ROW_COUNT)))).partitionValues(Collections.emptyList()).locations(locations).build();
    }

    public static Map<SchemaPath, ColumnStatistics<?>> getRowGroupColumnStatistics(MetadataBase.ParquetTableMetadataBase tableMetadata, MetadataBase.RowGroupMetadata rowGroupMetadata) {
        HashMap columnsStatistics = new HashMap();
        for (MetadataBase.ColumnMetadata columnMetadata : rowGroupMetadata.getColumns()) {
            SchemaPath colPath = SchemaPath.getCompoundPath(columnMetadata.getName());
            Long nulls = columnMetadata.getNulls();
            if (ParquetTableMetadataUtils.hasInvalidStatistics(columnMetadata, tableMetadata)) {
                nulls = -1L;
            }
            PrimitiveType.PrimitiveTypeName primitiveType = ParquetTableMetadataUtils.getPrimitiveTypeName(tableMetadata, columnMetadata);
            OriginalType originalType = ParquetTableMetadataUtils.getOriginalType(tableMetadata, columnMetadata);
            TypeProtos.MinorType type = ParquetReaderUtility.getMinorType(primitiveType, originalType);
            ArrayList statistics = new ArrayList();
            statistics.add(new StatisticsHolder<Object>(ParquetTableMetadataUtils.getValue(columnMetadata.getMinValue(), primitiveType, originalType), (BaseStatisticsKind<?>)ColumnStatisticsKind.MIN_VALUE));
            statistics.add(new StatisticsHolder<Object>(ParquetTableMetadataUtils.getValue(columnMetadata.getMaxValue(), primitiveType, originalType), (BaseStatisticsKind<?>)ColumnStatisticsKind.MAX_VALUE));
            statistics.add(new StatisticsHolder<Long>(nulls, (BaseStatisticsKind<?>)ColumnStatisticsKind.NULLS_COUNT));
            columnsStatistics.put(colPath, new ColumnStatistics(statistics, type));
        }
        return columnsStatistics;
    }

    private static boolean hasInvalidStatistics(MetadataBase.ColumnMetadata column, MetadataBase.ParquetTableMetadataBase tableMetadata) {
        return !column.isNumNullsSet() || (column.getMinValue() == null || column.getMaxValue() == null) && column.getNulls() == 0L && tableMetadata.getRepetition(column.getName()) == Type.Repetition.REQUIRED;
    }

    public static NonInterestingColumnsMetadata getNonInterestingColumnsMeta(MetadataBase.ParquetTableMetadataBase parquetTableMetadata) {
        HashMap columnsStatistics = new HashMap();
        if (parquetTableMetadata instanceof Metadata_V4.ParquetTableMetadata_v4) {
            ConcurrentHashMap<Metadata_V4.ColumnTypeMetadata_v4.Key, Metadata_V4.ColumnTypeMetadata_v4> columnTypeInfoMap = ((Metadata_V4.ParquetTableMetadata_v4)parquetTableMetadata).getColumnTypeInfoMap();
            if (columnTypeInfoMap == null) {
                return new NonInterestingColumnsMetadata(columnsStatistics);
            }
            for (Metadata_V4.ColumnTypeMetadata_v4 columnTypeMetadata : columnTypeInfoMap.values()) {
                if (columnTypeMetadata.isInteresting) continue;
                SchemaPath schemaPath = SchemaPath.getCompoundPath(columnTypeMetadata.name);
                ArrayList statistics = new ArrayList();
                statistics.add(new StatisticsHolder<Long>(Long.valueOf(-1L), (BaseStatisticsKind<?>)ColumnStatisticsKind.NULLS_COUNT));
                PrimitiveType.PrimitiveTypeName primitiveType = columnTypeMetadata.primitiveType;
                OriginalType originalType = columnTypeMetadata.originalType;
                TypeProtos.MinorType type = ParquetReaderUtility.getMinorType(primitiveType, originalType);
                columnsStatistics.put(schemaPath, new ColumnStatistics(statistics, type));
            }
            return new NonInterestingColumnsMetadata(columnsStatistics);
        }
        return new NonInterestingColumnsMetadata(columnsStatistics);
    }

    public static Object getValue(Object value, PrimitiveType.PrimitiveTypeName primitiveType, OriginalType originalType) {
        if (value != null) {
            switch (primitiveType) {
                case BOOLEAN: {
                    return Boolean.parseBoolean(value.toString());
                }
                case INT32: {
                    if (originalType == OriginalType.DATE) {
                        return ParquetTableMetadataUtils.convertToDrillDateValue(ParquetTableMetadataUtils.getInt(value));
                    }
                    if (originalType == OriginalType.DECIMAL) {
                        return BigInteger.valueOf(ParquetTableMetadataUtils.getInt(value).intValue());
                    }
                    return ParquetTableMetadataUtils.getInt(value);
                }
                case INT64: {
                    if (originalType == OriginalType.DECIMAL) {
                        return BigInteger.valueOf(ParquetTableMetadataUtils.getLong(value));
                    }
                    if (originalType == OriginalType.TIME_MICROS) {
                        return ParquetTableMetadataUtils.getInt(value);
                    }
                    return ParquetTableMetadataUtils.getLong(value);
                }
                case FLOAT: {
                    return ParquetTableMetadataUtils.getFloat(value);
                }
                case DOUBLE: {
                    return ParquetTableMetadataUtils.getDouble(value);
                }
                case INT96: {
                    return new String(ParquetTableMetadataUtils.getBytes(value));
                }
                case BINARY: 
                case FIXED_LEN_BYTE_ARRAY: {
                    if (originalType == OriginalType.DECIMAL) {
                        byte[] bytes = ParquetTableMetadataUtils.getBytes(value);
                        return bytes.length == 0 ? BigInteger.ZERO : new BigInteger(bytes);
                    }
                    if (originalType == OriginalType.INTERVAL) {
                        return ParquetTableMetadataUtils.getBytes(value);
                    }
                    return new String(ParquetTableMetadataUtils.getBytes(value));
                }
            }
        }
        return null;
    }

    private static byte[] getBytes(Object value) {
        if (value instanceof Binary) {
            return ((Binary)value).getBytes();
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            return ((String)value).getBytes(StandardCharsets.UTF_8);
        }
        if (value instanceof Map) {
            String bytesString = (String)((Map)value).get("bytes");
            if (bytesString != null) {
                return bytesString.getBytes(StandardCharsets.UTF_8);
            }
        } else {
            if (value instanceof Long) {
                return Longs.toByteArray((Long)value);
            }
            if (value instanceof Integer) {
                return Longs.toByteArray(((Integer)value).intValue());
            }
            if (value instanceof Float) {
                return BigDecimal.valueOf(((Float)value).floatValue()).unscaledValue().toByteArray();
            }
            if (value instanceof Double) {
                return BigDecimal.valueOf((Double)value).unscaledValue().toByteArray();
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot obtain bytes using value %s", value));
    }

    private static Integer getInt(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt(value.toString());
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return bytes.length == 0 ? 0 : new BigInteger(bytes).intValue();
        }
        if (value instanceof Binary) {
            byte[] bytes = ((Binary)value).getBytes();
            return bytes.length == 0 ? 0 : new BigInteger(bytes).intValue();
        }
        throw new UnsupportedOperationException(String.format("Cannot obtain Integer using value %s", value));
    }

    private static Long getLong(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.parseLong(value.toString());
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return bytes.length == 0 ? 0L : new BigInteger(bytes).longValue();
        }
        if (value instanceof Binary) {
            byte[] bytes = ((Binary)value).getBytes();
            return bytes.length == 0 ? 0L : new BigInteger(bytes).longValue();
        }
        throw new UnsupportedOperationException(String.format("Cannot obtain Integer using value %s", value));
    }

    private static Float getFloat(Object value) {
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            return Float.valueOf(Float.parseFloat(value.toString()));
        }
        throw new UnsupportedOperationException(String.format("Cannot obtain Integer using value %s", value));
    }

    private static Double getDouble(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            return Double.parseDouble(value.toString());
        }
        throw new UnsupportedOperationException(String.format("Cannot obtain Integer using value %s", value));
    }

    private static long convertToDrillDateValue(int dateValue) {
        return (long)dateValue * 86400000L;
    }

    public static Map<SchemaPath, TypeProtos.MajorType> getFileFields(MetadataBase.ParquetTableMetadataBase parquetTableMetadata, MetadataBase.ParquetFileMetadata file) {
        return ParquetTableMetadataUtils.getRowGroupFields(parquetTableMetadata, file.getRowGroups().iterator().next());
    }

    public static Map<SchemaPath, TypeProtos.MajorType> getRowGroupFields(MetadataBase.ParquetTableMetadataBase parquetTableMetadata, MetadataBase.RowGroupMetadata rowGroup) {
        LinkedHashMap<SchemaPath, TypeProtos.MajorType> columns = new LinkedHashMap<SchemaPath, TypeProtos.MajorType>();
        if (new MetadataVersion(parquetTableMetadata.getMetadataVersion()).isHigherThan(4, 0) && !((Metadata_V4.ParquetTableMetadata_v4)parquetTableMetadata).isAllColumnsInteresting()) {
            for (MetadataBase.ColumnTypeMetadata columnTypeMetadata : parquetTableMetadata.getColumnTypeInfoList()) {
                Metadata_V4.ColumnTypeMetadata_v4 metadata = (Metadata_V4.ColumnTypeMetadata_v4)columnTypeMetadata;
                if (metadata.isInteresting) continue;
                TypeProtos.MajorType columnType = ParquetTableMetadataUtils.getColumnType(metadata.name, metadata.primitiveType, metadata.originalType, parquetTableMetadata);
                SchemaPath columnPath = SchemaPath.getCompoundPath(metadata.name);
                ParquetTableMetadataUtils.putType(columns, columnPath, columnType);
            }
        }
        for (MetadataBase.ColumnMetadata columnMetadata : rowGroup.getColumns()) {
            TypeProtos.MajorType columnType = ParquetTableMetadataUtils.getColumnType(parquetTableMetadata, columnMetadata);
            SchemaPath columnPath = SchemaPath.getCompoundPath(columnMetadata.getName());
            ParquetTableMetadataUtils.putType(columns, columnPath, columnType);
        }
        return columns;
    }

    private static TypeProtos.MajorType getColumnType(MetadataBase.ParquetTableMetadataBase parquetTableMetadata, MetadataBase.ColumnMetadata column) {
        PrimitiveType.PrimitiveTypeName primitiveType = ParquetTableMetadataUtils.getPrimitiveTypeName(parquetTableMetadata, column);
        OriginalType originalType = ParquetTableMetadataUtils.getOriginalType(parquetTableMetadata, column);
        String[] name = column.getName();
        return ParquetTableMetadataUtils.getColumnType(name, primitiveType, originalType, parquetTableMetadata);
    }

    private static TypeProtos.MajorType getColumnType(String[] name, PrimitiveType.PrimitiveTypeName primitiveType, OriginalType originalType, MetadataBase.ParquetTableMetadataBase parquetTableMetadata) {
        int precision = 0;
        int scale = 0;
        MetadataVersion metadataVersion = new MetadataVersion(parquetTableMetadata.getMetadataVersion());
        if (metadataVersion.isAtLeast(3, 0)) {
            scale = parquetTableMetadata.getScale(name);
            precision = parquetTableMetadata.getPrecision(name);
        }
        TypeProtos.DataMode mode = ParquetTableMetadataUtils.getDataMode(parquetTableMetadata, metadataVersion, name);
        return TypeProtos.MajorType.newBuilder(ParquetReaderUtility.getType(primitiveType, originalType, precision, scale)).setMode(mode).build();
    }

    private static TypeProtos.DataMode getDataMode(MetadataBase.ParquetTableMetadataBase tableMetadata, MetadataVersion metadataVersion, String[] name) {
        TypeProtos.DataMode mode;
        if (metadataVersion.isAtLeast(4, 2)) {
            mode = ParquetReaderUtility.getDataMode(tableMetadata.getRepetition(name));
        } else if (metadataVersion.isAtLeast(3, 0)) {
            int definitionLevel = tableMetadata.getDefinitionLevel(name);
            int repetitionLevel = tableMetadata.getRepetitionLevel(name);
            mode = repetitionLevel >= 1 ? TypeProtos.DataMode.REPEATED : (repetitionLevel == 0 && definitionLevel == 0 ? TypeProtos.DataMode.REQUIRED : TypeProtos.DataMode.OPTIONAL);
        } else {
            mode = TypeProtos.DataMode.OPTIONAL;
        }
        return mode;
    }

    public static Map<SchemaPath, TypeProtos.MajorType> getIntermediateFields(MetadataBase.ParquetTableMetadataBase parquetTableMetadata, MetadataBase.RowGroupMetadata rowGroup) {
        LinkedHashMap<SchemaPath, TypeProtos.MajorType> columns = new LinkedHashMap<SchemaPath, TypeProtos.MajorType>();
        MetadataVersion metadataVersion = new MetadataVersion(parquetTableMetadata.getMetadataVersion());
        boolean hasParentTypes = metadataVersion.isAtLeast(4, 1);
        if (!hasParentTypes) {
            return Collections.emptyMap();
        }
        for (MetadataBase.ColumnMetadata columnMetadata : rowGroup.getColumns()) {
            Metadata_V4.ColumnTypeMetadata_v4 columnTypeMetadata = ((Metadata_V4.ParquetTableMetadata_v4)parquetTableMetadata).getColumnTypeInfo(columnMetadata.getName());
            List<OriginalType> parentTypes = columnTypeMetadata.parentTypes;
            List<TypeProtos.MajorType> drillTypes = ParquetReaderUtility.getComplexTypes(parentTypes);
            for (int i = 0; i < drillTypes.size(); ++i) {
                SchemaPath columnPath = SchemaPath.getCompoundPath(i + 1, columnMetadata.getName());
                TypeProtos.MajorType drillType = drillTypes.get(i);
                ParquetTableMetadataUtils.putType(columns, columnPath, drillType);
            }
        }
        return columns;
    }

    public static OriginalType getOriginalType(MetadataBase.ParquetTableMetadataBase parquetTableMetadata, MetadataBase.ColumnMetadata column) {
        OriginalType originalType = column.getOriginalType();
        if (originalType == null) {
            originalType = parquetTableMetadata.getOriginalType(column.getName());
        }
        return originalType;
    }

    public static PrimitiveType.PrimitiveTypeName getPrimitiveTypeName(MetadataBase.ParquetTableMetadataBase parquetTableMetadata, MetadataBase.ColumnMetadata column) {
        PrimitiveType.PrimitiveTypeName primitiveType = column.getPrimitiveType();
        if (primitiveType == null) {
            primitiveType = parquetTableMetadata.getPrimitiveType(column.getName());
        }
        return primitiveType;
    }

    static Map<SchemaPath, TypeProtos.MajorType> resolveFields(MetadataBase.ParquetTableMetadataBase parquetTableMetadata) {
        LinkedHashMap<SchemaPath, TypeProtos.MajorType> columns = new LinkedHashMap<SchemaPath, TypeProtos.MajorType>();
        for (MetadataBase.ParquetFileMetadata parquetFileMetadata : parquetTableMetadata.getFiles()) {
            Map<SchemaPath, TypeProtos.MajorType> fileColumns = ParquetTableMetadataUtils.getFileFields(parquetTableMetadata, parquetFileMetadata);
            fileColumns.forEach((columnPath, type) -> ParquetTableMetadataUtils.putType(columns, columnPath, type));
        }
        return columns;
    }

    static Map<SchemaPath, TypeProtos.MajorType> resolveIntermediateFields(MetadataBase.ParquetTableMetadataBase parquetTableMetadata) {
        LinkedHashMap<SchemaPath, TypeProtos.MajorType> columns = new LinkedHashMap<SchemaPath, TypeProtos.MajorType>();
        for (MetadataBase.ParquetFileMetadata parquetFileMetadata : parquetTableMetadata.getFiles()) {
            Map<SchemaPath, TypeProtos.MajorType> fileColumns = ParquetTableMetadataUtils.getIntermediateFields(parquetTableMetadata, parquetFileMetadata.getRowGroups().iterator().next());
            fileColumns.forEach((columnPath, type) -> ParquetTableMetadataUtils.putType(columns, columnPath, type));
        }
        return columns;
    }

    private static void putType(Map<SchemaPath, TypeProtos.MajorType> columns, SchemaPath columnPath, TypeProtos.MajorType type) {
        TypeProtos.MinorType leastRestrictiveType;
        TypeProtos.MajorType majorType = columns.get(columnPath);
        if (majorType == null) {
            columns.put(columnPath, type);
        } else if (!majorType.equals(type) && (leastRestrictiveType = TypeCastRules.getLeastRestrictiveType(majorType.getMinorType(), type.getMinorType())) != majorType.getMinorType()) {
            columns.put(columnPath, type);
        }
    }

    public static Map<SchemaPath, ColumnStatistics<?>> getColumnStatistics(TupleMetadata schema, DrillStatsTable statistics) {
        List<SchemaPath> schemaPaths = SchemaUtil.getSchemaPaths(schema);
        return schemaPaths.stream().collect(Collectors.toMap(Function.identity(), schemaPath -> new ColumnStatistics(DrillStatsTable.getEstimatedColumnStats(statistics, schemaPath), SchemaPathUtils.getColumnMetadata(schemaPath, schema).type())));
    }
}

