/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.LinkedList;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.ColumnExplorer;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.parquet.AbstractParquetRowGroupScan;
import org.apache.drill.exec.store.parquet.ParquetFormatConfig;
import org.apache.drill.exec.store.parquet.ParquetFormatPlugin;
import org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import org.apache.drill.exec.store.parquet.RowGroupReadEntry;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

@JsonTypeName(value="parquet-row-group-scan")
public class ParquetRowGroupScan
extends AbstractParquetRowGroupScan {
    public static final String OPERATOR_TYPE = "PARQUET_ROW_GROUP_SCAN";
    private final ParquetFormatPlugin formatPlugin;
    private final ParquetFormatConfig formatConfig;

    @JsonCreator
    public ParquetRowGroupScan(@JacksonInject StoragePluginRegistry registry, @JsonProperty(value="userName") String userName, @JsonProperty(value="storageConfig") StoragePluginConfig storageConfig, @JsonProperty(value="formatConfig") FormatPluginConfig formatConfig, @JsonProperty(value="rowGroupReadEntries") LinkedList<RowGroupReadEntry> rowGroupReadEntries, @JsonProperty(value="columns") List<SchemaPath> columns, @JsonProperty(value="readerConfig") ParquetReaderConfig readerConfig, @JsonProperty(value="selectionRoot") Path selectionRoot, @JsonProperty(value="filter") LogicalExpression filter, @JsonProperty(value="schema") TupleMetadata schema) throws ExecutionSetupException {
        this(userName, registry.resolveFormat(storageConfig, formatConfig, ParquetFormatPlugin.class), rowGroupReadEntries, columns, readerConfig, selectionRoot, filter, schema);
    }

    public ParquetRowGroupScan(String userName, ParquetFormatPlugin formatPlugin, List<RowGroupReadEntry> rowGroupReadEntries, List<SchemaPath> columns, ParquetReaderConfig readerConfig, Path selectionRoot, LogicalExpression filter, TupleMetadata schema) {
        super(userName, rowGroupReadEntries, columns, readerConfig, filter, selectionRoot, schema);
        this.formatPlugin = Preconditions.checkNotNull(formatPlugin, "Could not find format config for the given configuration");
        this.formatConfig = formatPlugin.getConfig();
    }

    @JsonProperty
    public StoragePluginConfig getStorageConfig() {
        return this.formatPlugin.getStorageConfig();
    }

    @JsonProperty
    public ParquetFormatConfig getFormatConfig() {
        return this.formatConfig;
    }

    @JsonIgnore
    public ParquetFormatPlugin getStorageEngine() {
        return this.formatPlugin;
    }

    @Override
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument(children.isEmpty());
        return new ParquetRowGroupScan(this.getUserName(), this.formatPlugin, this.rowGroupReadEntries, this.columns, this.readerConfig, this.selectionRoot, this.filter, this.schema);
    }

    @Override
    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    @Override
    public AbstractParquetRowGroupScan copy(List<SchemaPath> columns) {
        return new ParquetRowGroupScan(this.getUserName(), this.formatPlugin, this.rowGroupReadEntries, columns, this.readerConfig, this.selectionRoot, this.filter, this.schema);
    }

    @Override
    public Configuration getFsConf(RowGroupReadEntry rowGroupReadEntry) {
        return this.formatPlugin.getFsConf();
    }

    @Override
    public boolean supportsFileImplicitColumns() {
        return this.selectionRoot != null;
    }

    @Override
    public List<String> getPartitionValues(RowGroupReadEntry rowGroupReadEntry) {
        return ColumnExplorer.listPartitionValues(rowGroupReadEntry.getPath(), this.selectionRoot, false);
    }
}

