/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.store.parquet.BaseParquetMetadataProvider;
import org.apache.drill.metastore.metadata.BaseMetadata;
import org.apache.drill.metastore.metadata.LocationProvider;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.apache.drill.metastore.statistics.ColumnStatisticsKind;
import org.apache.drill.metastore.statistics.TableStatisticsKind;
import org.apache.drill.metastore.util.SchemaPathUtils;
import org.apache.drill.shaded.guava.com.google.common.collect.HashBasedTable;
import org.apache.drill.shaded.guava.com.google.common.collect.Table;
import org.apache.hadoop.fs.Path;

public class ParquetGroupScanStatistics<T extends BaseMetadata> {
    private Table<Path, SchemaPath, Object> partitionValueMap;
    private Map<SchemaPath, TypeProtos.MajorType> partitionColTypeMap;
    private Map<SchemaPath, MutableLong> columnValueCounts;
    private long rowCount;

    public ParquetGroupScanStatistics(Collection<T> rowGroupInfos) {
        this.collect(rowGroupInfos);
    }

    public ParquetGroupScanStatistics(ParquetGroupScanStatistics<T> that) {
        this.partitionValueMap = HashBasedTable.create(that.partitionValueMap);
        this.partitionColTypeMap = new HashMap<SchemaPath, TypeProtos.MajorType>(that.partitionColTypeMap);
        this.columnValueCounts = new HashMap<SchemaPath, MutableLong>(that.columnValueCounts);
        this.rowCount = that.rowCount;
    }

    public long getColumnValueCount(SchemaPath column) {
        MutableLong count = this.columnValueCounts.get(column);
        return count != null ? count.getValue() : 0L;
    }

    public List<SchemaPath> getPartitionColumns() {
        return new ArrayList<SchemaPath>(this.partitionColTypeMap.keySet());
    }

    public TypeProtos.MajorType getTypeForColumn(SchemaPath schemaPath) {
        return this.partitionColTypeMap.get(schemaPath);
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public Object getPartitionValue(Path path, SchemaPath column) {
        Object partitionValue = this.partitionValueMap.get(path, column);
        if (partitionValue == BaseParquetMetadataProvider.NULL_VALUE) {
            return null;
        }
        return partitionValue;
    }

    public Map<Path, Object> getPartitionPaths(SchemaPath column) {
        return this.partitionValueMap.column(column);
    }

    public void collect(Collection<T> metadataList) {
        this.resetHolders();
        boolean first = true;
        for (BaseMetadata metadata : metadataList) {
            long localRowCount = TableStatisticsKind.ROW_COUNT.getValue(metadata);
            for (Map.Entry<SchemaPath, ColumnStatistics<?>> columnsStatistics : metadata.getColumnsStatistics().entrySet()) {
                boolean partitionColumn;
                SchemaPath schemaPath = columnsStatistics.getKey();
                ColumnStatistics<?> statistics = columnsStatistics.getValue();
                MutableLong emptyCount = new MutableLong();
                MutableLong previousCount = this.columnValueCounts.putIfAbsent(schemaPath, emptyCount);
                if (previousCount == null) {
                    previousCount = emptyCount;
                }
                Long nullsNum = ColumnStatisticsKind.NULLS_COUNT.getFrom(statistics);
                if (previousCount.longValue() != -1L && nullsNum != null && nullsNum != -1L) {
                    previousCount.add(localRowCount - nullsNum);
                } else {
                    previousCount.setValue(-1L);
                }
                ColumnMetadata columnMetadata = SchemaPathUtils.getColumnMetadata(schemaPath, metadata.getSchema());
                TypeProtos.MajorType majorType = columnMetadata != null ? columnMetadata.majorType() : null;
                boolean bl = partitionColumn = majorType != null && this.checkForPartitionColumn(statistics, first, localRowCount, majorType, schemaPath);
                if (partitionColumn) {
                    Object value = this.partitionValueMap.get(((LocationProvider)((Object)metadata)).getPath(), schemaPath);
                    Object currentValue = ColumnStatisticsKind.MAX_VALUE.getFrom(statistics);
                    if (value != null && value != BaseParquetMetadataProvider.NULL_VALUE) {
                        if (value == currentValue) continue;
                        this.partitionColTypeMap.remove(schemaPath);
                        continue;
                    }
                    if (localRowCount == ColumnStatisticsKind.NULLS_COUNT.getFrom(statistics)) {
                        this.partitionValueMap.put(((LocationProvider)((Object)metadata)).getPath(), schemaPath, BaseParquetMetadataProvider.NULL_VALUE);
                        continue;
                    }
                    this.partitionValueMap.put(((LocationProvider)((Object)metadata)).getPath(), schemaPath, currentValue);
                    continue;
                }
                this.partitionColTypeMap.remove(schemaPath);
            }
            this.rowCount += localRowCount;
            first = false;
        }
    }

    private void resetHolders() {
        this.partitionValueMap = HashBasedTable.create();
        this.partitionColTypeMap = new HashMap<SchemaPath, TypeProtos.MajorType>();
        this.columnValueCounts = new HashMap<SchemaPath, MutableLong>();
        this.rowCount = 0L;
    }

    private boolean checkForPartitionColumn(ColumnStatistics<?> columnStatistics, boolean first, long rowCount, TypeProtos.MajorType type, SchemaPath schemaPath) {
        if (first) {
            if (this.hasSingleValue(columnStatistics, rowCount)) {
                this.partitionColTypeMap.put(schemaPath, type);
                return true;
            }
            return false;
        }
        if (!this.partitionColTypeMap.containsKey(schemaPath)) {
            return false;
        }
        if (!this.hasSingleValue(columnStatistics, rowCount)) {
            this.partitionColTypeMap.remove(schemaPath);
            return false;
        }
        if (ObjectUtils.notEqual((Object)this.partitionColTypeMap.get(schemaPath), (Object)type)) {
            this.partitionColTypeMap.remove(schemaPath);
            return false;
        }
        return true;
    }

    private boolean hasSingleValue(ColumnStatistics<?> columnStatistics, long rowCount) {
        return columnStatistics != null && this.isSingleVal(columnStatistics, rowCount);
    }

    private boolean isSingleVal(ColumnStatistics<?> columnStatistics, long rowCount) {
        Long numNulls = ColumnStatisticsKind.NULLS_COUNT.getFrom(columnStatistics);
        if (numNulls != null && numNulls != -1L) {
            Object min = columnStatistics.get(ColumnStatisticsKind.MIN_VALUE);
            Object max = columnStatistics.get(ColumnStatisticsKind.MAX_VALUE);
            if (min != null) {
                return (numNulls == 0L || numNulls == rowCount) && Objects.deepEquals(min, max);
            }
            return numNulls == rowCount && max == null;
        }
        return false;
    }
}

