/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import io.netty.buffer.DrillBuf;
import java.nio.ByteBuffer;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetDirectByteBufferAllocator
implements ByteBufferAllocator {
    private static final Logger logger = LoggerFactory.getLogger(ParquetDirectByteBufferAllocator.class);
    private final BufferAllocator allocator;
    private final Map<ByteBuffer, DrillBuf> allocatedBuffers = new IdentityHashMap<ByteBuffer, DrillBuf>();

    public ParquetDirectByteBufferAllocator(OperatorContext o) {
        this(o.getAllocator());
    }

    public ParquetDirectByteBufferAllocator(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    public ByteBuffer allocate(int sz) {
        DrillBuf drillBuf = this.allocator.buffer(sz);
        ByteBuffer byteBuffer = drillBuf.nioBuffer(0, sz);
        this.allocatedBuffers.put(byteBuffer, drillBuf);
        logger.debug("{}: Allocated {} bytes. Allocated DrillBuf with id {} and ByteBuffer {}", new Object[]{this, sz, drillBuf.getId(), System.identityHashCode(byteBuffer)});
        return byteBuffer;
    }

    public void release(ByteBuffer byteBuffer) {
        DrillBuf drillBuf = this.allocatedBuffers.remove(byteBuffer);
        if (drillBuf != null) {
            logger.debug("{}: Freed DrillBuf with id {} and ByteBuffer {}", new Object[]{this, drillBuf.getId(), System.identityHashCode(byteBuffer)});
            drillBuf.release();
        } else {
            logger.warn("{}: ByteBuffer {} is not present", (Object)this, (Object)System.identityHashCode(byteBuffer));
        }
    }

    public boolean isDirect() {
        return true;
    }
}

