/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.drill.exec.store.TimedCallable;
import org.apache.drill.exec.store.parquet.ParquetFormatPlugin;
import org.apache.drill.exec.util.DrillFileSystemUtil;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FooterGatherer {
    static final Logger logger = LoggerFactory.getLogger(FooterGatherer.class);
    private static final int DEFAULT_READ_SIZE = 65536;
    private static final int FOOTER_LENGTH_SIZE = 4;
    private static final int FOOTER_METADATA_SIZE = 4 + ParquetFileWriter.MAGIC.length;
    private static final int MAGIC_LENGTH = ParquetFileWriter.MAGIC.length;
    private static final int MIN_FILE_SIZE = ParquetFileWriter.MAGIC.length + FOOTER_METADATA_SIZE;

    private static final void readFully(FSDataInputStream stream, long start, byte[] output, int offset, int len) throws IOException {
        for (int bytesRead = 0; bytesRead > -1 && bytesRead < len; bytesRead += stream.read(start + (long)bytesRead, output, offset + bytesRead, len - bytesRead)) {
        }
    }

    private static void checkMagicBytes(FileStatus status, byte[] data, int offset) throws IOException {
        int i = 0;
        int v = offset;
        while (i < MAGIC_LENGTH) {
            if (ParquetFileWriter.MAGIC[i] != data[v]) {
                byte[] magic = ArrayUtils.subarray((byte[])data, (int)offset, (int)(offset + MAGIC_LENGTH));
                throw new IOException(status.getPath() + " is not a Parquet file. expected magic number at tail " + Arrays.toString(ParquetFileWriter.MAGIC) + " but found " + Arrays.toString(magic));
            }
            ++i;
            ++v;
        }
    }

    public static List<Footer> getFooters(Configuration conf, List<FileStatus> statuses, int parallelism) throws IOException {
        ArrayList readers = new ArrayList();
        ArrayList<Footer> foundFooters = new ArrayList<Footer>();
        for (FileStatus status : statuses) {
            if (status.isDirectory()) {
                Path summaryPath;
                FileSystem fs = status.getPath().getFileSystem(conf);
                if (fs.exists(summaryPath = new Path(status.getPath(), "_metadata"))) {
                    FileStatus summaryStatus = fs.getFileStatus(summaryPath);
                    foundFooters.addAll(ParquetFileReader.readSummaryFile((Configuration)conf, (FileStatus)summaryStatus));
                    continue;
                }
                for (FileStatus inStatus : DrillFileSystemUtil.listFiles(fs, status.getPath(), false, new PathFilter[0])) {
                    readers.add(new FooterReader(conf, inStatus));
                }
                continue;
            }
            readers.add(new FooterReader(conf, status));
        }
        if (!readers.isEmpty()) {
            foundFooters.addAll(TimedCallable.run("Fetch Parquet Footers", logger, readers, parallelism));
        }
        return foundFooters;
    }

    public static Footer readFooter(Configuration config, FileStatus status) throws IOException {
        FileSystem fs = status.getPath().getFileSystem(config);
        try (FSDataInputStream file = fs.open(status.getPath());){
            Footer footer;
            long fileLength = status.getLen();
            Preconditions.checkArgument(fileLength >= (long)MIN_FILE_SIZE, "%s is not a Parquet file (too small)", (Object)status.getPath());
            int len = (int)Math.min(fileLength, 65536L);
            byte[] footerBytes = new byte[len];
            FooterGatherer.readFully(file, fileLength - (long)len, footerBytes, 0, len);
            FooterGatherer.checkMagicBytes(status, footerBytes, footerBytes.length - ParquetFileWriter.MAGIC.length);
            int size = BytesUtils.readIntLittleEndian((byte[])footerBytes, (int)(footerBytes.length - FOOTER_METADATA_SIZE));
            if (size > footerBytes.length - FOOTER_METADATA_SIZE) {
                byte[] origFooterBytes = footerBytes;
                int origFooterRead = origFooterBytes.length - FOOTER_METADATA_SIZE;
                footerBytes = new byte[size];
                FooterGatherer.readFully(file, fileLength - (long)size - (long)FOOTER_METADATA_SIZE, footerBytes, 0, size - origFooterRead);
                System.arraycopy(origFooterBytes, 0, footerBytes, size - origFooterRead, origFooterRead);
            } else {
                int start = footerBytes.length - (size + FOOTER_METADATA_SIZE);
                footerBytes = ArrayUtils.subarray((byte[])footerBytes, (int)start, (int)(start + size));
            }
            ByteArrayInputStream from = new ByteArrayInputStream(footerBytes);
            ParquetMetadata metadata = ParquetFormatPlugin.parquetMetadataConverter.readParquetMetadata((InputStream)from, ParquetMetadataConverter.NO_FILTER);
            Footer footer2 = footer = new Footer(status.getPath(), metadata);
            return footer2;
        }
    }

    private static class FooterReader
    extends TimedCallable<Footer> {
        final Configuration conf;
        final FileStatus status;

        public FooterReader(Configuration conf, FileStatus status) {
            this.conf = conf;
            this.status = status;
        }

        @Override
        protected Footer runInner() throws Exception {
            return FooterGatherer.readFooter(this.conf, this.status);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("path", (Object)this.status.getPath()).toString();
        }
    }
}

