/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.compile.sig.ConstantExpressionIdentifier;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.expr.FilterBuilder;
import org.apache.drill.exec.expr.FilterPredicate;
import org.apache.drill.exec.expr.StatisticsProvider;
import org.apache.drill.exec.expr.fn.FunctionLookupContext;
import org.apache.drill.exec.expr.stat.RowsMatch;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.UdfUtilities;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.parquet.ParquetTableMetadataUtils;
import org.apache.drill.exec.store.parquet.metadata.MetadataBase;
import org.apache.drill.metastore.metadata.NonInterestingColumnsMetadata;
import org.apache.drill.metastore.metadata.RowGroupMetadata;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.apache.drill.metastore.statistics.TableStatisticsKind;
import org.apache.drill.metastore.util.SchemaPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterEvaluatorUtils {
    private static final Logger logger = LoggerFactory.getLogger(FilterEvaluatorUtils.class);

    private FilterEvaluatorUtils() {
    }

    public static RowsMatch evalFilter(LogicalExpression expr, MetadataBase.ParquetTableMetadataBase footer, int rowGroupIndex, OptionManager options, FragmentContext fragmentContext) {
        ArrayList<SchemaPath> schemaPathsInExpr = new ArrayList<SchemaPath>((Collection)expr.accept(FieldReferenceFinder.INSTANCE, null));
        RowGroupMetadata rowGroupMetadata = new ArrayList<RowGroupMetadata>(ParquetTableMetadataUtils.getRowGroupsMetadata(footer).values()).get(rowGroupIndex);
        NonInterestingColumnsMetadata nonInterestingColumnsMetadata = ParquetTableMetadataUtils.getNonInterestingColumnsMeta(footer);
        Map<SchemaPath, ColumnStatistics<?>> columnsStatistics = rowGroupMetadata.getColumnsStatistics();
        columnsStatistics.putAll(nonInterestingColumnsMetadata.getColumnsStatistics());
        columnsStatistics = ParquetTableMetadataUtils.addImplicitColumnsStatistics(columnsStatistics, schemaPathsInExpr, Collections.emptyList(), options, rowGroupMetadata.getPath(), true);
        return FilterEvaluatorUtils.matches(expr, columnsStatistics, rowGroupMetadata.getSchema(), TableStatisticsKind.ROW_COUNT.getValue(rowGroupMetadata), fragmentContext, fragmentContext.getFunctionRegistry(), new HashSet<SchemaPath>(schemaPathsInExpr));
    }

    public static RowsMatch matches(LogicalExpression expr, Map<SchemaPath, ColumnStatistics<?>> columnsStatistics, TupleMetadata schema, long rowCount, UdfUtilities udfUtilities, FunctionLookupContext functionImplementationRegistry, Set<SchemaPath> schemaPathsInExpr) {
        ErrorCollectorImpl errorCollector = new ErrorCollectorImpl();
        LogicalExpression materializedFilter = ExpressionTreeMaterializer.materializeFilterExpr(expr, schema, errorCollector, functionImplementationRegistry);
        if (errorCollector.hasErrors()) {
            logger.error("{} error(s) encountered when materialize filter expression : {}", (Object)errorCollector.getErrorCount(), (Object)errorCollector.toErrorString());
            return RowsMatch.SOME;
        }
        Set<LogicalExpression> constantBoundaries = ConstantExpressionIdentifier.getConstantExpressionSet(materializedFilter);
        FilterPredicate<?> parquetPredicate = FilterBuilder.buildFilterPredicate(materializedFilter, constantBoundaries, udfUtilities, true);
        return FilterEvaluatorUtils.matches(parquetPredicate, columnsStatistics, rowCount, schema, schemaPathsInExpr, udfUtilities);
    }

    public static <T extends Comparable<T>> RowsMatch matches(FilterPredicate<T> parquetPredicate, Map<SchemaPath, ColumnStatistics<?>> columnsStatistics, long rowCount, TupleMetadata fileMetadata, Set<SchemaPath> schemaPathsInExpr, UdfUtilities udfUtilities) {
        if (parquetPredicate == null) {
            return RowsMatch.SOME;
        }
        StatisticsProvider rangeExprEvaluator = new StatisticsProvider(columnsStatistics, rowCount, udfUtilities);
        RowsMatch rowsMatch = parquetPredicate.matches(rangeExprEvaluator);
        if (rowsMatch == RowsMatch.ALL && FilterEvaluatorUtils.isMetaNotApplicable(schemaPathsInExpr, fileMetadata)) {
            rowsMatch = RowsMatch.SOME;
        }
        return rowsMatch;
    }

    private static boolean isMetaNotApplicable(Set<SchemaPath> schemaPathsInExpr, TupleMetadata fileMetadata) {
        return FilterEvaluatorUtils.isRepeated(schemaPathsInExpr, fileMetadata) || FilterEvaluatorUtils.isDictOrRepeatedMapChild(schemaPathsInExpr, fileMetadata);
    }

    private static boolean isRepeated(Set<SchemaPath> fields, TupleMetadata fileMetadata) {
        for (SchemaPath field : fields) {
            ColumnMetadata columnMetadata = SchemaPathUtils.getColumnMetadata(field, fileMetadata);
            TypeProtos.MajorType fieldType = columnMetadata != null ? columnMetadata.majorType() : null;
            if (fieldType == null || fieldType.getMode() != TypeProtos.DataMode.REPEATED) continue;
            return true;
        }
        return false;
    }

    private static boolean isDictOrRepeatedMapChild(Set<SchemaPath> fields, TupleMetadata fileMetadata) {
        for (SchemaPath field : fields) {
            if (!SchemaPathUtils.isFieldNestedInDictOrRepeatedMap(field, fileMetadata)) continue;
            return true;
        }
        return false;
    }

    public static class FieldReferenceFinder
    extends AbstractExprVisitor<Set<SchemaPath>, Void, RuntimeException> {
        public static final FieldReferenceFinder INSTANCE = new FieldReferenceFinder();

        @Override
        public Set<SchemaPath> visitSchemaPath(SchemaPath path, Void value) {
            HashSet<SchemaPath> set = new HashSet<SchemaPath>();
            set.add(path);
            return set;
        }

        @Override
        public Set<SchemaPath> visitUnknown(LogicalExpression e, Void value) {
            HashSet<SchemaPath> paths = new HashSet<SchemaPath>();
            for (LogicalExpression ex : e) {
                paths.addAll((Collection<SchemaPath>)ex.accept(this, null));
            }
            return paths;
        }
    }
}

