/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.parquet.format.DataPageHeader;
import org.apache.parquet.format.DataPageHeaderV2;
import org.apache.parquet.format.Encoding;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.Statistics;

public interface DataPageHeaderInfoProvider {
    public int getNumValues();

    public Encoding getEncoding();

    public Encoding getDefinitionLevelEncoding();

    public Encoding getRepetitionLevelEncoding();

    public Statistics getStatistics();

    public static DataPageHeaderInfoProvider builder(PageHeader pageHeader) {
        switch (pageHeader.getType()) {
            case DATA_PAGE: {
                return new DataPageHeaderV1InfoProvider(pageHeader.getData_page_header());
            }
            case DATA_PAGE_V2: {
                return new DataPageHeaderV2InfoProvider(pageHeader.getData_page_header_v2());
            }
        }
        throw new DrillRuntimeException("Unsupported page header type:" + pageHeader.getType());
    }

    public static class DataPageHeaderV1InfoProvider
    implements DataPageHeaderInfoProvider {
        private final DataPageHeader dataPageHeader;

        private DataPageHeaderV1InfoProvider(DataPageHeader dataPageHeader) {
            this.dataPageHeader = dataPageHeader;
        }

        @Override
        public int getNumValues() {
            return this.dataPageHeader.getNum_values();
        }

        @Override
        public Encoding getEncoding() {
            return this.dataPageHeader.getEncoding();
        }

        @Override
        public Encoding getDefinitionLevelEncoding() {
            return this.dataPageHeader.getDefinition_level_encoding();
        }

        @Override
        public Encoding getRepetitionLevelEncoding() {
            return this.dataPageHeader.getRepetition_level_encoding();
        }

        @Override
        public Statistics getStatistics() {
            return this.dataPageHeader.getStatistics();
        }
    }

    public static class DataPageHeaderV2InfoProvider
    implements DataPageHeaderInfoProvider {
        private final DataPageHeaderV2 dataPageHeader;

        private DataPageHeaderV2InfoProvider(DataPageHeaderV2 dataPageHeader) {
            this.dataPageHeader = dataPageHeader;
        }

        @Override
        public int getNumValues() {
            return this.dataPageHeader.getNum_values();
        }

        @Override
        public Encoding getEncoding() {
            return this.dataPageHeader.getEncoding();
        }

        @Override
        public Encoding getDefinitionLevelEncoding() {
            return Encoding.RLE;
        }

        @Override
        public Encoding getRepetitionLevelEncoding() {
            return Encoding.RLE;
        }

        @Override
        public Statistics getStatistics() {
            return this.dataPageHeader.getStatistics();
        }
    }
}

