/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.metastore.MetadataProviderManager;
import org.apache.drill.exec.metastore.store.parquet.ParquetMetadataProvider;
import org.apache.drill.exec.metastore.store.parquet.ParquetMetadataProviderBuilder;
import org.apache.drill.exec.planner.common.DrillStatsTable;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.exec.record.metadata.schema.SchemaProvider;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.store.dfs.ReadEntryWithPath;
import org.apache.drill.exec.store.parquet.ParquetGroupScanStatistics;
import org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import org.apache.drill.exec.store.parquet.ParquetTableMetadataUtils;
import org.apache.drill.exec.store.parquet.metadata.MetadataBase;
import org.apache.drill.metastore.metadata.BaseMetadata;
import org.apache.drill.metastore.metadata.BaseTableMetadata;
import org.apache.drill.metastore.metadata.FileMetadata;
import org.apache.drill.metastore.metadata.LocationProvider;
import org.apache.drill.metastore.metadata.MetadataInfo;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.metadata.NonInterestingColumnsMetadata;
import org.apache.drill.metastore.metadata.PartitionMetadata;
import org.apache.drill.metastore.metadata.RowGroupMetadata;
import org.apache.drill.metastore.metadata.SegmentMetadata;
import org.apache.drill.metastore.metadata.TableInfo;
import org.apache.drill.metastore.metadata.TableMetadata;
import org.apache.drill.metastore.statistics.BaseStatisticsKind;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.apache.drill.metastore.statistics.ColumnStatisticsKind;
import org.apache.drill.metastore.statistics.StatisticsHolder;
import org.apache.drill.metastore.statistics.TableStatisticsKind;
import org.apache.drill.metastore.util.SchemaPathUtils;
import org.apache.drill.metastore.util.TableMetadataUtils;
import org.apache.drill.shaded.guava.com.google.common.collect.HashMultimap;
import org.apache.drill.shaded.guava.com.google.common.collect.LinkedListMultimap;
import org.apache.drill.shaded.guava.com.google.common.collect.Multimap;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseParquetMetadataProvider
implements ParquetMetadataProvider {
    private static final Logger logger = LoggerFactory.getLogger(BaseParquetMetadataProvider.class);
    public static final Object NULL_VALUE = new Object();
    protected final List<ReadEntryWithPath> entries;
    protected final ParquetReaderConfig readerConfig;
    protected final String tableName;
    protected final Path tableLocation;
    private ParquetGroupScanStatistics<? extends BaseMetadata> parquetGroupScanStatistics;
    protected MetadataBase.ParquetTableMetadataBase parquetTableMetadata;
    protected Set<Path> fileSet;
    protected TupleMetadata schema;
    protected DrillStatsTable statsTable;
    private List<SchemaPath> partitionColumns;
    private Multimap<Path, RowGroupMetadata> rowGroups;
    private TableMetadata tableMetadata;
    private List<PartitionMetadata> partitions;
    private Map<Path, FileMetadata> files;
    private Map<Path, SegmentMetadata> segments;
    private NonInterestingColumnsMetadata nonInterestingColumnsMetadata;
    private final boolean collectMetadata = false;

    protected BaseParquetMetadataProvider(Builder<?> builder) {
        if (((Builder)builder).entries != null) {
            this.entries = ((Builder)builder).entries;
            this.tableName = ((Builder)builder).selectionRoot != null ? ((Builder)builder).selectionRoot.toUri().getPath() : "";
            this.tableLocation = ((Builder)builder).selectionRoot;
        } else if (((Builder)builder).selection != null) {
            this.entries = new ArrayList<ReadEntryWithPath>();
            this.tableName = ((Builder)builder).selection.getSelectionRoot() != null ? ((Builder)builder).selection.getSelectionRoot().toUri().getPath() : "";
            this.tableLocation = ((Builder)builder).selection.getSelectionRoot();
        } else {
            this.entries = new ArrayList<ReadEntryWithPath>();
            this.tableName = null;
            this.tableLocation = null;
        }
        SchemaProvider schemaProvider = ((Builder)builder).metadataProviderManager.getSchemaProvider();
        TupleMetadata schema = ((Builder)builder).schema;
        if (schema == null && schemaProvider != null) {
            try {
                schema = schemaProvider.read().getSchema();
            }
            catch (IOException e) {
                logger.warn("Unable to read schema from schema provider [{}]: {}.\nQuery execution will continue without using the schema.", (Object)this.tableLocation, (Object)e.getMessage());
                logger.trace("Error when reading the schema", (Throwable)e);
            }
        }
        this.readerConfig = ((Builder)builder).readerConfig == null ? ParquetReaderConfig.getDefaultInstance() : ((Builder)builder).readerConfig;
        this.schema = schema;
        this.statsTable = ((Builder)builder).metadataProviderManager.getStatsProvider();
    }

    protected void init(BaseParquetMetadataProvider metadataProvider) throws IOException {
        this.initInternal();
        assert (this.parquetTableMetadata != null);
        if (this.fileSet == null) {
            this.fileSet = new HashSet<Path>();
            this.fileSet.addAll(this.parquetTableMetadata.getFiles().stream().map(MetadataBase.ParquetFileMetadata::getPath).collect(Collectors.toSet()));
        }
        List<Path> fileLocations = this.getLocations();
        if (metadataProvider == null || metadataProvider.rowGroups != null && !metadataProvider.rowGroups.keySet().containsAll(fileLocations) || metadataProvider.files != null && !metadataProvider.files.keySet().containsAll(fileLocations)) {
            this.initializeMetadata();
        } else {
            if (metadataProvider.files != null && metadataProvider.files.size() != this.files.size()) {
                this.files = metadataProvider.files.entrySet().stream().filter(entry -> fileLocations.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
            if (metadataProvider.rowGroups != null) {
                this.rowGroups = LinkedListMultimap.create();
                metadataProvider.rowGroups.entries().stream().filter(entry -> fileLocations.contains(entry.getKey())).forEach(entry -> this.rowGroups.put((Path)entry.getKey(), (RowGroupMetadata)entry.getValue()));
            }
            TableMetadata tableMetadata = this.getTableMetadata();
            this.getSegmentsMetadataMap();
            this.getPartitionsMetadata();
            this.getRowGroupsMeta();
            this.getNonInterestingColumnsMetadata();
            this.tableMetadata = TableMetadataUtils.updateRowCount(tableMetadata, this.getRowGroupsMeta());
            this.parquetTableMetadata = null;
        }
    }

    public void initializeMetadata() {
        if (this.statsTable != null && !this.statsTable.isMaterialized()) {
            this.statsTable.materialize();
        }
        this.getTableMetadata();
        this.getSegmentsMetadataMap();
        this.getFilesMetadataMap();
        this.getPartitionsMetadata();
        this.getRowGroupsMeta();
        this.getNonInterestingColumnsMetadata();
        this.parquetTableMetadata = null;
    }

    @Override
    public NonInterestingColumnsMetadata getNonInterestingColumnsMetadata() {
        if (this.nonInterestingColumnsMetadata == null) {
            this.nonInterestingColumnsMetadata = ParquetTableMetadataUtils.getNonInterestingColumnsMeta(this.parquetTableMetadata);
        }
        return this.nonInterestingColumnsMetadata;
    }

    @Override
    public TableMetadata getTableMetadata() {
        if (this.tableMetadata == null) {
            ArrayList tableStatistics = new ArrayList(DrillStatsTable.getEstimatedTableStats(this.statsTable));
            Map<SchemaPath, TypeProtos.MajorType> fields = ParquetTableMetadataUtils.resolveFields(this.parquetTableMetadata);
            Map<SchemaPath, TypeProtos.MajorType> intermediateFields = ParquetTableMetadataUtils.resolveIntermediateFields(this.parquetTableMetadata);
            if (this.schema == null) {
                this.schema = new TupleSchema();
                fields.forEach((schemaPath, majorType) -> SchemaPathUtils.addColumnMetadata(this.schema, schemaPath, majorType, intermediateFields));
            } else {
                fields.forEach((schemaPath, majorType) -> {
                    if (SchemaPathUtils.getColumnMetadata(schemaPath, this.schema) == null) {
                        SchemaPathUtils.addColumnMetadata(this.schema, schemaPath, majorType, intermediateFields);
                    }
                });
            }
            HashMap columnsStatistics = new HashMap();
            tableStatistics.add(new StatisticsHolder<Long>(Long.valueOf(this.getParquetGroupScanStatistics().getRowCount()), (BaseStatisticsKind<?>)TableStatisticsKind.ROW_COUNT));
            HashSet<SchemaPath> unhandledColumns = new HashSet<SchemaPath>();
            if (this.statsTable != null && this.statsTable.isMaterialized()) {
                unhandledColumns.addAll(this.statsTable.getColumns());
            }
            fields.forEach((columnPath, value) -> {
                long columnValueCount = this.getParquetGroupScanStatistics().getColumnValueCount((SchemaPath)columnPath);
                ArrayList stats = new ArrayList(DrillStatsTable.getEstimatedColumnStats(this.statsTable, columnPath));
                unhandledColumns.remove(columnPath);
                stats.add(new StatisticsHolder<Long>(Long.valueOf(columnValueCount), (BaseStatisticsKind<?>)TableStatisticsKind.ROW_COUNT));
                stats.add(new StatisticsHolder<Long>(Long.valueOf(this.getParquetGroupScanStatistics().getRowCount() - columnValueCount), (BaseStatisticsKind<?>)ColumnStatisticsKind.NULLS_COUNT));
                columnsStatistics.put((SchemaPath)columnPath, new ColumnStatistics(stats, value.getMinorType()));
            });
            for (SchemaPath column : unhandledColumns) {
                columnsStatistics.put(column, new ColumnStatistics(DrillStatsTable.getEstimatedColumnStats(this.statsTable, column)));
            }
            MetadataInfo metadataInfo = MetadataInfo.builder().type(MetadataType.TABLE).build();
            this.tableMetadata = ((BaseTableMetadata.BaseTableMetadataBuilder)((BaseTableMetadata.BaseTableMetadataBuilder)((BaseTableMetadata.BaseTableMetadataBuilder)((BaseTableMetadata.BaseTableMetadataBuilder)((BaseTableMetadata.BaseTableMetadataBuilder)BaseTableMetadata.builder().tableInfo(TableInfo.UNKNOWN_TABLE_INFO)).metadataInfo(metadataInfo)).location(this.tableLocation).schema(this.schema)).columnsStatistics(columnsStatistics)).metadataStatistics(tableStatistics)).partitionKeys(Collections.emptyMap()).build();
        }
        return this.tableMetadata;
    }

    private ParquetGroupScanStatistics<? extends BaseMetadata> getParquetGroupScanStatistics() {
        if (this.parquetGroupScanStatistics == null) {
            this.parquetGroupScanStatistics = new ParquetGroupScanStatistics<RowGroupMetadata>(this.getRowGroupsMeta());
        }
        return this.parquetGroupScanStatistics;
    }

    @Override
    public List<SchemaPath> getPartitionColumns() {
        if (this.partitionColumns == null) {
            this.partitionColumns = this.getParquetGroupScanStatistics().getPartitionColumns();
        }
        return this.partitionColumns;
    }

    @Override
    public List<PartitionMetadata> getPartitionsMetadata() {
        if (this.partitions == null) {
            this.partitions = new ArrayList<PartitionMetadata>();
            for (SchemaPath partitionColumn : this.getParquetGroupScanStatistics().getPartitionColumns()) {
                Map<Path, Object> partitionPaths = this.getParquetGroupScanStatistics().getPartitionPaths(partitionColumn);
                HashMultimap partitionsForValue = HashMultimap.create();
                partitionPaths.forEach((path, value) -> partitionsForValue.put(value, path));
                partitionsForValue.asMap().forEach((partitionKey, value) -> {
                    HashMap columnsStatistics = new HashMap();
                    ArrayList statistics = new ArrayList();
                    partitionKey = partitionKey == NULL_VALUE ? null : partitionKey;
                    statistics.add(new StatisticsHolder<Object>(partitionKey, (BaseStatisticsKind<?>)ColumnStatisticsKind.MIN_VALUE));
                    statistics.add(new StatisticsHolder<Object>(partitionKey, (BaseStatisticsKind<?>)ColumnStatisticsKind.MAX_VALUE));
                    statistics.add(new StatisticsHolder<Long>(Long.valueOf(-1L), (BaseStatisticsKind<?>)ColumnStatisticsKind.NULLS_COUNT));
                    statistics.add(new StatisticsHolder<Long>(Long.valueOf(-1L), (BaseStatisticsKind<?>)TableStatisticsKind.ROW_COUNT));
                    columnsStatistics.put(partitionColumn, new ColumnStatistics(statistics, this.getParquetGroupScanStatistics().getTypeForColumn(partitionColumn).getMinorType()));
                    MetadataInfo metadataInfo = MetadataInfo.builder().type(MetadataType.PARTITION).build();
                    TableMetadata tableMetadata = this.getTableMetadata();
                    PartitionMetadata partitionMetadata = ((PartitionMetadata.PartitionMetadataBuilder)((PartitionMetadata.PartitionMetadataBuilder)((PartitionMetadata.PartitionMetadataBuilder)((PartitionMetadata.PartitionMetadataBuilder)((PartitionMetadata.PartitionMetadataBuilder)PartitionMetadata.builder().tableInfo(tableMetadata.getTableInfo())).metadataInfo(metadataInfo)).column(partitionColumn).schema(tableMetadata.getSchema())).columnsStatistics(columnsStatistics)).metadataStatistics(statistics)).partitionValues(Collections.emptyList()).locations(new HashSet<Path>((Collection<Path>)value)).build();
                    this.partitions.add(partitionMetadata);
                });
            }
        }
        return this.partitions;
    }

    @Override
    public List<PartitionMetadata> getPartitionMetadata(SchemaPath columnName) {
        return this.getPartitionsMetadata().stream().filter(Objects::nonNull).filter(partitionMetadata -> partitionMetadata.getColumn().equals(columnName)).collect(Collectors.toList());
    }

    @Override
    public FileMetadata getFileMetadata(Path location) {
        return this.getFilesMetadataMap().get(location);
    }

    @Override
    public List<FileMetadata> getFilesForPartition(PartitionMetadata partition) {
        return partition.getLocations().stream().map(location -> this.getFilesMetadataMap().get(location)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Map<Path, SegmentMetadata> getSegmentsMetadataMap() {
        if (this.segments == null) {
            if (!this.entries.isEmpty()) {
                // empty if block
            }
            return Collections.emptyMap();
        }
        return this.segments;
    }

    private static <T extends BaseMetadata> Map<Path, SegmentMetadata> getSegmentsForMetadata(Map<Path, T> metadata, SchemaPath column) {
        LinkedListMultimap metadataMultimap = LinkedListMultimap.create();
        metadata.forEach((key, value) -> metadataMultimap.put(key.getParent(), value));
        HashMap<Path, SegmentMetadata> result = new HashMap<Path, SegmentMetadata>();
        metadataMultimap.asMap().forEach((key, value) -> result.put((Path)key, BaseParquetMetadataProvider.combineToSegmentMetadata(value, column)));
        return result;
    }

    private static Map<Path, SegmentMetadata> getMetadataForSegments(Map<Path, SegmentMetadata> metadata, SchemaPath column) {
        LinkedListMultimap metadataMultimap = LinkedListMultimap.create();
        metadata.forEach((key, value) -> metadataMultimap.put(key.getParent(), value));
        HashMap<Path, SegmentMetadata> result = new HashMap<Path, SegmentMetadata>();
        metadataMultimap.asMap().forEach((key, value) -> result.put((Path)key, BaseParquetMetadataProvider.combineSegmentMetadata(value, column)));
        return result;
    }

    private static <T extends BaseMetadata> SegmentMetadata combineToSegmentMetadata(Collection<T> metadataList, SchemaPath column) {
        Set<Path> metadataLocations = metadataList.stream().map(metadata -> ((LocationProvider)((Object)metadata)).getPath()).collect(Collectors.toSet());
        return BaseParquetMetadataProvider.combineToSegmentMetadata(metadataList, column, metadataLocations);
    }

    private static SegmentMetadata combineSegmentMetadata(Collection<SegmentMetadata> metadataList, SchemaPath column) {
        Set<Path> metadataLocations = metadataList.stream().flatMap(metadata -> metadata.getLocations().stream()).collect(Collectors.toSet());
        return BaseParquetMetadataProvider.combineToSegmentMetadata(metadataList, column, metadataLocations);
    }

    private static <T extends BaseMetadata> SegmentMetadata combineToSegmentMetadata(Collection<T> metadataList, SchemaPath column, Set<Path> metadataLocations) {
        List<StatisticsHolder<?>> segmentStatistics = Collections.singletonList(new StatisticsHolder<Long>(TableStatisticsKind.ROW_COUNT.mergeStatistics(metadataList), (BaseStatisticsKind<?>)TableStatisticsKind.ROW_COUNT));
        MetadataInfo metadataInfo = MetadataInfo.builder().type(MetadataType.SEGMENT).build();
        BaseMetadata firstMetadata = (BaseMetadata)metadataList.iterator().next();
        return ((SegmentMetadata.SegmentMetadataBuilder)((SegmentMetadata.SegmentMetadataBuilder)((SegmentMetadata.SegmentMetadataBuilder)((SegmentMetadata.SegmentMetadataBuilder)((SegmentMetadata.SegmentMetadataBuilder)SegmentMetadata.builder().tableInfo(firstMetadata.getTableInfo())).metadataInfo(metadataInfo)).column(column).schema(firstMetadata.getSchema())).path(((LocationProvider)((Object)firstMetadata)).getPath().getParent()).columnsStatistics(TableMetadataUtils.mergeColumnsStatistics(metadataList, firstMetadata.getColumnsStatistics().keySet(), ParquetTableMetadataUtils.PARQUET_COLUMN_STATISTICS))).metadataStatistics(segmentStatistics)).partitionValues(Collections.emptyList()).locations(metadataLocations).build();
    }

    @Override
    public Map<Path, FileMetadata> getFilesMetadataMap() {
        if (this.files == null) {
            if (!this.entries.isEmpty()) {
                // empty if block
            }
            return Collections.emptyMap();
        }
        return this.files;
    }

    @Override
    public List<ReadEntryWithPath> getEntries() {
        return this.entries;
    }

    @Override
    public Set<Path> getFileSet() {
        return this.fileSet;
    }

    @Override
    public List<RowGroupMetadata> getRowGroupsMeta() {
        return new ArrayList<RowGroupMetadata>(this.getRowGroupsMetadataMap().values());
    }

    @Override
    public List<Path> getLocations() {
        return this.parquetTableMetadata.getFiles().stream().map(MetadataBase.ParquetFileMetadata::getPath).collect(Collectors.toList());
    }

    @Override
    public Multimap<Path, RowGroupMetadata> getRowGroupsMetadataMap() {
        if (this.rowGroups == null) {
            this.rowGroups = ParquetTableMetadataUtils.getRowGroupsMetadata(this.parquetTableMetadata);
        }
        return this.rowGroups;
    }

    @Override
    public boolean checkMetadataVersion() {
        return false;
    }

    protected abstract void initInternal() throws IOException;

    private static /* synthetic */ FileMetadata lambda$getFilesMetadataMap$16(FileMetadata o, FileMetadata n) {
        return n;
    }

    public static abstract class Builder<T extends Builder<T>>
    implements ParquetMetadataProviderBuilder<T> {
        private final MetadataProviderManager metadataProviderManager;
        private List<ReadEntryWithPath> entries;
        private Path selectionRoot;
        private ParquetReaderConfig readerConfig;
        private TupleMetadata schema;
        private FileSelection selection;

        public Builder(MetadataProviderManager source) {
            this.metadataProviderManager = source;
        }

        @Override
        public T withEntries(List<ReadEntryWithPath> entries) {
            this.entries = entries;
            return this.self();
        }

        @Override
        public T withSelectionRoot(Path selectionRoot) {
            this.selectionRoot = selectionRoot;
            return this.self();
        }

        @Override
        public T withReaderConfig(ParquetReaderConfig readerConfig) {
            this.readerConfig = readerConfig;
            return this.self();
        }

        @Override
        public T withSelection(FileSelection selection) {
            this.selection = selection;
            return this.self();
        }

        @Override
        public T withSchema(TupleMetadata schema) {
            this.schema = schema;
            return this.self();
        }

        protected abstract T self();

        public Path selectionRoot() {
            return this.selectionRoot;
        }

        public FileSelection selection() {
            return this.selection;
        }

        public MetadataProviderManager metadataProviderManager() {
            return this.metadataProviderManager;
        }

        public List<ReadEntryWithPath> entries() {
            return this.entries;
        }
    }
}

