/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.drill.common.expression.ExpressionStringBuilder;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.expr.FilterPredicate;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.metastore.MetadataProviderManager;
import org.apache.drill.exec.metastore.store.parquet.ParquetMetadataProvider;
import org.apache.drill.exec.metastore.store.parquet.ParquetMetadataProviderBuilder;
import org.apache.drill.exec.ops.UdfUtilities;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.base.AbstractGroupScanWithMetadata;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.store.dfs.ReadEntryWithPath;
import org.apache.drill.exec.store.parquet.FilterEvaluatorUtils;
import org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import org.apache.drill.exec.store.parquet.RowGroupInfo;
import org.apache.drill.exec.store.parquet.RowGroupReadEntry;
import org.apache.drill.exec.store.schedule.AffinityCreator;
import org.apache.drill.exec.store.schedule.AssignmentCreator;
import org.apache.drill.exec.store.schedule.EndpointByteMapImpl;
import org.apache.drill.metastore.metadata.BaseMetadata;
import org.apache.drill.metastore.metadata.FileMetadata;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.metadata.PartitionMetadata;
import org.apache.drill.metastore.metadata.RowGroupMetadata;
import org.apache.drill.metastore.metadata.SegmentMetadata;
import org.apache.drill.metastore.statistics.TableStatisticsKind;
import org.apache.drill.metastore.util.TableMetadataUtils;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ArrayListMultimap;
import org.apache.drill.shaded.guava.com.google.common.collect.LinkedListMultimap;
import org.apache.drill.shaded.guava.com.google.common.collect.ListMultimap;
import org.apache.drill.shaded.guava.com.google.common.collect.Multimap;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParquetGroupScan
extends AbstractGroupScanWithMetadata<ParquetMetadataProvider> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractParquetGroupScan.class);
    protected List<ReadEntryWithPath> entries;
    protected Multimap<Path, RowGroupMetadata> rowGroups;
    protected ListMultimap<Integer, RowGroupInfo> mappings;
    protected ParquetReaderConfig readerConfig;
    private List<EndpointAffinity> endpointAffinities;
    private List<RowGroupInfo> rowGroupInfos;

    protected AbstractParquetGroupScan(String userName, List<SchemaPath> columns, List<ReadEntryWithPath> entries, ParquetReaderConfig readerConfig, LogicalExpression filter) {
        super(userName, columns, filter);
        this.entries = entries;
        this.readerConfig = readerConfig == null ? ParquetReaderConfig.getDefaultInstance() : readerConfig;
    }

    protected AbstractParquetGroupScan(AbstractParquetGroupScan that) {
        super(that);
        this.rowGroups = that.rowGroups;
        this.endpointAffinities = that.endpointAffinities == null ? null : new ArrayList<EndpointAffinity>(that.endpointAffinities);
        this.mappings = that.mappings == null ? null : ArrayListMultimap.create(that.mappings);
        this.entries = that.entries == null ? null : new ArrayList<ReadEntryWithPath>(that.entries);
        this.readerConfig = that.readerConfig;
    }

    @JsonProperty
    public List<ReadEntryWithPath> getEntries() {
        return this.entries;
    }

    @JsonProperty(value="readerConfig")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ParquetReaderConfig getReaderConfigForSerialization() {
        return ParquetReaderConfig.getDefaultInstance().equals(this.readerConfig) ? null : this.readerConfig;
    }

    @JsonIgnore
    public ParquetReaderConfig getReaderConfig() {
        return this.readerConfig;
    }

    @Override
    @JsonIgnore
    public Collection<Path> getFiles() {
        return super.getFiles();
    }

    @Override
    public boolean canPushdownProjects(List<SchemaPath> columns) {
        return true;
    }

    @Override
    public boolean supportsFilterPushDown() {
        return true;
    }

    @Override
    public List<EndpointAffinity> getOperatorAffinity() {
        if (this.endpointAffinities == null) {
            this.endpointAffinities = AffinityCreator.getAffinityMap(this.getRowGroupInfos());
        }
        return this.endpointAffinities;
    }

    @Override
    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> incomingEndpoints) {
        this.mappings = AssignmentCreator.getMappings(incomingEndpoints, this.getRowGroupInfos());
    }

    private List<RowGroupInfo> getRowGroupInfos() {
        if (this.rowGroupInfos == null) {
            HashMap<String, CoordinationProtos.DrillbitEndpoint> hostEndpointMap = new HashMap<String, CoordinationProtos.DrillbitEndpoint>();
            for (CoordinationProtos.DrillbitEndpoint endpoint : this.getDrillbits()) {
                hostEndpointMap.put(endpoint.getAddress(), endpoint);
            }
            this.rowGroupInfos = new ArrayList<RowGroupInfo>();
            for (RowGroupMetadata rowGroupMetadata : this.getRowGroupsMetadata().values()) {
                RowGroupInfo rowGroupInfo = new RowGroupInfo(rowGroupMetadata.getPath(), (Long)rowGroupMetadata.getStatistic(() -> "start"), (Long)rowGroupMetadata.getStatistic(() -> "length"), rowGroupMetadata.getRowGroupIndex(), TableStatisticsKind.ROW_COUNT.getValue(rowGroupMetadata));
                rowGroupInfo.setNumRecordsToRead(rowGroupInfo.getRowCount());
                EndpointByteMapImpl endpointByteMap = new EndpointByteMapImpl();
                for (String host : rowGroupMetadata.getHostAffinity().keySet()) {
                    if (!hostEndpointMap.containsKey(host)) continue;
                    endpointByteMap.add((CoordinationProtos.DrillbitEndpoint)hostEndpointMap.get(host), (long)(rowGroupMetadata.getHostAffinity().get(host).floatValue() * (float)((Long)rowGroupMetadata.getStatistic(() -> "length")).longValue()));
                }
                rowGroupInfo.setEndpointByteMap(endpointByteMap);
                this.rowGroupInfos.add(rowGroupInfo);
            }
        }
        return this.rowGroupInfos;
    }

    @Override
    public int getMaxParallelizationWidth() {
        if (!this.getRowGroupsMetadata().isEmpty()) {
            return this.getRowGroupsMetadata().size();
        }
        if (!this.getFilesMetadata().isEmpty()) {
            return this.getFilesMetadata().size();
        }
        return !this.getPartitionsMetadata().isEmpty() ? this.getPartitionsMetadata().size() : 1;
    }

    protected List<RowGroupReadEntry> getReadEntries(int minorFragmentId) {
        assert (minorFragmentId < this.mappings.size()) : String.format("Mappings length [%d] should be longer than minor fragment id [%d] but it isn't.", this.mappings.size(), minorFragmentId);
        Collection rowGroupsForMinor = this.mappings.get((Object)minorFragmentId);
        Preconditions.checkArgument(!rowGroupsForMinor.isEmpty(), String.format("MinorFragmentId %d has no read entries assigned", minorFragmentId));
        ArrayList<RowGroupReadEntry> readEntries = new ArrayList<RowGroupReadEntry>();
        for (RowGroupInfo rgi : rowGroupsForMinor) {
            RowGroupReadEntry entry = new RowGroupReadEntry(rgi.getPath(), rgi.getStart(), rgi.getLength(), rgi.getRowGroupIndex(), rgi.getNumRecordsToRead());
            readEntries.add(entry);
        }
        return readEntries;
    }

    @Override
    public AbstractGroupScanWithMetadata<?> applyFilter(LogicalExpression filterExpr, UdfUtilities udfUtilities, FunctionImplementationRegistry functionImplementationRegistry, OptionManager optionManager) {
        FilterPredicate<?> filterPredicate = this.getFilterPredicate(filterExpr, udfUtilities, functionImplementationRegistry, optionManager, true);
        if (filterPredicate == null) {
            logger.debug("FilterPredicate cannot be built.");
            return null;
        }
        AbstractGroupScanWithMetadata.GroupScanWithMetadataFilterer filteredMetadata = ((RowGroupScanFilterer)((RowGroupScanFilterer)((RowGroupScanFilterer)((RowGroupScanFilterer)this.getFilterer().filterExpression(filterExpr)).schema(this.tableMetadata.getSchema())).context(functionImplementationRegistry)).udfUtilities(udfUtilities)).getFiltered(optionManager, (FilterPredicate)filterPredicate);
        if (this.isGroupScanFullyMatchesFilter((RowGroupScanFilterer<?>)filteredMetadata)) {
            logger.debug("applyFilter() does not have any pruning");
            this.matchAllMetadata = filteredMetadata.isMatchAllMetadata();
            return null;
        }
        if (this.isAllDataPruned((RowGroupScanFilterer<?>)filteredMetadata)) {
            if (this.getRowGroupsMetadata().size() == 1) {
                return null;
            }
            if ((long)this.getRowGroupsMetadata().size() >= optionManager.getOption(PlannerSettings.PARQUET_ROWGROUP_FILTER_PUSHDOWN_PLANNING_THRESHOLD)) {
                this.rowGroups = this.getRowGroupsMetadata();
                this.matchAllMetadata = false;
                logger.trace("Stopping plan time pruning. Metadata has {} rowgroups, but the threshold option is set to {} rowgroups", (Object)this.rowGroups.size(), (Object)optionManager.getOption(PlannerSettings.PARQUET_ROWGROUP_FILTER_PUSHDOWN_PLANNING_THRESHOLD));
                return null;
            }
            logger.debug("All row groups have been filtered out. Add back one to get schema from scanner");
            Map<Path, SegmentMetadata> segmentsMap = this.getNextOrEmpty(this.getSegmentsMetadata().values()).stream().collect(Collectors.toMap(SegmentMetadata::getPath, Function.identity()));
            Map<Path, FileMetadata> filesMap = this.getNextOrEmpty(this.getFilesMetadata().values()).stream().collect(Collectors.toMap(FileMetadata::getPath, Function.identity()));
            LinkedListMultimap<Path, RowGroupMetadata> rowGroupsMap = LinkedListMultimap.create();
            this.getNextOrEmpty(this.getRowGroupsMetadata().values()).forEach(entry -> rowGroupsMap.put(entry.getPath(), (RowGroupMetadata)entry));
            ((RowGroupScanFilterer)((RowGroupScanFilterer)((RowGroupScanFilterer)((RowGroupScanFilterer)((RowGroupScanFilterer)((AbstractGroupScanWithMetadata.GroupScanWithMetadataFilterer)((RowGroupScanFilterer)filteredMetadata).rowGroups(rowGroupsMap)).table(this.getTableMetadata())).segments(segmentsMap)).partitions(this.getNextOrEmpty(this.getPartitionsMetadata()))).nonInterestingColumns(this.getNonInterestingColumnsMetadata())).files(filesMap)).matching(false);
        }
        if (filteredMetadata.getOverflowLevel() != MetadataType.NONE && logger.isWarnEnabled()) {
            logger.warn("applyFilter {} wasn't able to do pruning for  all metadata levels filter condition, since metadata count for {} level exceeds `planner.store.parquet.rowgroup.filter.pushdown.threshold` value.\nBut underlying metadata was pruned without filter expression according to the metadata with above level.", (Object)ExpressionStringBuilder.toString(filterExpr), (Object)filteredMetadata.getOverflowLevel());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("applyFilter {} reduce row groups # from {} to {}", new Object[]{ExpressionStringBuilder.toString(filterExpr), this.getRowGroupsMetadata().size(), ((RowGroupScanFilterer)filteredMetadata).getRowGroups().size()});
        }
        return ((RowGroupScanFilterer)filteredMetadata).build();
    }

    @Override
    private boolean isAllDataPruned(RowGroupScanFilterer<?> filteredMetadata) {
        return !filteredMetadata.isMatchAllMetadata() && (super.isAllDataPruned(filteredMetadata) || filteredMetadata.getRowGroups().isEmpty() && !this.getRowGroupsMetadata().isEmpty());
    }

    @Override
    private boolean isGroupScanFullyMatchesFilter(RowGroupScanFilterer<?> filteredMetadata) {
        if (!this.getRowGroupsMetadata().isEmpty()) {
            return this.getRowGroupsMetadata().size() == filteredMetadata.getRowGroups().size();
        }
        return super.isGroupScanFullyMatchesFilter(filteredMetadata);
    }

    protected Multimap<Path, RowGroupMetadata> pruneRowGroupsForFiles(Map<Path, FileMetadata> filteredFileMetadata) {
        LinkedListMultimap<Path, RowGroupMetadata> prunedRowGroups = LinkedListMultimap.create();
        for (Path filteredPartition : filteredFileMetadata.keySet()) {
            Multimap<Path, RowGroupMetadata> rowGroupsMetadata = this.getRowGroupsMetadata();
            Collection<RowGroupMetadata> filesRowGroupMetadata = rowGroupsMetadata.get(filteredPartition);
            if (!CollectionUtils.isNotEmpty(filesRowGroupMetadata)) continue;
            prunedRowGroups.putAll(filteredPartition, filesRowGroupMetadata);
        }
        return prunedRowGroups;
    }

    @Override
    public GroupScan applyLimit(int maxRecords) {
        long tableRowCount;
        maxRecords = Math.max(maxRecords, 1);
        if (this.getTableMetadata() != null && ((tableRowCount = TableStatisticsKind.ROW_COUNT.getValue(this.getTableMetadata()).longValue()) == -1L || tableRowCount <= (long)maxRecords)) {
            logger.debug("limit push down does not apply, since total number of rows [{}] is less or equal to the required [{}].", (Object)tableRowCount, (Object)maxRecords);
            return null;
        }
        List<RowGroupMetadata> qualifiedRowGroups = this.limitMetadata(this.getRowGroupsMetadata().values(), maxRecords);
        if (qualifiedRowGroups == null || this.getRowGroupsMetadata().size() == qualifiedRowGroups.size()) {
            logger.debug("limit push down does not apply, since number of row groups was not reduced.");
            return null;
        }
        Map<Path, FileMetadata> filesMetadata = this.getFilesMetadata();
        Map<Path, FileMetadata> qualifiedFiles = qualifiedRowGroups.stream().map(rowGroup -> (FileMetadata)filesMetadata.get(rowGroup.getPath())).filter(Objects::nonNull).collect(Collectors.toMap(FileMetadata::getPath, Function.identity()));
        LinkedListMultimap<Path, RowGroupMetadata> prunedRowGroups = LinkedListMultimap.create();
        for (RowGroupMetadata qualifiedRowGroup : qualifiedRowGroups) {
            prunedRowGroups.put(qualifiedRowGroup.getPath(), qualifiedRowGroup);
        }
        return ((RowGroupScanFilterer)((RowGroupScanFilterer)((RowGroupScanFilterer)((RowGroupScanFilterer)((RowGroupScanFilterer)((RowGroupScanFilterer)((AbstractGroupScanWithMetadata.GroupScanWithMetadataFilterer)((RowGroupScanFilterer)this.getFilterer()).rowGroups(prunedRowGroups)).table(this.tableMetadata)).partitions(this.partitions)).segments(this.segments)).files(qualifiedFiles)).nonInterestingColumns(this.nonInterestingColumnsMetadata)).matching(this.matchAllMetadata)).build();
    }

    @Override
    public void modifyFileSelection(FileSelection selection) {
        super.modifyFileSelection(selection);
        List<Path> files = selection.getFiles();
        this.fileSet = new HashSet<Path>(files);
        this.entries = new ArrayList<ReadEntryWithPath>(files.size());
        this.entries.addAll(files.stream().map(ReadEntryWithPath::new).collect(Collectors.toList()));
        LinkedListMultimap<Path, RowGroupMetadata> newRowGroups = LinkedListMultimap.create();
        if (!this.getRowGroupsMetadata().isEmpty()) {
            this.getRowGroupsMetadata().entries().stream().filter(entry -> this.fileSet.contains(entry.getKey())).forEachOrdered(entry -> newRowGroups.put((Path)entry.getKey(), (RowGroupMetadata)entry.getValue()));
        }
        this.rowGroups = newRowGroups;
        this.tableMetadata = TableMetadataUtils.updateRowCount(this.getTableMetadata(), this.getRowGroupsMetadata().values());
        this.files = !this.getFilesMetadata().isEmpty() ? this.getFilesMetadata().entrySet().stream().filter(entry -> this.fileSet.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)) : Collections.emptyMap();
        ArrayList<PartitionMetadata> newPartitions = new ArrayList<PartitionMetadata>();
        if (!this.getPartitionsMetadata().isEmpty()) {
            block0: for (PartitionMetadata entry2 : this.getPartitionsMetadata()) {
                for (Path partLocation : entry2.getLocations()) {
                    if (!this.fileSet.contains(partLocation)) continue;
                    newPartitions.add(entry2);
                    continue block0;
                }
            }
        }
        this.partitions = newPartitions;
        if (!this.getSegmentsMetadata().isEmpty()) {
            this.segments = this.getSegmentsMetadata().entrySet().stream().filter(entry -> this.fileSet.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        this.rowGroupInfos = null;
    }

    protected Multimap<Path, RowGroupMetadata> getRowGroupsMetadata() {
        if (this.rowGroups == null) {
            this.rowGroups = ((ParquetMetadataProvider)this.metadataProvider).getRowGroupsMetadataMap();
        }
        return this.rowGroups;
    }

    protected static <T extends BaseMetadata> Multimap<Path, T> pruneForPartitions(Multimap<Path, T> metadataToPrune, List<PartitionMetadata> filteredPartitionMetadata) {
        LinkedListMultimap<Path, BaseMetadata> prunedFiles = LinkedListMultimap.create();
        if (metadataToPrune != null) {
            block0: for (Map.Entry<Path, T> entry : metadataToPrune.entries()) {
                for (PartitionMetadata filteredPartition : filteredPartitionMetadata) {
                    if (!filteredPartition.getLocations().contains(entry.getKey())) continue;
                    prunedFiles.put(entry.getKey(), (BaseMetadata)entry.getValue());
                    continue block0;
                }
            }
        }
        return prunedFiles;
    }

    protected abstract Collection<CoordinationProtos.DrillbitEndpoint> getDrillbits();

    protected abstract AbstractParquetGroupScan cloneWithFileSelection(Collection<Path> var1) throws IOException;

    @Override
    protected abstract ParquetMetadataProviderBuilder<?> defaultTableMetadataProviderBuilder(MetadataProviderManager var1);

    @Override
    protected abstract RowGroupScanFilterer<? extends RowGroupScanFilterer<?>> getFilterer();

    protected static abstract class RowGroupScanFilterer<B extends RowGroupScanFilterer<B>>
    extends AbstractGroupScanWithMetadata.GroupScanWithMetadataFilterer<B> {
        protected Multimap<Path, RowGroupMetadata> rowGroups = LinkedListMultimap.create();

        public RowGroupScanFilterer(AbstractGroupScanWithMetadata<?> source) {
            super(source);
        }

        public B rowGroups(Multimap<Path, RowGroupMetadata> rowGroups) {
            this.rowGroups = rowGroups;
            return (B)((RowGroupScanFilterer)this.self());
        }

        protected abstract AbstractParquetGroupScan getNewScan();

        public Multimap<Path, RowGroupMetadata> getRowGroups() {
            return this.rowGroups;
        }

        public AbstractParquetGroupScan build() {
            AbstractParquetGroupScan newScan = this.getNewScan();
            newScan.tableMetadata = this.tableMetadata;
            if (newScan.getTableMetadata() != null && this.rowGroups != null && newScan.getRowGroupsMetadata().size() != this.rowGroups.size()) {
                newScan.tableMetadata = TableMetadataUtils.updateRowCount(newScan.getTableMetadata(), this.rowGroups.values());
            }
            newScan.partitions = this.partitions;
            newScan.segments = this.segments;
            newScan.files = this.files;
            newScan.rowGroups = this.rowGroups;
            newScan.matchAllMetadata = this.matchAllMetadata;
            newScan.nonInterestingColumnsMetadata = this.nonInterestingColumnsMetadata;
            newScan.limit = this.limit;
            if (!newScan.getFilesMetadata().isEmpty()) {
                newScan.entries = newScan.getFilesMetadata().keySet().stream().map(ReadEntryWithPath::new).collect(Collectors.toList());
                newScan.fileSet = new HashSet<Path>(newScan.getFilesMetadata().keySet());
            } else if (!newScan.getRowGroupsMetadata().isEmpty()) {
                newScan.entries = newScan.getRowGroupsMetadata().keySet().stream().map(ReadEntryWithPath::new).collect(Collectors.toList());
                newScan.fileSet = new HashSet<Path>(newScan.getRowGroupsMetadata().keySet());
            }
            return newScan;
        }

        @Override
        protected B getFiltered(OptionManager optionManager, FilterPredicate<?> filterPredicate) {
            super.getFiltered(optionManager, filterPredicate);
            if (!((AbstractParquetGroupScan)this.source).getRowGroupsMetadata().isEmpty()) {
                this.filterRowGroupMetadata(optionManager, filterPredicate);
            }
            return (B)((RowGroupScanFilterer)this.self());
        }

        protected void filterRowGroupMetadata(OptionManager optionManager, FilterPredicate<?> filterPredicate) {
            Set<SchemaPath> schemaPathsInExpr = this.filterExpression.accept(FilterEvaluatorUtils.FieldReferenceFinder.INSTANCE, null);
            AbstractParquetGroupScan abstractParquetGroupScan = (AbstractParquetGroupScan)this.source;
            Multimap<Path, RowGroupMetadata> prunedRowGroups = !abstractParquetGroupScan.getFilesMetadata().isEmpty() && abstractParquetGroupScan.getFilesMetadata().size() > this.getFiles().size() ? abstractParquetGroupScan.pruneRowGroupsForFiles(this.getFiles()) : (!abstractParquetGroupScan.getPartitionsMetadata().isEmpty() && abstractParquetGroupScan.getPartitionsMetadata().size() > this.getPartitions().size() ? AbstractParquetGroupScan.pruneForPartitions(abstractParquetGroupScan.getRowGroupsMetadata(), this.getPartitions()) : (!abstractParquetGroupScan.getSegmentsMetadata().isEmpty() && abstractParquetGroupScan.getSegmentsMetadata().size() > this.getSegments().size() ? RowGroupScanFilterer.pruneForSegments(abstractParquetGroupScan.getRowGroupsMetadata(), this.getSegments()) : abstractParquetGroupScan.getRowGroupsMetadata()));
            if (this.isMatchAllMetadata()) {
                this.rowGroups = prunedRowGroups;
                return;
            }
            if ((long)prunedRowGroups.size() <= optionManager.getOption(PlannerSettings.PARQUET_ROWGROUP_FILTER_PUSHDOWN_PLANNING_THRESHOLD)) {
                this.matchAllMetadata = true;
                List<RowGroupMetadata> filteredRowGroups = this.filterAndGetMetadata(schemaPathsInExpr, prunedRowGroups.values(), filterPredicate, optionManager);
                this.rowGroups = LinkedListMultimap.create();
                filteredRowGroups.forEach(entry -> this.rowGroups.put(entry.getPath(), (RowGroupMetadata)entry));
                if (MapUtils.isNotEmpty((Map)this.files)) {
                    this.files = this.rowGroups.keySet().stream().map(this.files::get).collect(Collectors.toMap(FileMetadata::getPath, Function.identity(), (o, n) -> n, LinkedHashMap::new));
                }
            } else {
                this.rowGroups = prunedRowGroups;
                this.matchAllMetadata = false;
                this.overflowLevel = MetadataType.ROW_GROUP;
            }
        }

        @Override
        protected void filterFileMetadata(OptionManager optionManager, FilterPredicate<?> filterPredicate, Set<SchemaPath> schemaPathsInExpr) {
            Map<Path, FileMetadata> prunedFiles = !this.source.getPartitionsMetadata().isEmpty() && this.source.getPartitionsMetadata().size() > this.getPartitions().size() ? AbstractParquetGroupScan.pruneForPartitions(this.source.getFilesMetadata(), this.getPartitions()) : (!this.source.getSegmentsMetadata().isEmpty() && this.source.getSegmentsMetadata().size() > this.getSegments().size() ? RowGroupScanFilterer.pruneForSegments(this.source.getFilesMetadata(), this.getSegments()) : this.source.getFilesMetadata());
            if (this.isMatchAllMetadata()) {
                this.files = prunedFiles;
                return;
            }
            HashMap omittedFiles = new HashMap();
            AbstractParquetGroupScan abstractParquetGroupScan = (AbstractParquetGroupScan)this.source;
            HashMap<Path, FileMetadata> filesToFilter = new HashMap<Path, FileMetadata>(prunedFiles);
            if (!abstractParquetGroupScan.getRowGroupsMetadata().isEmpty()) {
                prunedFiles.forEach((path, fileMetadata) -> {
                    if (abstractParquetGroupScan.rowGroups.get((Path)path).size() == 1) {
                        omittedFiles.put(path, fileMetadata);
                        filesToFilter.remove(path);
                    }
                });
            }
            if ((long)filesToFilter.size() <= optionManager.getOption(PlannerSettings.PARQUET_ROWGROUP_FILTER_PUSHDOWN_PLANNING_THRESHOLD)) {
                this.matchAllMetadata = true;
                this.files = this.filterAndGetMetadata(schemaPathsInExpr, filesToFilter.values(), filterPredicate, optionManager).stream().collect(Collectors.toMap(FileMetadata::getPath, Function.identity()));
                this.files.putAll(omittedFiles);
            } else {
                this.matchAllMetadata = false;
                this.files = prunedFiles;
                this.overflowLevel = MetadataType.FILE;
            }
        }

        protected static <T extends BaseMetadata> Multimap<Path, T> pruneForSegments(Multimap<Path, T> metadataToPrune, Map<Path, SegmentMetadata> filteredSegmentMetadata) {
            LinkedListMultimap<Path, BaseMetadata> prunedFiles = LinkedListMultimap.create();
            if (metadataToPrune != null) {
                block0: for (Map.Entry<Path, T> entry : metadataToPrune.entries()) {
                    for (SegmentMetadata filteredPartition : filteredSegmentMetadata.values()) {
                        if (!filteredPartition.getLocations().contains(entry.getKey())) continue;
                        prunedFiles.put(entry.getKey(), (BaseMetadata)entry.getValue());
                        continue block0;
                    }
                }
            }
            return prunedFiles;
        }
    }
}

