/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mock;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.planner.logical.DrillTableSelection;
import org.apache.drill.exec.planner.logical.DynamicDrillTable;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.mock.MockGroupScanPOP;
import org.apache.drill.exec.store.mock.MockStorageEngineConfig;
import org.apache.drill.exec.store.mock.MockTableDef;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.io.Resources;

public class MockStorageEngine
extends AbstractStoragePlugin {
    private final MockStorageEngineConfig configuration;
    private final MockSchema schema;

    public MockStorageEngine(MockStorageEngineConfig configuration, DrillbitContext context, String name) {
        super(context, name);
        this.configuration = configuration;
        this.schema = new MockSchema(this, name);
    }

    @Override
    public AbstractGroupScan getPhysicalScan(String userName, JSONOptions selection, List<SchemaPath> columns) throws IOException {
        MockTableDef.MockTableSelection tableSelection = selection.getWith(JacksonUtils.createObjectMapper(), MockTableDef.MockTableSelection.class);
        List<MockTableDef.MockScanEntry> readEntries = tableSelection.getEntries();
        assert (!readEntries.isEmpty());
        return new MockGroupScanPOP(null, readEntries);
    }

    @Override
    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) throws IOException {
        parent.add(this.schema.getName(), (Schema)this.schema);
    }

    @Override
    public StoragePluginConfig getConfig() {
        return this.configuration;
    }

    @Override
    public boolean supportsRead() {
        return true;
    }

    private static class MockSchema
    extends AbstractSchema {
        private final MockStorageEngine engine;
        private final Map<String, Table> tableCache = new WeakHashMap<String, Table>();

        public MockSchema(MockStorageEngine engine) {
            super(ImmutableList.of(), "mock");
            this.engine = engine;
        }

        public MockSchema(MockStorageEngine engine, String name) {
            super(ImmutableList.of(), name);
            this.engine = engine;
        }

        @Override
        public Table getTable(String name) {
            Table table = this.tableCache.get(name);
            if (table == null) {
                table = name.toLowerCase().endsWith(".json") ? this.getConfigFile(name) : this.getDirectTable(name);
                this.tableCache.put(name, table);
            }
            return table;
        }

        private Table getConfigFile(String name) {
            MockTableDef mockTableDefn;
            URL url = Resources.getResource(name);
            if (url == null) {
                throw new IllegalArgumentException("Unable to find mock table config file " + name);
            }
            try {
                String json = Resources.toString(url, Charsets.UTF_8);
                ObjectMapper mapper = JacksonUtils.createObjectMapper();
                mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
                mockTableDefn = (MockTableDef)mapper.readValue(json, MockTableDef.class);
            }
            catch (JsonParseException e) {
                throw new IllegalArgumentException("Unable to parse mock table definition file: " + name, e);
            }
            catch (JsonMappingException e) {
                throw new IllegalArgumentException("Unable to Jackson deserialize mock table definition file: " + name, e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to read mock table definition file: " + name, e);
            }
            return new DynamicDrillTable(this.engine, this.name, (DrillTableSelection)mockTableDefn.getEntries());
        }

        private Table getDirectTable(String name) {
            Pattern p = Pattern.compile("(\\w+)_(\\d+)(k|m)?", 2);
            Matcher m = p.matcher(name);
            if (!m.matches()) {
                return null;
            }
            String baseName = m.group(1);
            int n = Integer.parseInt(m.group(2));
            String unit = m.group(3);
            if (unit != null) {
                if (unit.equalsIgnoreCase("K")) {
                    n *= 1000;
                } else if (unit.equalsIgnoreCase("M")) {
                    n *= 1000000;
                }
            }
            MockTableDef.MockScanEntry entry = new MockTableDef.MockScanEntry(n, true, 0, 1, null);
            MockTableDef.MockTableSelection entries = new MockTableDef.MockTableSelection(ImmutableList.of(entry));
            return new DynamicDrillTable(this.engine, this.name, (DrillTableSelection)entries);
        }

        @Override
        public Set<String> getTableNames() {
            return new HashSet<String>();
        }

        @Override
        public String getTypeName() {
            return "mock";
        }
    }
}

