/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mock;

import java.util.LinkedList;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.ScanBatch;
import org.apache.drill.exec.physical.impl.protocol.OperatorRecordBatch;
import org.apache.drill.exec.physical.impl.scan.ScanOperatorExec;
import org.apache.drill.exec.physical.impl.scan.framework.BasicScanFactory;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedScanFramework;
import org.apache.drill.exec.record.CloseableRecordBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.store.RecordReader;
import org.apache.drill.exec.store.mock.ExtendedMockBatchReader;
import org.apache.drill.exec.store.mock.MockRecordReader;
import org.apache.drill.exec.store.mock.MockSubScanPOP;
import org.apache.drill.exec.store.mock.MockTableDef;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class MockScanBatchCreator
implements BatchCreator<MockSubScanPOP> {
    @Override
    public CloseableRecordBatch getBatch(ExecutorFragmentContext context, MockSubScanPOP config, List<RecordBatch> children) throws ExecutionSetupException {
        Preconditions.checkArgument(children.isEmpty());
        List<MockTableDef.MockScanEntry> entries = config.getReadEntries();
        MockTableDef.MockScanEntry first = entries.get(0);
        if (first.isExtended()) {
            return this.extendedMockScan(context, config, entries);
        }
        return this.legacyMockScan(context, config, entries);
    }

    private CloseableRecordBatch extendedMockScan(FragmentContext context, MockSubScanPOP config, List<MockTableDef.MockScanEntry> entries) {
        LinkedList<SchemaPath> projList = new LinkedList<SchemaPath>();
        projList.add(SchemaPath.STAR_COLUMN);
        LinkedList<ExtendedMockBatchReader> readers = new LinkedList<ExtendedMockBatchReader>();
        for (MockTableDef.MockScanEntry e : entries) {
            readers.add(new ExtendedMockBatchReader(e));
        }
        int batchSizeBytes = 0xA00000;
        MockTableDef.MockScanEntry first = entries.get(0);
        if (first.getBatchSize() > 0) {
            batchSizeBytes = first.getBatchSize();
        }
        ManagedScanFramework.ScanFrameworkBuilder builder = new ManagedScanFramework.ScanFrameworkBuilder();
        builder.batchByteLimit(batchSizeBytes);
        builder.projection(projList);
        builder.setReaderFactory(new BasicScanFactory(readers.iterator()));
        ManagedScanFramework framework = new ManagedScanFramework(builder);
        return new OperatorRecordBatch(context, config, new ScanOperatorExec(framework, false), false);
    }

    private CloseableRecordBatch legacyMockScan(FragmentContext context, MockSubScanPOP config, List<MockTableDef.MockScanEntry> entries) throws ExecutionSetupException {
        LinkedList<RecordReader> readers = new LinkedList<RecordReader>();
        for (MockTableDef.MockScanEntry e : entries) {
            readers.add(new MockRecordReader(context, e));
        }
        return new ScanBatch(config, context, readers);
    }
}

