/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mock;

import java.util.Map;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.store.AbstractRecordReader;
import org.apache.drill.exec.store.mock.MockTableDef;
import org.apache.drill.exec.vector.AllocationHelper;
import org.apache.drill.exec.vector.ValueVector;

public class MockRecordReader
extends AbstractRecordReader {
    private final MockTableDef.MockScanEntry config;
    private final FragmentContext context;
    private ValueVector[] valueVectors;
    private int recordsRead;
    private int batchRecordCount;
    private OperatorContext operatorContext;

    public MockRecordReader(FragmentContext context, MockTableDef.MockScanEntry config) {
        this.context = context;
        this.config = config;
    }

    private int getEstimatedRecordSize(MockTableDef.MockColumn[] types) {
        if (types == null) {
            return 0;
        }
        int x = 0;
        for (int i = 0; i < types.length; ++i) {
            x += TypeHelper.getSize(types[i].getMajorType());
        }
        return x;
    }

    private MaterializedField getVector(String name, TypeProtos.MajorType type) {
        assert (this.context != null) : "Context shouldn't be null.";
        MaterializedField f = MaterializedField.create(name, type);
        return f;
    }

    @Override
    public void setup(OperatorContext context, OutputMutator output) throws ExecutionSetupException {
        try {
            int estimateRowSize = this.getEstimatedRecordSize(this.config.getTypes());
            if (this.config.getTypes() == null) {
                return;
            }
            this.valueVectors = new ValueVector[this.config.getTypes().length];
            this.batchRecordCount = 250000 / estimateRowSize;
            for (int i = 0; i < this.config.getTypes().length; ++i) {
                TypeProtos.MajorType type = this.config.getTypes()[i].getMajorType();
                MaterializedField field = this.getVector(this.config.getTypes()[i].getName(), type);
                Class<? extends ValueVector> vvClass = TypeHelper.getValueVectorClass(field.getType().getMinorType(), field.getDataMode());
                this.valueVectors[i] = output.addField(field, vvClass);
            }
        }
        catch (SchemaChangeException e) {
            throw new ExecutionSetupException("Failure while setting up fields", e);
        }
    }

    @Override
    public int next() {
        if (this.recordsRead >= this.config.getRecords()) {
            return 0;
        }
        int recordSetSize = Math.min(this.batchRecordCount, this.config.getRecords() - this.recordsRead);
        this.recordsRead += recordSetSize;
        if (this.valueVectors == null) {
            return recordSetSize;
        }
        for (ValueVector v : this.valueVectors) {
            ValueVector.Mutator m = v.getMutator();
            m.generateTestData(recordSetSize);
        }
        return recordSetSize;
    }

    @Override
    public void allocate(Map<String, ValueVector> vectorMap) throws OutOfMemoryException {
        try {
            for (ValueVector v : vectorMap.values()) {
                AllocationHelper.allocate(v, 65535, 50, 10);
            }
        }
        catch (NullPointerException e) {
            throw new OutOfMemoryException();
        }
    }

    @Override
    public void close() {
    }
}

