/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mock;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.store.mock.BooleanGen;
import org.apache.drill.exec.store.mock.DoubleGen;
import org.apache.drill.exec.store.mock.FieldGen;
import org.apache.drill.exec.store.mock.IntGen;
import org.apache.drill.exec.store.mock.MockTableDef;
import org.apache.drill.exec.store.mock.StringGen;

public class ColumnDef {
    public MockTableDef.MockColumn mockCol;
    public String name;
    public int width;
    public FieldGen generator;
    public boolean nullable;
    public int nullablePercent;

    public ColumnDef(MockTableDef.MockColumn mockCol) {
        this.mockCol = mockCol;
        this.name = mockCol.getName();
        this.width = mockCol.getMinorType() == TypeProtos.MinorType.VARCHAR && mockCol.getWidth() > 0 ? mockCol.getWidth() : TypeHelper.getSize(mockCol.getMajorType());
        boolean bl = this.nullable = mockCol.getMode() == TypeProtos.DataMode.OPTIONAL;
        if (this.nullable) {
            Object value;
            this.nullablePercent = 25;
            if (mockCol.properties != null && (value = mockCol.properties.get("nulls")) != null && value instanceof Integer) {
                this.nullablePercent = (Integer)value;
            }
        }
        this.makeGenerator();
    }

    private void makeGenerator() {
        String genName = this.mockCol.getGenerator();
        if (genName != null) {
            if (!genName.contains(".")) {
                genName = "org.apache.drill.exec.store.mock." + genName;
            }
            try {
                ClassLoader cl = this.getClass().getClassLoader();
                Class<?> genClass = cl.loadClass(genName);
                this.generator = (FieldGen)genClass.newInstance();
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("Generator " + genName + " is undefined for mock field " + this.name);
            }
            return;
        }
        this.makeDefaultGenerator();
    }

    private void makeDefaultGenerator() {
        TypeProtos.MinorType minorType = this.mockCol.getMinorType();
        switch (minorType) {
            case BIGINT: {
                break;
            }
            case BIT: {
                this.generator = new BooleanGen();
                break;
            }
            case DATE: {
                break;
            }
            case DECIMAL18: {
                break;
            }
            case DECIMAL28DENSE: {
                break;
            }
            case DECIMAL28SPARSE: {
                break;
            }
            case DECIMAL38DENSE: {
                break;
            }
            case DECIMAL38SPARSE: {
                break;
            }
            case VARDECIMAL: {
                break;
            }
            case DECIMAL9: {
                break;
            }
            case FIXED16CHAR: {
                break;
            }
            case FIXEDBINARY: {
                break;
            }
            case FIXEDCHAR: {
                break;
            }
            case FLOAT4: {
                break;
            }
            case FLOAT8: {
                this.generator = new DoubleGen();
                break;
            }
            case GENERIC_OBJECT: {
                break;
            }
            case INT: {
                this.generator = new IntGen();
                break;
            }
            case INTERVAL: {
                break;
            }
            case INTERVALDAY: {
                break;
            }
            case INTERVALYEAR: {
                break;
            }
            case LATE: {
                break;
            }
            case LIST: {
                break;
            }
            case MAP: {
                break;
            }
            case MONEY: {
                break;
            }
            case NULL: {
                break;
            }
            case SMALLINT: {
                break;
            }
            case TIME: {
                break;
            }
            case TIMESTAMP: {
                break;
            }
            case TIMESTAMPTZ: {
                break;
            }
            case TIMETZ: {
                break;
            }
            case TINYINT: {
                break;
            }
            case UINT1: {
                break;
            }
            case UINT2: {
                break;
            }
            case UINT4: {
                break;
            }
            case UINT8: {
                break;
            }
            case UNION: {
                break;
            }
            case VAR16CHAR: {
                break;
            }
            case VARBINARY: {
                break;
            }
            case VARCHAR: {
                this.generator = new StringGen();
                break;
            }
        }
        if (this.generator == null) {
            throw new IllegalArgumentException("No default column generator for column " + this.name + " of type " + minorType);
        }
    }

    public ColumnDef(MockTableDef.MockColumn mockCol, int rep) {
        this(mockCol);
        this.name = this.name + Integer.toString(rep);
    }

    public MockTableDef.MockColumn getConfig() {
        return this.mockCol;
    }

    public String getName() {
        return this.name;
    }
}

