/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.ischema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.planner.logical.DrillViewInfoProvider;
import org.apache.drill.exec.planner.types.DrillRelDataTypeSystem;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.WorkspaceSchemaFactory;
import org.apache.drill.exec.store.ischema.FilterEvaluator;
import org.apache.drill.exec.store.ischema.Records;
import org.apache.drill.exec.util.FileSystemUtil;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.metastore.Metastore;
import org.apache.drill.metastore.MetastoreColumn;
import org.apache.drill.metastore.components.tables.BasicTablesRequests;
import org.apache.drill.metastore.components.tables.BasicTablesTransformer;
import org.apache.drill.metastore.components.tables.TableMetadataUnit;
import org.apache.drill.metastore.expressions.FilterExpression;
import org.apache.drill.metastore.metadata.BaseTableMetadata;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RecordCollector {
    public List<Records.Catalog> catalogs(String var1, SchemaPlus var2);

    public List<Records.Schema> schemas(String var1, SchemaPlus var2);

    public List<Records.Table> tables(String var1, SchemaPlus var2);

    public List<Records.View> views(String var1, SchemaPlus var2);

    public List<Records.Column> columns(String var1, SchemaPlus var2);

    public List<Records.Partition> partitions(String var1, SchemaPlus var2);

    public List<Records.File> files(String var1, SchemaPlus var2);

    public static class MetastoreRecordCollector
    implements RecordCollector {
        private static final Logger logger = LoggerFactory.getLogger(MetastoreRecordCollector.class);
        public static final int UNDEFINED_INDEX = -1;
        private final Metastore metastore;
        private final FilterEvaluator filterEvaluator;

        public MetastoreRecordCollector(Metastore metastore, FilterEvaluator filterEvaluator) {
            this.metastore = metastore;
            this.filterEvaluator = filterEvaluator;
        }

        @Override
        public List<Records.Catalog> catalogs(String schemaPath, SchemaPlus schema) {
            return Collections.emptyList();
        }

        @Override
        public List<Records.Schema> schemas(String schemaPath, SchemaPlus schema) {
            return Collections.emptyList();
        }

        @Override
        public List<Records.Table> tables(String schemaPath, SchemaPlus schema) {
            AbstractSchema drillSchema = (AbstractSchema)schema.unwrap(AbstractSchema.class);
            ArrayList<Records.Table> records = new ArrayList<Records.Table>();
            if (this.shouldVisitSchema(drillSchema)) {
                List<BaseTableMetadata> baseTableMetadata;
                try {
                    baseTableMetadata = this.metastore.tables().basicRequests().tablesMetadata(FilterExpression.and(FilterExpression.equal(MetastoreColumn.STORAGE_PLUGIN, drillSchema.getSchemaPath().get(0)), FilterExpression.equal(MetastoreColumn.WORKSPACE, drillSchema.getSchemaPath().get(1))));
                }
                catch (Exception e) {
                    logger.warn("Error while retrieving Metastore table data: {}", (Object)e.getMessage());
                    logger.debug(e.getMessage(), (Throwable)e);
                    return records;
                }
                baseTableMetadata.stream().filter(table -> this.filterEvaluator.shouldVisitTable(schemaPath, table.getTableInfo().name(), Schema.TableType.TABLE)).map(table -> new Records.Table("DRILL", schemaPath, Schema.TableType.TABLE.toString(), (BaseTableMetadata)table)).forEach(records::add);
            }
            return records;
        }

        @Override
        public List<Records.View> views(String schemaPath, SchemaPlus schema) {
            return Collections.emptyList();
        }

        @Override
        public List<Records.Column> columns(String schemaPath, SchemaPlus schema) {
            AbstractSchema drillSchema = (AbstractSchema)schema.unwrap(AbstractSchema.class);
            ArrayList<Records.Column> records = new ArrayList<Records.Column>();
            if (this.shouldVisitSchema(drillSchema)) {
                List<BaseTableMetadata> baseTableMetadata;
                try {
                    baseTableMetadata = this.metastore.tables().basicRequests().tablesMetadata(FilterExpression.and(FilterExpression.equal(MetastoreColumn.STORAGE_PLUGIN, drillSchema.getSchemaPath().get(0)), FilterExpression.equal(MetastoreColumn.WORKSPACE, drillSchema.getSchemaPath().get(1)), FilterExpression.isNotNull(MetastoreColumn.SCHEMA)));
                }
                catch (Exception e) {
                    logger.warn("Error while retrieving Metastore table data: {}", (Object)e.getMessage());
                    logger.debug(e.getMessage(), (Throwable)e);
                    return records;
                }
                baseTableMetadata.stream().filter(table -> this.filterEvaluator.shouldVisitTable(schemaPath, table.getTableInfo().name(), Schema.TableType.TABLE)).map(table -> this.columns(schemaPath, (BaseTableMetadata)table, table.getSchema(), null, -1, false)).forEach(records::addAll);
            }
            return records;
        }

        private List<Records.Column> columns(String schemaPath, BaseTableMetadata table, TupleMetadata schema, List<String> parentColumnNames, int columnIndex, boolean isNested) {
            ArrayList<Records.Column> records = new ArrayList<Records.Column>();
            schema.toMetadataList().forEach(column -> {
                String columnPath;
                String tableName;
                int currentIndex;
                ArrayList<String> columnNames = CollectionUtils.isEmpty((Collection)parentColumnNames) ? new ArrayList<String>() : new ArrayList(parentColumnNames);
                columnNames.add(column.name());
                int n = currentIndex = columnIndex == -1 ? schema.index(column.name()) : columnIndex;
                if (column.isMap()) {
                    List<Records.Column> mapRecords = this.columns(schemaPath, table, column.tupleSchema(), columnNames, currentIndex, true);
                    records.addAll(mapRecords);
                }
                if (this.filterEvaluator.shouldVisitColumn(schemaPath, tableName = table.getTableInfo().name(), columnPath = String.join((CharSequence)".", columnNames))) {
                    ColumnStatistics<?> columnStatistics = table.getColumnStatistics(SchemaPath.getCompoundPath(columnNames.toArray(new String[0])));
                    records.add(new Records.Column("DRILL", schemaPath, tableName, columnPath, (ColumnMetadata)column, columnStatistics, currentIndex, isNested));
                }
            });
            return records;
        }

        @Override
        public List<Records.Partition> partitions(String schemaPath, SchemaPlus schema) {
            AbstractSchema drillSchema = (AbstractSchema)schema.unwrap(AbstractSchema.class);
            ArrayList<Records.Partition> records = new ArrayList<Records.Partition>();
            if (this.shouldVisitSchema(drillSchema)) {
                BasicTablesTransformer.MetadataHolder metadataHolder;
                try {
                    BasicTablesRequests.RequestMetadata requestMetadata = BasicTablesRequests.RequestMetadata.builder().metadataTypes(MetadataType.SEGMENT, MetadataType.PARTITION).customFilter(FilterExpression.and(FilterExpression.equal(MetastoreColumn.STORAGE_PLUGIN, drillSchema.getSchemaPath().get(0)), FilterExpression.equal(MetastoreColumn.WORKSPACE, drillSchema.getSchemaPath().get(1)), FilterExpression.notEqual(MetastoreColumn.METADATA_KEY, "DEFAULT_SEGMENT"))).build();
                    List<TableMetadataUnit> units = this.metastore.tables().basicRequests().request(requestMetadata);
                    metadataHolder = BasicTablesTransformer.all(units);
                }
                catch (Exception e) {
                    logger.warn("Error while retrieving Metastore segment / partition data: {}", (Object)e.getMessage());
                    logger.debug(e.getMessage(), (Throwable)e);
                    return records;
                }
                metadataHolder.segments().stream().filter(segment -> this.filterEvaluator.shouldVisitTable(schemaPath, segment.getTableInfo().name(), Schema.TableType.TABLE)).filter(segmentMetadata -> Objects.nonNull(segmentMetadata.getPartitionValues())).map(segment -> Records.Partition.fromSegment("DRILL", schemaPath, segment)).forEach(records::addAll);
                metadataHolder.partitions().stream().filter(partition -> this.filterEvaluator.shouldVisitTable(schemaPath, partition.getTableInfo().name(), Schema.TableType.TABLE)).filter(partitionMetadata -> Objects.nonNull(partitionMetadata.getPartitionValues())).map(partition -> Records.Partition.fromPartition("DRILL", schemaPath, partition)).forEach(records::addAll);
            }
            return records;
        }

        @Override
        public List<Records.File> files(String schemaPath, SchemaPlus schema) {
            return Collections.emptyList();
        }

        private boolean shouldVisitSchema(AbstractSchema schema) {
            return schema.getSchemaPath().size() == 2;
        }
    }

    public static class BasicRecordCollector
    implements RecordCollector {
        private static final String DEFAULT_OWNER = "<owner>";
        private final FilterEvaluator filterEvaluator;
        private final OptionManager optionManager;

        public BasicRecordCollector(FilterEvaluator filterEvaluator, OptionManager optionManager) {
            this.filterEvaluator = filterEvaluator;
            this.optionManager = optionManager;
        }

        @Override
        public List<Records.Catalog> catalogs(String schemaPath, SchemaPlus schema) {
            return Collections.singletonList(new Records.Catalog("DRILL", "The internal metadata used by Drill", ""));
        }

        @Override
        public List<Records.Schema> schemas(String schemaPath, SchemaPlus schema) {
            AbstractSchema drillSchema = (AbstractSchema)schema.unwrap(AbstractSchema.class);
            return Collections.singletonList(new Records.Schema("DRILL", schemaPath, DEFAULT_OWNER, drillSchema.getTypeName(), drillSchema.isMutable()));
        }

        @Override
        public List<Records.Table> tables(String schemaPath, SchemaPlus schema) {
            AbstractSchema drillSchema = (AbstractSchema)schema.unwrap(AbstractSchema.class);
            return drillSchema.getTableNamesAndTypes().stream().filter(entry -> this.filterEvaluator.shouldVisitTable(schemaPath, (String)entry.getKey(), (Schema.TableType)entry.getValue())).map(entry -> new Records.Table("DRILL", schemaPath, (String)entry.getKey(), ((Schema.TableType)entry.getValue()).jdbcName)).collect(Collectors.toList());
        }

        @Override
        public List<Records.View> views(String schemaPath, SchemaPlus schema) {
            AbstractSchema drillSchema = (AbstractSchema)schema.unwrap(AbstractSchema.class);
            return drillSchema.getTablesByNames(schema.getTableNames()).stream().filter(pair -> ((Table)pair.getValue()).getJdbcTableType() == Schema.TableType.VIEW).filter(pair -> this.filterEvaluator.shouldVisitTable(schemaPath, (String)pair.getKey(), ((Table)pair.getValue()).getJdbcTableType())).map(pair -> new Records.View("DRILL", schemaPath, (String)pair.getKey(), pair.getValue() instanceof DrillViewInfoProvider ? ((DrillViewInfoProvider)pair.getValue()).getViewSql() : "")).collect(Collectors.toList());
        }

        @Override
        public List<Records.Column> columns(String schemaPath, SchemaPlus schema) {
            AbstractSchema drillSchema = (AbstractSchema)schema.unwrap(AbstractSchema.class);
            UserGroupInformation ugi = ImpersonationUtil.getProcessUserUGI();
            return drillSchema.needToImpersonateReadingData() ? (List)ugi.doAs(() -> this.processColumns(schemaPath, schema, drillSchema)) : this.processColumns(schemaPath, schema, drillSchema);
        }

        private List<Records.Column> processColumns(String schemaPath, SchemaPlus schema, AbstractSchema drillSchema) {
            ArrayList<Records.Column> records = new ArrayList<Records.Column>();
            for (Pair<String, ? extends Table> tableNameToTable : drillSchema.getTablesByNames(schema.getTableNames())) {
                Table table;
                Schema.TableType tableType;
                String tableName = (String)tableNameToTable.getKey();
                if (!this.filterEvaluator.shouldVisitTable(schemaPath, tableName, tableType = (table = (Table)tableNameToTable.getValue()).getJdbcTableType())) continue;
                RelDataType tableRow = table.getRowType((RelDataTypeFactory)new JavaTypeFactoryImpl(DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM));
                for (RelDataTypeField field : tableRow.getFieldList()) {
                    if (!this.filterEvaluator.shouldVisitColumn(schemaPath, tableName, field.getName())) continue;
                    records.add(new Records.Column("DRILL", schemaPath, tableName, field));
                }
            }
            return records;
        }

        @Override
        public List<Records.Partition> partitions(String schemaPath, SchemaPlus schema) {
            return Collections.emptyList();
        }

        @Override
        public List<Records.File> files(String schemaPath, SchemaPlus schema) {
            if (this.filterEvaluator.shouldVisitFiles(schemaPath, schema)) {
                try {
                    AbstractSchema drillSchema = (AbstractSchema)schema.unwrap(AbstractSchema.class);
                    if (drillSchema instanceof WorkspaceSchemaFactory.WorkspaceSchema) {
                        WorkspaceSchemaFactory.WorkspaceSchema wsSchema = (WorkspaceSchemaFactory.WorkspaceSchema)drillSchema;
                        String defaultLocation = wsSchema.getDefaultLocation();
                        DrillFileSystem fs = wsSchema.getFS();
                        boolean recursive = this.optionManager.getBoolean("storage.list_files_recursively");
                        return FileSystemUtil.listAllSafe(fs, new Path(fs.getUri().toString(), defaultLocation), recursive, new PathFilter[0]).stream().map(fileStatus -> new Records.File(schemaPath, wsSchema, (FileStatus)fileStatus)).collect(Collectors.toList());
                    }
                }
                catch (ClassCastException | UnsupportedOperationException runtimeException) {
                    // empty catch block
                }
            }
            return Collections.emptyList();
        }
    }
}

