/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.ischema;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.exec.planner.logical.DrillTableSelection;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.ischema.FilterEvaluator;
import org.apache.drill.exec.store.ischema.InfoSchemaFilter;
import org.apache.drill.exec.store.ischema.InfoSchemaRecordGenerator;
import org.apache.drill.exec.store.ischema.InfoSchemaTable;
import org.apache.drill.exec.store.ischema.RecordCollector;
import org.apache.drill.exec.store.pojo.PojoRecordReader;
import org.apache.drill.metastore.Metastore;
import org.apache.drill.metastore.MetastoreRegistry;
import org.apache.drill.metastore.exceptions.MetastoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum InfoSchemaTableType implements DrillTableSelection
{
    CATALOGS(new InfoSchemaTable.Catalogs()),
    SCHEMATA(new InfoSchemaTable.Schemata()),
    VIEWS(new InfoSchemaTable.Views()),
    COLUMNS(new InfoSchemaTable.Columns()),
    TABLES(new InfoSchemaTable.Tables()),
    PARTITIONS(new InfoSchemaTable.Partitions()),
    FILES(new InfoSchemaTable.Files());

    private static final Logger logger;
    private final InfoSchemaTable<?> tableDef;

    private InfoSchemaTableType(InfoSchemaTable<?> tableDef) {
        this.tableDef = tableDef;
    }

    public <S> PojoRecordReader<S> getRecordReader(SchemaPlus rootSchema, InfoSchemaFilter filter, OptionManager optionManager, MetastoreRegistry metastoreRegistry) {
        FilterEvaluator filterEvaluator = filter == null ? FilterEvaluator.NoFilterEvaluator.INSTANCE : new FilterEvaluator.InfoSchemaFilterEvaluator(filter);
        InfoSchemaRecordGenerator<?> recordGenerator = this.tableDef.getRecordGenerator(filterEvaluator);
        recordGenerator.registerRecordCollector(new RecordCollector.BasicRecordCollector(filterEvaluator, optionManager));
        if (optionManager.getBoolean("metastore.enabled")) {
            try {
                Metastore metastore = metastoreRegistry.get();
                recordGenerator.registerRecordCollector(new RecordCollector.MetastoreRecordCollector(metastore, filterEvaluator));
            }
            catch (MetastoreException e) {
                logger.warn("Unable to init Drill Metastore: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        recordGenerator.scanSchema(rootSchema);
        return recordGenerator.getRecordReader();
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return this.tableDef.getRowType(typeFactory);
    }

    @Override
    public String digest() {
        return this.toString();
    }

    static {
        logger = LoggerFactory.getLogger(InfoSchemaTableType.class);
    }
}

