/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.ischema;

import java.util.ArrayList;
import org.apache.drill.common.expression.BooleanOperator;
import org.apache.drill.common.expression.CastExpression;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import org.apache.drill.exec.store.ischema.InfoSchemaFilter;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;

public class InfoSchemaFilterBuilder
extends AbstractExprVisitor<InfoSchemaFilter.ExprNode, Void, RuntimeException> {
    private final LogicalExpression filter;
    private boolean isAllExpressionsConverted = true;

    public InfoSchemaFilterBuilder(LogicalExpression filter) {
        this.filter = filter;
    }

    public InfoSchemaFilter build() {
        InfoSchemaFilter.ExprNode exprRoot = this.filter.accept(this, null);
        if (exprRoot != null) {
            return new InfoSchemaFilter(exprRoot);
        }
        return null;
    }

    public boolean isAllExpressionsConverted() {
        return this.isAllExpressionsConverted;
    }

    @Override
    public InfoSchemaFilter.ExprNode visitFunctionCall(FunctionCall call, Void value) throws RuntimeException {
        String funcName;
        switch (funcName = call.getName().toLowerCase()) {
            case "equal": 
            case "not equal": 
            case "notequal": 
            case "not_equal": {
                InfoSchemaFilter.ExprNode col = call.arg(0).accept(this, value);
                InfoSchemaFilter.ExprNode constant = call.arg(1).accept(this, value);
                if (!(col instanceof InfoSchemaFilter.FieldExprNode) || !(constant instanceof InfoSchemaFilter.ConstantExprNode)) break;
                return new InfoSchemaFilter.FunctionExprNode(funcName, ImmutableList.of(col, constant));
            }
            case "like": {
                InfoSchemaFilter.ExprNode escape;
                InfoSchemaFilter.ExprNode col = call.arg(0).accept(this, value);
                InfoSchemaFilter.ExprNode pattern = call.arg(1).accept(this, value);
                InfoSchemaFilter.ExprNode exprNode = escape = call.argCount() > 2 ? call.arg(2).accept(this, value) : null;
                if (!(col instanceof InfoSchemaFilter.FieldExprNode) || !(pattern instanceof InfoSchemaFilter.ConstantExprNode) || escape != null && !(escape instanceof InfoSchemaFilter.ConstantExprNode)) break;
                return new InfoSchemaFilter.FunctionExprNode(funcName, escape == null ? ImmutableList.of(col, pattern) : ImmutableList.of(col, pattern, escape));
            }
            case "booleanAnd": 
            case "booleanand": {
                ArrayList<InfoSchemaFilter.ExprNode> args = new ArrayList<InfoSchemaFilter.ExprNode>();
                for (LogicalExpression arg : call.args()) {
                    InfoSchemaFilter.ExprNode exprNode = arg.accept(this, value);
                    if (!(exprNode instanceof InfoSchemaFilter.FunctionExprNode)) continue;
                    args.add(exprNode);
                }
                if (args.size() > 0) {
                    return new InfoSchemaFilter.FunctionExprNode(funcName, args);
                }
                return this.visitUnknown((LogicalExpression)call, value);
            }
            case "booleanOr": 
            case "booleanor": {
                ArrayList<InfoSchemaFilter.ExprNode> args = new ArrayList<InfoSchemaFilter.ExprNode>();
                for (LogicalExpression arg : call.args()) {
                    InfoSchemaFilter.ExprNode exprNode = arg.accept(this, value);
                    if (exprNode instanceof InfoSchemaFilter.FunctionExprNode) {
                        args.add(exprNode);
                        continue;
                    }
                    return this.visitUnknown((LogicalExpression)call, value);
                }
                if (args.size() > 0) {
                    return new InfoSchemaFilter.FunctionExprNode(funcName, args);
                }
                this.visitUnknown((LogicalExpression)call, value);
            }
        }
        return this.visitUnknown((LogicalExpression)call, value);
    }

    @Override
    public InfoSchemaFilter.ExprNode visitBooleanOperator(BooleanOperator op, Void value) throws RuntimeException {
        return this.visitFunctionCall((FunctionCall)op, value);
    }

    @Override
    public InfoSchemaFilter.ExprNode visitCastExpression(CastExpression e, Void value) throws RuntimeException {
        FieldReference fieldRef;
        String field;
        if (e.getInput() instanceof FieldReference && ((field = (fieldRef = (FieldReference)e.getInput()).getRootSegmentPath().toUpperCase()).equals("CATALOG_NAME") || field.equals("SCHEMA_NAME") || field.equals("TABLE_NAME") || field.equals("TABLE_SCHEMA") || field.equals("COLUMN_NAME") || field.equals("ROOT_SCHEMA_NAME") || field.equals("WORKSPACE_NAME"))) {
            return new InfoSchemaFilter.FieldExprNode(field);
        }
        return this.visitUnknown((LogicalExpression)e, value);
    }

    @Override
    public InfoSchemaFilter.ExprNode visitQuotedStringConstant(ValueExpressions.QuotedString e, Void value) throws RuntimeException {
        return new InfoSchemaFilter.ConstantExprNode((String)e.value);
    }

    @Override
    public InfoSchemaFilter.ExprNode visitSchemaPath(SchemaPath path, Void value) throws RuntimeException {
        String field = path.getRootSegmentPath().toUpperCase();
        if (field.equals("CATALOG_NAME") || field.equals("SCHEMA_NAME") || field.equals("TABLE_NAME") || field.equals("TABLE_SCHEMA") || field.equals("COLUMN_NAME") || field.equals("ROOT_SCHEMA_NAME") || field.equals("WORKSPACE_NAME")) {
            return new InfoSchemaFilter.FieldExprNode(field);
        }
        return this.visitUnknown((LogicalExpression)path, value);
    }

    @Override
    public InfoSchemaFilter.ExprNode visitUnknown(LogicalExpression e, Void value) throws RuntimeException {
        this.isAllExpressionsConverted = false;
        return null;
    }
}

