/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.ischema;

import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.dfs.WorkspaceSchemaFactory;
import org.apache.drill.exec.store.ischema.InfoSchemaFilter;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;

public interface FilterEvaluator {
    public boolean shouldVisitCatalog();

    public boolean shouldPruneSchema(String var1);

    public boolean shouldVisitSchema(String var1, SchemaPlus var2);

    public boolean shouldVisitTable(String var1, String var2, Schema.TableType var3);

    public boolean shouldVisitColumn(String var1, String var2, String var3);

    public boolean shouldVisitFiles(String var1, SchemaPlus var2);

    public static class InfoSchemaFilterEvaluator
    extends NoFilterEvaluator {
        private final InfoSchemaFilter filter;

        public InfoSchemaFilterEvaluator(InfoSchemaFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean shouldVisitCatalog() {
            ImmutableMap<String, String> recordValues = ImmutableMap.of("CATALOG_NAME", "DRILL");
            return this.filter.evaluate(recordValues) != InfoSchemaFilter.Result.FALSE;
        }

        @Override
        public boolean shouldPruneSchema(String schemaName) {
            ImmutableMap<String, String> recordValues = ImmutableMap.of("CATALOG_NAME", "DRILL", "TABLE_SCHEMA", schemaName, "SCHEMA_NAME", schemaName);
            return this.filter.evaluate(recordValues, true) == InfoSchemaFilter.Result.FALSE;
        }

        @Override
        public boolean shouldVisitSchema(String schemaName, SchemaPlus schema) {
            if (!super.shouldVisitSchema(schemaName, schema)) {
                return false;
            }
            ImmutableMap<String, String> recordValues = ImmutableMap.of("CATALOG_NAME", "DRILL", "TABLE_SCHEMA", schemaName, "SCHEMA_NAME", schemaName);
            return this.filter.evaluate(recordValues) != InfoSchemaFilter.Result.FALSE;
        }

        @Override
        public boolean shouldVisitTable(String schemaName, String tableName, Schema.TableType tableType) {
            ImmutableMap<String, String> recordValues = ImmutableMap.of("CATALOG_NAME", "DRILL", "TABLE_SCHEMA", schemaName, "SCHEMA_NAME", schemaName, "TABLE_NAME", tableName, "TABLE_TYPE", tableType.jdbcName);
            return this.filter.evaluate(recordValues) != InfoSchemaFilter.Result.FALSE;
        }

        @Override
        public boolean shouldVisitColumn(String schemaName, String tableName, String columnName) {
            ImmutableMap<String, String> recordValues = ImmutableMap.of("CATALOG_NAME", "DRILL", "TABLE_SCHEMA", schemaName, "SCHEMA_NAME", schemaName, "TABLE_NAME", tableName, "COLUMN_NAME", columnName);
            return this.filter.evaluate(recordValues) != InfoSchemaFilter.Result.FALSE;
        }

        @Override
        public boolean shouldVisitFiles(String schemaName, SchemaPlus schema) {
            if (!super.shouldVisitFiles(schemaName, schema)) {
                return false;
            }
            AbstractSchema drillSchema = (AbstractSchema)schema.unwrap(AbstractSchema.class);
            WorkspaceSchemaFactory.WorkspaceSchema wsSchema = (WorkspaceSchemaFactory.WorkspaceSchema)drillSchema;
            ImmutableMap<String, String> recordValues = ImmutableMap.of("SCHEMA_NAME", schemaName, "ROOT_SCHEMA_NAME", wsSchema.getSchemaPath().get(0), "WORKSPACE_NAME", wsSchema.getName());
            return this.filter.evaluate(recordValues) != InfoSchemaFilter.Result.FALSE;
        }
    }

    public static class NoFilterEvaluator
    implements FilterEvaluator {
        public static final FilterEvaluator INSTANCE = new NoFilterEvaluator();

        @Override
        public boolean shouldVisitCatalog() {
            return true;
        }

        @Override
        public boolean shouldPruneSchema(String schemaName) {
            return false;
        }

        @Override
        public boolean shouldVisitSchema(String schemaName, SchemaPlus schema) {
            try {
                AbstractSchema drillSchema = (AbstractSchema)schema.unwrap(AbstractSchema.class);
                return drillSchema.showInInformationSchema();
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public boolean shouldVisitTable(String schemaName, String tableName, Schema.TableType tableType) {
            return true;
        }

        @Override
        public boolean shouldVisitColumn(String schemaName, String tableName, String columnName) {
            return true;
        }

        @Override
        public boolean shouldVisitFiles(String schemaName, SchemaPlus schema) {
            try {
                AbstractSchema drillSchema = (AbstractSchema)schema.unwrap(AbstractSchema.class);
                return drillSchema instanceof WorkspaceSchemaFactory.WorkspaceSchema;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
    }
}

