/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.http.oauth;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.util.JacksonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthUtils {
    private static final Logger logger = LoggerFactory.getLogger(OAuthUtils.class);
    private static final ObjectMapper MAPPER = JacksonUtils.createObjectMapper();

    public static RequestBody getPostRequest(CredentialsProvider credentialsProvider, String authorizationCode, String callbackURL) {
        return new FormBody.Builder().add("grant_type", "authorization_code").add("client_id", credentialsProvider.getCredentials().get("clientID")).add("client_secret", credentialsProvider.getCredentials().get("clientSecret")).add("redirect_uri", callbackURL).add("code", authorizationCode).build();
    }

    public static RequestBody getPostRequestForTokenRefresh(CredentialsProvider credentialsProvider, String refreshToken) {
        return new FormBody.Builder().add("grant_type", "refresh_token").add("client_id", credentialsProvider.getCredentials().get("clientID")).add("client_secret", credentialsProvider.getCredentials().get("clientSecret")).add("refresh_token", refreshToken).build();
    }

    public static String buildAccessTokenURL(CredentialsProvider credentialsProvider) {
        return credentialsProvider.getCredentials().get("tokenURI");
    }

    public static Request getAccessTokenRequest(CredentialsProvider credentialsProvider, String authenticationCode, String callbackURL) {
        return new Request.Builder().url(OAuthUtils.buildAccessTokenURL(credentialsProvider)).header("Content-Type", "application/json").addHeader("Accept", "application/json").post(OAuthUtils.getPostRequest(credentialsProvider, authenticationCode, callbackURL)).build();
    }

    public static Request getAccessTokenRequestFromRefreshToken(CredentialsProvider credentialsProvider, String refreshToken) {
        String tokenURI = credentialsProvider.getCredentials().get("tokenURI");
        logger.debug("Requesting new access token with refresh token from {}", (Object)tokenURI);
        return new Request.Builder().url(tokenURI).header("Content-Type", "application/json").addHeader("Accept", "application/json").post(OAuthUtils.getPostRequestForTokenRefresh(credentialsProvider, refreshToken)).build();
    }

    public static Map<String, String> getOAuthTokens(OkHttpClient client, Request request) {
        HashMap<String, String> tokens = new HashMap<String, String>();
        try (Response response = null;){
            response = client.newCall(request).execute();
            String responseBody = response.body().string();
            if (!response.isSuccessful()) {
                throw UserException.connectionError().message("Error obtaining access tokens: ", new Object[0]).addContext(response.message()).addContext("Response code: " + response.code()).addContext(response.body().string()).build(logger);
            }
            logger.debug("Response: {}", (Object)responseBody);
            Map parsedJson = (Map)MAPPER.readValue(responseBody, Map.class);
            if (!parsedJson.containsKey("access_token")) {
                throw UserException.connectionError().message("Error obtaining access token.", new Object[0]).addContext(parsedJson.toString()).build(logger);
            }
            String accessToken = (String)parsedJson.get("access_token");
            tokens.put("accessToken", accessToken);
            logger.debug("Successfully added access token");
            if (parsedJson.containsKey("refresh_token")) {
                String refreshToken = (String)parsedJson.get("refresh_token");
                tokens.put("refreshToken", refreshToken);
            }
            if (parsedJson.containsKey("expires_in")) {
                String expiresIn = String.valueOf(parsedJson.get("expires_in"));
                tokens.put("expiresIn", expiresIn);
            }
            HashMap<String, String> hashMap = tokens;
            return hashMap;
        }
    }
}

