/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.enumerable.plan;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.planner.physical.LeafPrel;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.schema.SchemaProvider;
import org.apache.drill.exec.store.enumerable.ColumnConverterFactoryProvider;
import org.apache.drill.exec.store.enumerable.EnumerableGroupScan;
import org.apache.drill.exec.store.enumerable.plan.EnumerablePrelContext;

public class EnumerablePrel
extends AbstractRelNode
implements LeafPrel {
    private final String code;
    private final String schemaPath;
    private final String plan;
    private final double rows;
    private final Map<String, Integer> fieldsMap;
    private final TupleMetadata schema;
    private final String planPrefix;
    private final ColumnConverterFactoryProvider factoryProvider;

    public EnumerablePrel(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, EnumerablePrelContext context) {
        super(cluster, traitSet);
        this.rowType = input.getRowType();
        this.rows = input.estimateRowCount(cluster.getMetadataQuery());
        this.planPrefix = context.getPlanPrefix();
        RelNode transformedNode = context.transformNode(input);
        this.fieldsMap = context.getFieldsMap(transformedNode);
        this.plan = RelOptUtil.toString((RelNode)transformedNode);
        this.code = context.generateCode(cluster, transformedNode);
        this.schemaPath = context.getTablePath(input);
        try {
            TableScan scan = Objects.requireNonNull(DrillRelOptUtil.findScan(input));
            SchemaProvider schemaProvider = DrillRelOptUtil.getDrillTable((RelNode)scan).getMetadataProviderManager().getSchemaProvider();
            this.schema = schemaProvider != null ? schemaProvider.read().getSchema() : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.factoryProvider = context.factoryProvider();
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) {
        List<SchemaPath> columns = this.rowType.getFieldNames().stream().map(SchemaPath::getSimplePath).collect(Collectors.toList());
        EnumerableGroupScan groupScan = new EnumerableGroupScan(this.code, columns, this.fieldsMap, this.rows, this.schema, this.schemaPath, this.factoryProvider);
        return creator.addMetadata(this, groupScan);
    }

    public RelWriter explainTerms(RelWriter pw) {
        pw.item(this.planPrefix, (Object)this.plan);
        return super.explainTerms(pw);
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return this.rows;
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.DEFAULT;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }
}

