/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.enumerable;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.compile.ClassBuilder;
import org.apache.drill.exec.exception.ClassTransformationException;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.framework.SchemaNegotiator;
import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.planner.sql.SchemaUtilities;
import org.apache.drill.exec.record.ColumnConverter;
import org.apache.drill.exec.record.ColumnConverterFactory;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.exec.store.enumerable.ColumnConverterFactoryProvider;
import org.apache.drill.exec.store.enumerable.DrillDataContext;
import org.apache.drill.shaded.guava.com.google.common.base.Throwables;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumerableRecordReader
implements ManagedReader<SchemaNegotiator> {
    private static final Logger logger = LoggerFactory.getLogger(EnumerableRecordReader.class);
    private static final String CLASS_NAME = "Baz";
    private final List<SchemaPath> columns;
    private final Map<String, Integer> fieldsMap;
    private final String code;
    private final String schemaPath;
    private final ColumnConverterFactoryProvider factoryProvider;
    private ColumnConverter converter;
    private Iterator<Map<String, Object>> records;
    private ResultSetLoader loader;

    public EnumerableRecordReader(List<SchemaPath> columns, Map<String, Integer> fieldsMap, String code, String schemaPath, ColumnConverterFactoryProvider factoryProvider) {
        this.columns = columns;
        this.fieldsMap = fieldsMap;
        this.code = code;
        this.schemaPath = schemaPath;
        this.factoryProvider = factoryProvider;
    }

    private void setup(OperatorContext context) {
        SchemaPlus rootSchema = context.getFragmentContext().getFullRootSchema();
        DrillDataContext root = new DrillDataContext(this.schemaPath != null ? SchemaUtilities.searchSchemaTree(rootSchema, SchemaUtilities.getSchemaPathAsList(this.schemaPath)) : rootSchema, (JavaTypeFactory)new JavaTypeFactoryImpl(), Collections.emptyMap());
        try {
            Class<?> implementationClass = ClassBuilder.getCompiledClass(this.code, CLASS_NAME, context.getFragmentContext().getConfig(), context.getFragmentContext().getOptions());
            Iterable iterable = (Iterable)implementationClass.getMethod(BuiltInMethod.BINDABLE_BIND.method.getName(), DataContext.class).invoke(implementationClass.newInstance(), root);
            this.records = this.fieldsMap.keySet().size() == 1 ? StreamSupport.stream(iterable.spliterator(), false).map(this::wrap).iterator() : StreamSupport.stream(iterable.spliterator(), false).map(row -> this.wrap((Object[])row)).iterator();
        }
        catch (IOException | ReflectiveOperationException | ClassTransformationException | CompileException e) {
            logger.error("Exception happened when executing generated code", e);
            Throwable rootCause = Throwables.getRootCause(e);
            throw new DrillRuntimeException(rootCause.getMessage(), rootCause);
        }
    }

    private Map<String, Object> wrap(Object[] values) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        this.columns.stream().map(SchemaPath::getRootSegmentPath).forEach(fieldName -> {
            if (fieldName.equals("**")) {
                row.putAll((Map)values[this.fieldsMap.get(fieldName)]);
            } else {
                row.put((String)fieldName, values[this.fieldsMap.get(fieldName)]);
            }
        });
        return row;
    }

    private Map<String, Object> wrap(Object value) {
        SchemaPath schemaPath = this.columns.iterator().next();
        if (schemaPath.equals(SchemaPath.STAR_COLUMN)) {
            return (Map)value;
        }
        return Collections.singletonMap(schemaPath.getRootSegmentPath(), value);
    }

    @Override
    public boolean open(SchemaNegotiator negotiator) {
        TupleMetadata providedSchema = negotiator.providedSchema();
        this.loader = negotiator.build();
        this.setup(negotiator.context());
        ColumnConverterFactory factory = this.factoryProvider.getFactory(providedSchema);
        this.converter = factory.getRootConverter(providedSchema, new TupleSchema(), this.loader.writer());
        return true;
    }

    @Override
    public boolean next() {
        RowSetLoader rowWriter = this.loader.writer();
        while (!rowWriter.isFull()) {
            if (this.records.hasNext()) {
                this.processRecord(rowWriter, this.records.next());
                continue;
            }
            return false;
        }
        return true;
    }

    private void processRecord(RowSetLoader writer, Map<String, Object> record) {
        writer.start();
        this.converter.convert(record);
        writer.save();
    }

    @Override
    public void close() {
        this.loader.close();
    }
}

