/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.enumerable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.enumerable.ColumnConverterFactoryProvider;
import org.apache.drill.exec.store.enumerable.EnumerableSubScan;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class EnumerableGroupScan
extends AbstractGroupScan {
    private final String code;
    private final String schemaPath;
    private final Map<String, Integer> fieldsMap;
    private final List<SchemaPath> columns;
    private final double rows;
    private final TupleMetadata schema;
    private final ColumnConverterFactoryProvider converterFactoryProvider;

    @JsonCreator
    public EnumerableGroupScan(@JsonProperty(value="sql") String code, @JsonProperty(value="columns") List<SchemaPath> columns, @JsonProperty(value="fieldsMap") Map<String, Integer> fieldsMap, @JsonProperty(value="rows") double rows, @JsonProperty(value="schema") TupleMetadata schema, @JsonProperty(value="schemaPath") String schemaPath, @JsonProperty(value="converterFactoryProvider") ColumnConverterFactoryProvider converterFactoryProvider) {
        super("");
        this.code = code;
        this.columns = columns;
        this.fieldsMap = fieldsMap;
        this.rows = rows;
        this.schema = schema;
        this.schemaPath = schemaPath;
        this.converterFactoryProvider = converterFactoryProvider;
    }

    @Override
    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> endpoints) {
    }

    @Override
    public SubScan getSpecificScan(int minorFragmentId) {
        return new EnumerableSubScan(this.code, this.columns, this.fieldsMap, this.schema, this.schemaPath, this.converterFactoryProvider);
    }

    @Override
    public int getMaxParallelizationWidth() {
        return 1;
    }

    @Override
    public ScanStats getScanStats() {
        return new ScanStats(ScanStats.GroupScanProperty.NO_EXACT_ROW_COUNT, (long)Math.max(this.rows, 1.0), 1.0, 1.0);
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    public Map<String, Integer> getFieldsMap() {
        return this.fieldsMap;
    }

    public double getRows() {
        return this.rows;
    }

    public TupleMetadata getSchema() {
        return this.schema;
    }

    public String getSchemaPath() {
        return this.schemaPath;
    }

    public ColumnConverterFactoryProvider getConverterFactoryProvider() {
        return this.converterFactoryProvider;
    }

    @Override
    public String getDigest() {
        return this.toString();
    }

    @Override
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument(children.isEmpty());
        return new EnumerableGroupScan(this.code, this.columns, this.fieldsMap, this.rows, this.schema, this.schemaPath, this.converterFactoryProvider);
    }

    public String toString() {
        return new StringJoiner(", ", EnumerableGroupScan.class.getSimpleName() + "[", "]").add("code='" + this.code + "'").add("columns=" + this.columns).add("fieldsMap=" + this.fieldsMap).add("rows=" + this.rows).toString();
    }
}

