/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.enumerable;

import java.util.Collections;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.scan.framework.BasicScanFactory;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedScanFramework;
import org.apache.drill.exec.record.CloseableRecordBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.store.enumerable.EnumerableRecordReader;
import org.apache.drill.exec.store.enumerable.EnumerableSubScan;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class EnumerableBatchCreator
implements BatchCreator<EnumerableSubScan> {
    @Override
    public CloseableRecordBatch getBatch(ExecutorFragmentContext context, EnumerableSubScan subScan, List<RecordBatch> children) throws ExecutionSetupException {
        Preconditions.checkArgument(children.isEmpty());
        try {
            ManagedScanFramework.ScanFrameworkBuilder builder = this.createBuilder(subScan);
            return builder.buildScanOperator(context, subScan);
        }
        catch (UserException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ExecutionSetupException(e);
        }
    }

    private ManagedScanFramework.ScanFrameworkBuilder createBuilder(EnumerableSubScan subScan) {
        ManagedScanFramework.ScanFrameworkBuilder builder = new ManagedScanFramework.ScanFrameworkBuilder();
        builder.projection(subScan.getColumns());
        builder.setUserName(subScan.getUserName());
        builder.providedSchema(subScan.getSchema());
        EnumerableRecordReader reader = new EnumerableRecordReader(subScan.getColumns(), subScan.getFieldsMap(), subScan.getCode(), subScan.getSchemaPath(), subScan.getConverterFactoryProvider());
        BasicScanFactory readerFactory = new BasicScanFactory(Collections.singletonList(reader).iterator());
        builder.setReaderFactory(readerFactory);
        builder.nullType(Types.optional(TypeProtos.MinorType.VARCHAR));
        return builder;
    }
}

