/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.enumerable;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class DynamicTypeResolverBuilder
extends StdTypeResolverBuilder {
    public TypeDeserializer buildTypeDeserializer(DeserializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
        Reflections reflections = new Reflections("org.apache.drill.exec.store", new Scanner[0]);
        Class rawClass = baseType.getRawClass();
        List dynamicSubtypes = reflections.getSubTypesOf(rawClass).stream().map(NamedType::new).collect(Collectors.toList());
        dynamicSubtypes.addAll(subtypes);
        return super.buildTypeDeserializer(config, baseType, dynamicSubtypes);
    }
}

