/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.text.writer;

import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.store.EventBasedRecordWriter;
import org.apache.drill.exec.store.StorageStrategy;
import org.apache.drill.exec.store.StringOutputRecordWriter;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextRecordWriter
extends StringOutputRecordWriter {
    private static final Logger logger = LoggerFactory.getLogger(TextRecordWriter.class);
    private final StorageStrategy storageStrategy;
    private final Configuration fsConf;
    private FileSystem fs;
    private Path cleanUpLocation;
    private String location;
    private String prefix;
    private String extension;
    private int fileNumberIndex;
    private CsvWriterSettings writerSettings;
    private CsvWriter writer;
    private boolean fRecordStarted = false;

    public TextRecordWriter(BufferAllocator allocator, StorageStrategy storageStrategy, Configuration fsConf) {
        super(allocator);
        this.storageStrategy = storageStrategy == null ? StorageStrategy.DEFAULT : storageStrategy;
        this.fsConf = new Configuration(fsConf);
    }

    @Override
    public void init(Map<String, String> writerOptions) throws IOException {
        this.location = writerOptions.get("location");
        this.prefix = writerOptions.get("prefix");
        this.fs = FileSystem.get((Configuration)this.fsConf);
        String extension = writerOptions.get("extension");
        this.extension = extension == null ? "" : "." + extension;
        this.fileNumberIndex = 0;
        CsvWriterSettings writerSettings = new CsvWriterSettings();
        writerSettings.setMaxColumns(65536);
        writerSettings.setMaxCharsPerColumn(65535);
        writerSettings.setHeaderWritingEnabled(Boolean.parseBoolean(writerOptions.get("addHeader")));
        writerSettings.setQuoteAllFields(Boolean.parseBoolean(writerOptions.get("forceQuotes")));
        CsvFormat format = (CsvFormat)writerSettings.getFormat();
        format.setLineSeparator(writerOptions.get("lineSeparator"));
        format.setDelimiter(writerOptions.get("fieldDelimiter"));
        format.setQuote(writerOptions.get("quote").charAt(0));
        format.setQuoteEscape(writerOptions.get("escape").charAt(0));
        format.setCharToEscapeQuoteEscaping('\u0000');
        this.writerSettings = writerSettings;
        logger.trace("Text writer settings: {}", (Object)this.writerSettings);
    }

    @Override
    public void startNewSchema(BatchSchema schema) throws IOException {
        this.cleanup();
        Path fileName = new Path(this.location, String.format("%s_%s%s", this.prefix, this.fileNumberIndex, this.extension));
        try {
            this.cleanUpLocation = this.storageStrategy.createFileAndApply(this.fs, fileName);
            FSDataOutputStream fos = this.fs.create(fileName);
            this.storageStrategy.applyToFile(this.fs, fileName);
            logger.debug("Created file: {}.", (Object)fileName);
            ++this.fileNumberIndex;
            this.writer = new CsvWriter((OutputStream)fos, this.writerSettings);
        }
        catch (IOException e) {
            throw new IOException(String.format("Unable to create file: %s.", fileName), e);
        }
        if (this.writerSettings.isHeaderWritingEnabled()) {
            this.writer.writeHeaders((Collection)StreamSupport.stream(schema.spliterator(), false).map(MaterializedField::getName).collect(Collectors.toList()));
        }
    }

    @Override
    public void addField(int fieldId, String value) {
        this.writer.addValue((Object)value);
    }

    @Override
    public void startRecord() throws IOException {
        if (this.fRecordStarted) {
            throw new IOException("Previous record is not written completely");
        }
        this.fRecordStarted = true;
    }

    @Override
    public void endRecord() throws IOException {
        if (!this.fRecordStarted) {
            throw new IOException("No record is in writing");
        }
        this.writer.writeValuesToRow();
        this.fRecordStarted = false;
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewMapConverter(int fieldId, String fieldName, FieldReader reader) {
        return new ComplexStringFieldConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedMapConverter(int fieldId, String fieldName, FieldReader reader) {
        return new ComplexStringFieldConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedListConverter(int fieldId, String fieldName, FieldReader reader) {
        return new ComplexStringFieldConverter(fieldId, fieldName, reader);
    }

    @Override
    public void cleanup() throws IOException {
        this.fRecordStarted = false;
        if (this.writer != null) {
            try {
                this.writer.close();
                this.writer = null;
                logger.debug("Closed text writer for file: {}.", (Object)this.cleanUpLocation);
            }
            catch (IllegalStateException e) {
                throw new IOException(String.format("Unable to close text writer for file %s: %s", this.cleanUpLocation, e.getMessage()), e);
            }
        }
    }

    @Override
    public void abort() throws IOException {
        if (this.cleanUpLocation != null) {
            this.fs.delete(this.cleanUpLocation, true);
            logger.info("Aborting writer. Location [{}] on file system [{}] is deleted.", (Object)this.cleanUpLocation.toUri().getPath(), (Object)this.fs.getUri());
        }
    }

    public class ComplexStringFieldConverter
    extends EventBasedRecordWriter.FieldConverter {
        public ComplexStringFieldConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
        }

        @Override
        public void writeField() throws IOException {
            TextRecordWriter.this.addField(this.fieldId, this.reader.readObject().toString());
        }
    }
}

