/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.text.reader;

import io.netty.buffer.DrillBuf;
import io.netty.util.internal.PlatformDependent;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.drill.exec.memory.BoundsChecking;
import org.apache.drill.exec.store.easy.text.reader.StreamFinishedPseudoException;
import org.apache.drill.exec.store.easy.text.reader.TextParsingSettings;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.compress.CompressionInputStream;

final class TextInput {
    private final byte[] lineSeparator;
    private final byte normalizedLineSeparator;
    private final TextParsingSettings settings;
    private long lineCount;
    private long charCount;
    private final long startPos;
    private final long endPos;
    private long streamPos;
    private final Seekable seekable;
    private final FSDataInputStream inputFS;
    private final InputStream input;
    private final DrillBuf buffer;
    private final ByteBuffer underlyingBuffer;
    private final long bStart;
    private final long bStartMinus1;
    private final boolean bufferReadable;
    private int remByte = -1;
    private int bufferPtr;
    private int length = -1;
    private boolean endFound;

    TextInput(TextParsingSettings settings, InputStream input, DrillBuf readBuffer, long startPos, long endPos) {
        this.lineSeparator = settings.getNewLineDelimiter();
        byte normalizedLineSeparator = settings.getNormalizedNewLine();
        Preconditions.checkArgument(input instanceof Seekable, "Text input only supports an InputStream that supports Seekable.");
        boolean isCompressed = input instanceof CompressionInputStream;
        Preconditions.checkArgument(!isCompressed || startPos == 0L, "Cannot use split on compressed stream.");
        if (isCompressed && endPos > 0L) {
            endPos = Long.MAX_VALUE;
        }
        this.input = input;
        this.seekable = (Seekable)input;
        this.settings = settings;
        if (input instanceof FSDataInputStream) {
            this.inputFS = (FSDataInputStream)input;
            this.bufferReadable = this.inputFS.getWrappedStream() instanceof ByteBufferReadable;
        } else {
            this.inputFS = null;
            this.bufferReadable = false;
        }
        this.startPos = startPos;
        this.endPos = endPos;
        this.normalizedLineSeparator = normalizedLineSeparator;
        this.buffer = readBuffer;
        this.bStart = this.buffer.memoryAddress();
        this.bStartMinus1 = this.bStart - 1L;
        this.underlyingBuffer = this.buffer.nioBuffer(0, this.buffer.capacity());
    }

    final void start() throws IOException {
        this.lineCount = 0L;
        if (this.startPos > 0L) {
            this.seekable.seek(this.startPos);
        }
        this.updateBuffer();
        if (this.length > 0 && (this.startPos > 0L || this.settings.isSkipFirstLine())) {
            try {
                this.skipLines(1);
            }
            catch (StreamFinishedPseudoException streamFinishedPseudoException) {
                // empty catch block
            }
        }
    }

    public String getStringSinceMarkForError() {
        return " ";
    }

    long getPos() {
        return this.streamPos + (long)this.bufferPtr;
    }

    public void mark() {
    }

    private void read() throws IOException {
        if (this.bufferReadable) {
            if (this.remByte != -1) {
                for (int i = 0; i <= this.remByte; ++i) {
                    this.underlyingBuffer.put(this.lineSeparator[i]);
                }
                this.remByte = -1;
            }
            this.length = this.inputFS.read(this.underlyingBuffer);
        } else {
            byte[] b = new byte[this.underlyingBuffer.capacity()];
            if (this.remByte != -1) {
                int remBytesNum = this.remByte + 1;
                System.arraycopy(this.lineSeparator, 0, b, 0, remBytesNum);
                this.length = this.input.read(b, remBytesNum, b.length - remBytesNum);
                this.remByte = -1;
            } else {
                this.length = this.input.read(b);
            }
            this.underlyingBuffer.put(b);
        }
    }

    private void updateBuffer() throws IOException {
        this.streamPos = this.seekable.getPos();
        this.underlyingBuffer.clear();
        if (this.endFound) {
            this.length = -1;
            return;
        }
        this.read();
        if (this.streamPos + (long)this.length >= this.endPos) {
            this.updateLengthBasedOnConstraint();
        }
        this.charCount += (long)this.bufferPtr;
        this.bufferPtr = 1;
        this.buffer.writerIndex(this.underlyingBuffer.limit());
        this.buffer.readerIndex(this.underlyingBuffer.position());
    }

    private void updateLengthBasedOnConstraint() {
        long max = this.bStart + (long)this.length;
        for (long m = this.bStart + (this.endPos - this.streamPos); m < max; ++m) {
            for (int i = 0; i < this.lineSeparator.length; ++i) {
                long mPlus = m + (long)i;
                if (mPlus < max) {
                    if (this.lineSeparator[i] != PlatformDependent.getByte(mPlus) || i != this.lineSeparator.length - 1) continue;
                    this.length = (int)(mPlus - this.bStart) + 1;
                    this.endFound = true;
                    return;
                }
                this.remByte = i;
                this.length -= i;
                return;
            }
        }
    }

    public final byte nextChar() throws IOException {
        byte byteChar = this.nextCharNoNewLineCheck();
        int bufferPtrTemp = this.bufferPtr - 1;
        if (byteChar == this.lineSeparator[0]) {
            int i = 1;
            while (i < this.lineSeparator.length) {
                if (this.lineSeparator[i] != this.buffer.getByte(bufferPtrTemp)) {
                    return byteChar;
                }
                ++i;
                ++bufferPtrTemp;
            }
            ++this.lineCount;
            byteChar = this.normalizedLineSeparator;
            if (this.lineSeparator.length > 1) {
                this.bufferPtr += this.lineSeparator.length - 1;
                if (this.bufferPtr >= this.length) {
                    if (this.length != -1) {
                        this.updateBuffer();
                    } else {
                        throw StreamFinishedPseudoException.INSTANCE;
                    }
                }
            }
        }
        return byteChar;
    }

    public final byte nextCharNoNewLineCheck() throws IOException {
        if (this.length == -1) {
            throw StreamFinishedPseudoException.INSTANCE;
        }
        BoundsChecking.rangeCheck(this.buffer, this.bufferPtr - 1, this.bufferPtr);
        byte byteChar = PlatformDependent.getByte(this.bStartMinus1 + (long)this.bufferPtr);
        if (this.bufferPtr >= this.length) {
            if (this.length != -1) {
                this.updateBuffer();
                --this.bufferPtr;
            } else {
                throw StreamFinishedPseudoException.INSTANCE;
            }
        }
        ++this.bufferPtr;
        return byteChar;
    }

    public final long lineCount() {
        return this.lineCount;
    }

    public final void skipLines(int lines) throws IOException {
        if (lines < 1) {
            return;
        }
        long expectedLineCount = this.lineCount + (long)lines;
        try {
            do {
                this.nextChar();
            } while (this.lineCount < expectedLineCount);
            if (this.lineCount < (long)lines) {
                throw new IllegalArgumentException("Unable to skip " + lines + " lines from line " + (expectedLineCount - (long)lines) + ". End of input reached");
            }
        }
        catch (EOFException ex) {
            throw new IllegalArgumentException("Unable to skip " + lines + " lines from line " + (expectedLineCount - (long)lines) + ". End of input reached");
        }
    }

    public final long charCount() {
        return this.charCount + (long)this.bufferPtr;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

