/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.text.reader;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.store.easy.text.reader.BaseFieldOutput;
import org.apache.drill.exec.vector.accessor.ArrayWriter;
import org.apache.drill.exec.vector.accessor.ScalarWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepeatedVarCharOutput
extends BaseFieldOutput {
    private static final Logger logger = LoggerFactory.getLogger(RepeatedVarCharOutput.class);
    private final ScalarWriter columnWriter;

    public RepeatedVarCharOutput(RowSetLoader loader, boolean[] projectionMask) {
        super(loader, RepeatedVarCharOutput.maxField(loader, projectionMask), projectionMask);
        ArrayWriter arrayWriter = this.writer.array(0);
        this.columnWriter = arrayWriter.scalar();
    }

    private static int maxField(RowSetLoader loader, boolean[] projectionMask) {
        int end;
        if (!loader.column(0).isProjected()) {
            return -1;
        }
        if (projectionMask == null) {
            return 65536;
        }
        for (end = projectionMask.length - 1; end >= 0 && !projectionMask[end]; --end) {
        }
        return end;
    }

    @Override
    public boolean endField() {
        if (this.currentFieldIndex > this.maxField) {
            return false;
        }
        if (this.fieldProjected) {
            if (this.currentFieldIndex > 65536) {
                throw UserException.unsupportedError().message("Text file contains too many fields", new Object[0]).addContext("Limit", 65536L).build(logger);
            }
            this.writeToVector();
        } else {
            this.columnWriter.setBytes(this.fieldBytes, 0);
        }
        return super.endField();
    }

    @Override
    protected ScalarWriter columnWriter() {
        return this.columnWriter;
    }
}

