/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.text.reader;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.store.easy.text.reader.TextOutput;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderBuilder
implements TextOutput {
    private static final Logger logger = LoggerFactory.getLogger(HeaderBuilder.class);
    public static final int MAX_HEADER_LEN = 1024;
    public static final String COLUMN_PREFIX = "col_";
    public static final String ANONYMOUS_COLUMN_PREFIX = "column_";
    private final Path filePath;
    private final List<String> headers = new ArrayList<String>();
    private final ByteBuffer currentField = ByteBuffer.allocate(1024);

    public HeaderBuilder(Path filePath) {
        this.filePath = filePath;
    }

    @Override
    public void startField(int index) {
        this.currentField.clear();
    }

    @Override
    public boolean endField() {
        String header = new String(this.currentField.array(), 0, this.currentField.position(), Charsets.UTF_8);
        header = this.validateSymbol(header);
        this.headers.add(header);
        return true;
    }

    @Override
    public boolean endEmptyField() {
        return this.endField();
    }

    private String validateSymbol(String header) {
        if ((header = header.trim()).isEmpty()) {
            return ANONYMOUS_COLUMN_PREFIX + (this.headers.size() + 1);
        }
        if (!Character.isAlphabetic(header.charAt(0))) {
            return this.rewriteHeader(header);
        }
        for (int i = 1; i < header.length(); ++i) {
            char ch = header.charAt(i);
            if (Character.isAlphabetic(ch) || Character.isDigit(ch) || ch == '_') continue;
            return this.rewriteHeader(header);
        }
        return header;
    }

    private String rewriteHeader(String header) {
        StringBuilder buf = new StringBuilder();
        char ch = header.charAt(0);
        if (Character.isAlphabetic(ch)) {
            buf.append(ch);
        } else if (Character.isDigit(ch)) {
            buf.append(COLUMN_PREFIX);
            buf.append(ch);
        } else {
            if (header.length() == 1) {
                return ANONYMOUS_COLUMN_PREFIX + (this.headers.size() + 1);
            }
            buf.append(COLUMN_PREFIX);
        }
        for (int i = 1; i < header.length(); ++i) {
            ch = header.charAt(i);
            if (Character.isAlphabetic(ch) || Character.isDigit(ch) || ch == '_') {
                buf.append(ch);
                continue;
            }
            buf.append("_");
        }
        return buf.toString();
    }

    @Override
    public void append(byte data) {
        try {
            this.currentField.put(data);
        }
        catch (BufferOverflowException e) {
            throw UserException.dataReadError().message("Column exceeds maximum length of %d", 1024).addContext("File Path", this.filePath.toString()).build(logger);
        }
    }

    @Override
    public void finishRecord() {
        if (this.headers.isEmpty()) {
            throw UserException.dataReadError().message("The file must define at least one header.", new Object[0]).addContext("File Path", this.filePath.toString()).build(logger);
        }
        HashSet<String> idents = new HashSet<String>();
        for (int i = 0; i < this.headers.size(); ++i) {
            String header = this.headers.get(i);
            String key = header.toLowerCase();
            if (idents.contains(key)) {
                int l = 2;
                while (true) {
                    String rewritten;
                    if (!idents.contains(key = (rewritten = header + "_" + l).toLowerCase())) {
                        this.headers.set(i, rewritten);
                        break;
                    }
                    ++l;
                }
            }
            idents.add(key);
        }
    }

    @Override
    public void startRecord() {
    }

    public String[] getHeaders() {
        String[] array = new String[this.headers.size()];
        return this.headers.toArray(array);
    }

    @Override
    public long getRecordCount() {
        return 0L;
    }

    @Override
    public boolean isFull() {
        return false;
    }
}

