/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.values;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import java.time.ZoneId;
import org.apache.drill.common.util.DrillDateTimeFormatter;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.values.ScalarListener;
import org.apache.drill.exec.vector.accessor.ScalarWriter;

public class UtcTimestampValueListener
extends ScalarListener {
    private static final ZoneId LOCAL_ZONE_ID = ZoneId.systemDefault();

    public UtcTimestampValueListener(JsonLoaderImpl loader, ScalarWriter writer) {
        super(loader, writer);
    }

    @Override
    public void onValue(JsonToken token, TokenIterator tokenizer) {
        Instant instant;
        switch (token) {
            case VALUE_NULL: {
                this.setNull();
                return;
            }
            case VALUE_NUMBER_INT: {
                instant = Instant.ofEpochMilli(tokenizer.longValue());
                break;
            }
            case VALUE_STRING: {
                try {
                    instant = DrillDateTimeFormatter.ISO_DATETIME_FORMATTER.parse((CharSequence)tokenizer.stringValue(), Instant::from);
                    break;
                }
                catch (Exception e) {
                    throw this.loader.dataConversionError(this.schema(), "date", tokenizer.stringValue());
                }
            }
            default: {
                throw tokenizer.invalidValue(token);
            }
        }
        this.addValueToListenerMap(this.writer.schema().name(), instant.toEpochMilli() + (long)LOCAL_ZONE_ID.getRules().getOffset(instant).getTotalSeconds() * 1000L);
        this.writer.setLong(instant.toEpochMilli() + (long)LOCAL_ZONE_ID.getRules().getOffset(instant).getTotalSeconds() * 1000L);
    }
}

