/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.values;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Duration;
import java.time.LocalDateTime;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.values.ScalarListener;
import org.apache.drill.exec.vector.accessor.ScalarWriter;

public class TimestampValueListener
extends ScalarListener {
    public static final LocalDateTime LOCAL_EPOCH = LocalDateTime.of(1970, 1, 1, 0, 0, 0);

    public TimestampValueListener(JsonLoaderImpl loader, ScalarWriter writer) {
        super(loader, writer);
    }

    @Override
    public void onValue(JsonToken token, TokenIterator tokenizer) {
        switch (token) {
            case VALUE_NULL: {
                this.setNull();
                return;
            }
            case VALUE_NUMBER_INT: {
                this.addValueToListenerMap(this.writer.schema().name(), tokenizer.longValue());
                this.writer.setLong(tokenizer.longValue());
                break;
            }
            case VALUE_STRING: {
                try {
                    LocalDateTime localDT = LocalDateTime.parse(tokenizer.stringValue());
                    this.addValueToListenerMap(this.writer.schema().name(), Duration.between(LOCAL_EPOCH, localDT).toMillis());
                    this.writer.setLong(Duration.between(LOCAL_EPOCH, localDT).toMillis());
                    break;
                }
                catch (Exception e) {
                    throw this.loader.dataConversionError(this.schema(), "date", tokenizer.stringValue());
                }
            }
            default: {
                throw tokenizer.invalidValue(token);
            }
        }
    }
}

