/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.values;

import com.fasterxml.jackson.core.JsonToken;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.values.ScalarListener;
import org.apache.drill.exec.vector.accessor.ScalarWriter;

public class StrictStringValueListener
extends ScalarListener {
    public StrictStringValueListener(JsonLoaderImpl loader, ScalarWriter writer) {
        super(loader, writer);
    }

    @Override
    public void onValue(JsonToken token, TokenIterator tokenizer) {
        switch (token) {
            case VALUE_NULL: {
                this.setNull();
                break;
            }
            case VALUE_STRING: {
                this.addValueToListenerMap(this.writer.schema().name(), tokenizer.stringValue());
                this.writer.setString(tokenizer.stringValue());
                break;
            }
            default: {
                throw tokenizer.invalidValue(token);
            }
        }
    }

    @Override
    protected void setArrayNull() {
        this.writer.setString("");
    }
}

