/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.values;

import com.fasterxml.jackson.core.JsonToken;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.values.ScalarListener;
import org.apache.drill.exec.vector.accessor.ScalarWriter;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public class IntervalValueListener
extends ScalarListener {
    public static final PeriodFormatter FORMATTER = ISOPeriodFormat.standard();

    public IntervalValueListener(JsonLoaderImpl loader, ScalarWriter writer) {
        super(loader, writer);
    }

    @Override
    public void onValue(JsonToken token, TokenIterator tokenizer) {
        switch (token) {
            case VALUE_NULL: {
                this.writer.setNull();
                break;
            }
            case VALUE_STRING: {
                try {
                    this.addValueToListenerMap(this.writer.schema().name(), FORMATTER.parsePeriod(tokenizer.stringValue()));
                    this.writer.setPeriod(FORMATTER.parsePeriod(tokenizer.stringValue()));
                    break;
                }
                catch (Exception e) {
                    throw this.loader.dataConversionError(this.schema(), "date", tokenizer.stringValue());
                }
            }
            default: {
                throw tokenizer.invalidValue(token);
            }
        }
    }
}

