/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.values;

import com.fasterxml.jackson.core.JsonToken;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.values.ScalarListener;
import org.apache.drill.exec.vector.accessor.ScalarWriter;

public class BooleanListener
extends ScalarListener {
    public BooleanListener(JsonLoaderImpl loader, ScalarWriter writer) {
        super(loader, writer);
    }

    @Override
    public void onValue(JsonToken token, TokenIterator tokenizer) {
        boolean value;
        switch (token) {
            case VALUE_NULL: {
                this.setNull();
                return;
            }
            case VALUE_TRUE: {
                value = true;
                break;
            }
            case VALUE_FALSE: {
                value = false;
                break;
            }
            case VALUE_NUMBER_INT: {
                value = tokenizer.longValue() != 0L;
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                value = tokenizer.doubleValue() != 0.0;
                break;
            }
            case VALUE_STRING: {
                this.parseString(tokenizer.stringValue());
                return;
            }
            default: {
                throw tokenizer.invalidValue(token);
            }
        }
        this.addValueToListenerMap(this.writer.schema().name(), value);
        this.writer.setBoolean(value);
    }

    private void parseString(String value) {
        if ((value = value.trim()).isEmpty()) {
            this.setNull();
        } else {
            this.addValueToListenerMap(this.writer.schema().name(), value);
            this.writer.setBoolean(Boolean.parseBoolean(value.trim()));
        }
    }

    @Override
    protected void setArrayNull() {
        this.writer.setBoolean(false);
    }
}

