/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.values;

import com.fasterxml.jackson.core.JsonToken;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.values.ScalarListener;
import org.apache.drill.exec.vector.accessor.ScalarWriter;

public class BigIntListener
extends ScalarListener {
    public BigIntListener(JsonLoaderImpl loader, ScalarWriter writer) {
        super(loader, writer);
    }

    @Override
    public void onValue(JsonToken token, TokenIterator tokenizer) {
        long value;
        switch (token) {
            case VALUE_NULL: {
                this.setNull();
                return;
            }
            case VALUE_TRUE: {
                value = 1L;
                break;
            }
            case VALUE_FALSE: {
                value = 0L;
                break;
            }
            case VALUE_NUMBER_INT: {
                value = tokenizer.longValue();
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                value = Math.round(tokenizer.doubleValue());
                break;
            }
            case VALUE_STRING: {
                this.parseString(tokenizer.stringValue());
                return;
            }
            default: {
                throw tokenizer.invalidValue(token);
            }
        }
        this.addValueToListenerMap(this.writer.schema().name(), value);
        this.writer.setLong(value);
    }

    private void parseString(String value) {
        if ((value = value.trim()).isEmpty()) {
            this.setNull();
        } else {
            try {
                this.addValueToListenerMap(this.writer.schema().name(), value);
                this.writer.setLong(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                throw this.loader.dataConversionError(this.schema(), "string", value);
            }
        }
    }

    @Override
    protected void setArrayNull() {
        this.writer.setLong(0L);
    }
}

