/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.reader;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonToken;
import io.netty.buffer.DrillBuf;
import java.io.IOException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.store.easy.json.JsonProcessor;
import org.apache.drill.exec.store.easy.json.reader.BaseJsonProcessor;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseJsonReader
extends BaseJsonProcessor {
    private static final Logger logger = LoggerFactory.getLogger(BaseJsonReader.class);
    private final boolean skipOuterList;
    private boolean inOuterList;

    public BaseJsonReader(DrillBuf workBuf, boolean enableNanInf, boolean enableEscapeAnyChar, boolean skipOuterList) {
        super(workBuf, enableNanInf, enableEscapeAnyChar);
        this.skipOuterList = skipOuterList;
    }

    @Override
    public JsonProcessor.ReadState write(BaseWriter.ComplexWriter writer) throws IOException {
        try {
            JsonToken t = this.lastSeenJsonToken;
            if (t == null || t == JsonToken.END_OBJECT) {
                t = this.parser.nextToken();
            }
            while (!this.parser.hasCurrentToken() && !this.parser.isClosed()) {
                t = this.parser.nextToken();
            }
            this.lastSeenJsonToken = null;
            if (this.parser.isClosed()) {
                return JsonProcessor.ReadState.END_OF_STREAM;
            }
            JsonProcessor.ReadState readState = this.writeToVector(writer, t);
            switch (readState) {
                case END_OF_STREAM: 
                case WRITE_SUCCEED: {
                    return readState;
                }
            }
            throw this.getExceptionWithContext(UserException.dataReadError(), null).message("Failure while reading JSON. (Got an invalid read state %s )", readState.toString()).build(logger);
        }
        catch (JsonParseException ex) {
            if (this.ignoreJSONParseError()) {
                if (this.processJSONException() == BaseJsonProcessor.JsonExceptionProcessingState.END_OF_STREAM) {
                    return JsonProcessor.ReadState.JSON_RECORD_PARSE_EOF_ERROR;
                }
                return JsonProcessor.ReadState.JSON_RECORD_PARSE_ERROR;
            }
            throw ex;
        }
    }

    private JsonProcessor.ReadState writeToVector(BaseWriter.ComplexWriter writer, JsonToken t) throws IOException {
        switch (t) {
            case START_OBJECT: {
                this.writeDocument(writer, t);
                break;
            }
            case START_ARRAY: {
                if (this.inOuterList) {
                    throw this.createDocumentTopLevelException();
                }
                if (this.skipOuterList) {
                    t = this.parser.nextToken();
                    if (t == JsonToken.START_OBJECT) {
                        this.inOuterList = true;
                        this.writeDocument(writer, t);
                        break;
                    }
                    throw this.createDocumentTopLevelException();
                }
                this.writeDocument(writer, t);
                break;
            }
            case END_ARRAY: {
                if (this.inOuterList) {
                    this.confirmLast();
                    return JsonProcessor.ReadState.END_OF_STREAM;
                }
                throw this.getExceptionWithContext(UserException.dataReadError(), null).message("Failure while parsing JSON.  Ran across unexpected %s.", JsonToken.END_ARRAY).build(logger);
            }
            case NOT_AVAILABLE: {
                return JsonProcessor.ReadState.END_OF_STREAM;
            }
            default: {
                throw this.getExceptionWithContext(UserException.dataReadError(), null).message("Failure while parsing JSON.  Found token of [%s].  Drill currently only supports parsing json strings that contain either lists or maps.  The root object cannot be a scalar.", t).build(logger);
            }
        }
        return JsonProcessor.ReadState.WRITE_SUCCEED;
    }

    protected abstract void writeDocument(BaseWriter.ComplexWriter var1, JsonToken var2) throws IOException;

    protected UserException createDocumentTopLevelException() {
        String message = "The top level of your document must either be a single array of maps or a set of white space delimited maps.";
        return this.getExceptionWithContext(UserException.dataReadError(), message).build(logger);
    }

    private void confirmLast() throws IOException {
        this.parser.nextToken();
        if (!this.parser.isClosed()) {
            String message = "Drill attempted to unwrap a toplevel list in your document. However, it appears that there is trailing content after this top level list.  Drill only supports querying a set of distinct maps or a single json array with multiple inner maps.";
            throw this.getExceptionWithContext(UserException.dataReadError(), message).build(logger);
        }
    }
}

