/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.parser;

import com.fasterxml.jackson.core.JsonToken;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.parser.ValueDef;

public class ValueDefFactory {
    private int arrayDims;
    private ValueDef.JsonType jsonType = ValueDef.JsonType.EMPTY;

    public ValueDefFactory(TokenIterator tokenizer) {
        this.inferValueType(tokenizer);
    }

    public static ValueDef lookAhead(TokenIterator tokenizer) {
        ValueDefFactory factory = new ValueDefFactory(tokenizer);
        return new ValueDef(factory.jsonType, factory.arrayDims);
    }

    public static ValueDef arrayLookAhead(TokenIterator tokenizer) {
        ValueDefFactory factory = new ValueDefFactory(tokenizer);
        return new ValueDef(factory.jsonType, factory.arrayDims + 1);
    }

    private void inferValueType(TokenIterator tokenizer) {
        JsonToken token = tokenizer.requireNext();
        switch (token) {
            case START_ARRAY: {
                ++this.arrayDims;
                this.inferValueType(tokenizer);
                break;
            }
            case END_ARRAY: {
                break;
            }
            case START_OBJECT: {
                this.jsonType = ValueDef.JsonType.OBJECT;
                break;
            }
            case VALUE_NULL: {
                this.jsonType = ValueDef.JsonType.NULL;
                break;
            }
            default: {
                this.jsonType = ValueDef.jsonTypeFor(token);
            }
        }
        tokenizer.unget(token);
    }
}

