/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.parser;

import com.fasterxml.jackson.core.JsonToken;

public class ValueDef {
    public static final ValueDef UNKNOWN_ARRAY = new ValueDef(JsonType.UNKNOWN, 1);
    public static final ValueDef UNKNOWN = new ValueDef(JsonType.UNKNOWN);
    private final int arrayDims;
    private final JsonType type;

    public ValueDef(JsonType type) {
        this(type, 0);
    }

    public ValueDef(JsonType type, int dims) {
        this.type = type;
        this.arrayDims = dims;
    }

    public JsonType type() {
        return this.type;
    }

    public int dimensions() {
        return this.arrayDims;
    }

    public boolean isArray() {
        return this.arrayDims > 0;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append(this.type.name());
        for (int i = 0; i < this.arrayDims; ++i) {
            buf.append("[]");
        }
        return buf.toString();
    }

    public static JsonType jsonTypeFor(JsonToken token) {
        switch (token) {
            case VALUE_NULL: {
                return JsonType.NULL;
            }
            case VALUE_FALSE: 
            case VALUE_TRUE: {
                return JsonType.BOOLEAN;
            }
            case VALUE_NUMBER_INT: {
                return JsonType.INTEGER;
            }
            case VALUE_NUMBER_FLOAT: {
                return JsonType.FLOAT;
            }
            case VALUE_STRING: 
            case VALUE_EMBEDDED_OBJECT: {
                return JsonType.STRING;
            }
        }
        throw new IllegalStateException("Not a scalar type: " + token.name());
    }

    public static enum JsonType {
        OBJECT,
        NULL,
        BOOLEAN,
        INTEGER,
        FLOAT,
        STRING,
        EMBEDDED_OBJECT,
        EMPTY,
        UNKNOWN;


        public boolean isObject() {
            return this == OBJECT;
        }

        public boolean isUnknown() {
            return this == NULL || this == EMPTY || this == UNKNOWN;
        }

        public boolean isScalar() {
            return !this.isObject() && !this.isUnknown();
        }
    }
}

