/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.parser;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.store.easy.json.parser.ErrorFactory;
import org.apache.drill.exec.store.easy.json.parser.JsonStructureOptions;
import org.apache.drill.exec.vector.accessor.UnsupportedConversionError;

public class TokenIterator {
    public static final int MAX_LOOKAHEAD = 30;
    private final ParserManager parserManager;
    private final JsonStructureOptions options;
    private final ErrorFactory errorFactory;
    private final JsonToken[] lookahead = new JsonToken[30];
    private int count;

    public TokenIterator(Iterable<InputStream> streams, Function<InputStream, JsonParser> parserFunction, JsonStructureOptions options, ErrorFactory errorFactory) {
        this.options = options;
        this.errorFactory = errorFactory;
        this.parserManager = new ParserManager(streams, parserFunction);
    }

    public JsonParser getParser() {
        JsonParser parser = this.parserManager.getParser();
        if (parser == null) {
            this.parserManager.nextParser();
        }
        return this.parserManager.getParser();
    }

    public ErrorFactory errorFactory() {
        return this.errorFactory;
    }

    public JsonToken next() {
        if (this.count > 0) {
            return this.lookahead[--this.count];
        }
        try {
            return this.getNextToken();
        }
        catch (JsonParseException e) {
            if (this.options.skipMalformedRecords) {
                throw new RecoverableJsonException();
            }
            throw this.errorFactory.syntaxError(e);
        }
        catch (IOException e) {
            throw this.errorFactory.ioException(e);
        }
    }

    private JsonToken getNextToken() throws IOException {
        JsonToken jsonToken = this.getParser().nextToken();
        if (jsonToken == null) {
            this.parserManager.nextParser();
            JsonParser parser = this.getParser();
            if (parser != null) {
                jsonToken = parser.nextToken();
            }
        }
        return jsonToken;
    }

    public String context() {
        String token;
        JsonLocation location = this.getParser().getCurrentLocation();
        try {
            token = this.getParser().getText();
        }
        catch (IOException e) {
            token = "<unknown>";
        }
        return "line " + location.getLineNr() + ", column " + location.getColumnNr() + ", near token \"" + token + "\"";
    }

    public int lineNumber() {
        JsonParser parser = this.getParser();
        return parser != null ? parser.getCurrentLocation().getLineNr() : 0;
    }

    public int columnNumber() {
        JsonParser parser = this.getParser();
        return parser != null ? parser.getCurrentLocation().getColumnNr() : 0;
    }

    public String token() {
        try {
            JsonParser parser = this.getParser();
            return parser != null ? this.getParser().getText() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public JsonToken requireNext() {
        JsonToken token = this.next();
        if (token == null) {
            throw this.errorFactory.structureError("Premature EOF of JSON file");
        }
        return token;
    }

    public JsonToken peek() {
        JsonToken token = this.requireNext();
        this.unget(token);
        return token;
    }

    public void unget(JsonToken token) {
        if (this.count == this.lookahead.length) {
            throw this.errorFactory.structureError(String.format("Excessive JSON array nesting. Max allowed: %d", this.lookahead.length));
        }
        this.lookahead[this.count++] = token;
    }

    public String textValue() {
        try {
            return this.getParser().getText();
        }
        catch (JsonParseException e) {
            throw this.errorFactory.syntaxError(e);
        }
        catch (IOException e) {
            throw this.errorFactory.ioException(e);
        }
    }

    public long longValue() {
        try {
            return this.getParser().getLongValue();
        }
        catch (JsonParseException e) {
            throw this.errorFactory.syntaxError(e);
        }
        catch (IOException e) {
            throw this.errorFactory.ioException(e);
        }
        catch (UnsupportedConversionError e) {
            throw this.errorFactory.typeError(e);
        }
    }

    public String stringValue() {
        try {
            return this.getParser().getValueAsString();
        }
        catch (JsonParseException e) {
            throw this.errorFactory.syntaxError(e);
        }
        catch (IOException e) {
            throw this.errorFactory.ioException(e);
        }
        catch (UnsupportedConversionError e) {
            throw this.errorFactory.typeError(e);
        }
    }

    public double doubleValue() {
        try {
            return this.getParser().getValueAsDouble();
        }
        catch (JsonParseException e) {
            throw this.errorFactory.syntaxError(e);
        }
        catch (IOException e) {
            throw this.errorFactory.ioException(e);
        }
        catch (UnsupportedConversionError e) {
            throw this.errorFactory.typeError(e);
        }
    }

    public byte[] binaryValue() {
        try {
            return this.getParser().getBinaryValue();
        }
        catch (JsonParseException e) {
            throw this.errorFactory.syntaxError(e);
        }
        catch (IOException e) {
            throw this.errorFactory.ioException(e);
        }
        catch (UnsupportedConversionError e) {
            throw this.errorFactory.typeError(e);
        }
    }

    public RuntimeException invalidValue(JsonToken token) {
        return this.errorFactory.structureError("Unexpected JSON value: " + token.name());
    }

    public void close() throws IOException {
        this.parserManager.close();
    }

    public static class ParserManager {
        private final Function<InputStream, JsonParser> parserFunction;
        private final Iterator<InputStream> parsersIterator;
        private JsonParser currentParser;

        public ParserManager(Iterable<InputStream> parsers, Function<InputStream, JsonParser> parserFunction) {
            this.parsersIterator = parsers.iterator();
            this.parserFunction = parserFunction;
            this.nextParser();
        }

        public JsonParser getParser() {
            return this.currentParser;
        }

        public ParserManager nextParser() {
            if (this.parsersIterator.hasNext()) {
                try {
                    if (this.currentParser != null) {
                        this.currentParser.close();
                    }
                }
                catch (IOException e) {
                    throw new DrillRuntimeException(e);
                }
                this.currentParser = this.parserFunction.apply(this.parsersIterator.next());
            } else {
                this.currentParser = null;
            }
            return this;
        }

        public void close() throws IOException {
            if (this.currentParser != null) {
                this.currentParser.close();
            }
        }
    }

    public static class RecoverableJsonException
    extends RuntimeException {
    }
}

