/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.parser;

import com.fasterxml.jackson.core.JsonToken;
import org.apache.drill.exec.store.easy.json.parser.JsonStructureParser;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.parser.ValueListener;
import org.apache.drill.exec.store.easy.json.parser.ValueParser;

public abstract class ScalarValueParser
extends ValueParser {
    public ScalarValueParser(JsonStructureParser structParser, ValueListener listener) {
        super(structParser, listener);
    }

    @Override
    public void parse(TokenIterator tokenizer) {
        JsonToken token = tokenizer.requireNext();
        if (!token.isScalarValue()) {
            throw this.errorFactory().structureError("Structure value found where scalar expected");
        }
        this.parseValue(tokenizer, token);
    }

    protected abstract void parseValue(TokenIterator var1, JsonToken var2);

    public static class TextValueParser
    extends ScalarValueParser {
        public TextValueParser(JsonStructureParser structParser, ValueListener listener) {
            super(structParser, listener);
        }

        @Override
        public void parseValue(TokenIterator tokenizer, JsonToken token) {
            if (token == JsonToken.VALUE_NULL) {
                this.listener.onValue(token, tokenizer);
            } else {
                this.listener.onText(token == JsonToken.VALUE_NULL ? null : tokenizer.textValue());
            }
        }
    }

    public static class SimpleValueParser
    extends ScalarValueParser {
        public SimpleValueParser(JsonStructureParser structParser, ValueListener listener) {
            super(structParser, listener);
        }

        @Override
        public void parseValue(TokenIterator tokenizer, JsonToken token) {
            this.listener.onValue(token, tokenizer);
        }
    }
}

