/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.parser;

import com.fasterxml.jackson.core.JsonToken;
import org.apache.drill.exec.store.easy.json.parser.ErrorFactory;
import org.apache.drill.exec.store.easy.json.parser.JsonStructureParser;
import org.apache.drill.exec.store.easy.json.parser.MessageParser;
import org.apache.drill.exec.store.easy.json.parser.ObjectParser;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RootParser {
    protected static final Logger logger = LoggerFactory.getLogger(RootParser.class);
    private final JsonStructureParser structParser;
    protected final ObjectParser rootObject;

    public RootParser(JsonStructureParser structParser) {
        this.structParser = structParser;
        this.rootObject = structParser.fieldFactory().rootParser();
    }

    public abstract boolean parseRoot(TokenIterator var1);

    protected boolean parseRootObject(JsonToken token, TokenIterator tokenizer) {
        switch (token) {
            case NOT_AVAILABLE: {
                return false;
            }
            case START_OBJECT: {
                this.rootObject.parse(tokenizer);
                break;
            }
            default: {
                throw this.errorFactory().syntaxError(token);
            }
        }
        return true;
    }

    protected ErrorFactory errorFactory() {
        return this.structParser.errorFactory();
    }

    public static class EmbeddedObjectParser
    extends RootParser {
        private final MessageParser messageParser;
        private int objectCount;

        public EmbeddedObjectParser(JsonStructureParser structParser, MessageParser messageParser) {
            super(structParser);
            this.messageParser = messageParser;
        }

        @Override
        public boolean parseRoot(TokenIterator tokenizer) {
            Preconditions.checkState(this.objectCount <= 1);
            if (this.objectCount == 0) {
                ++this.objectCount;
                JsonToken token = tokenizer.requireNext();
                if (token == JsonToken.START_OBJECT) {
                    return this.parseRootObject(token, tokenizer);
                }
                throw this.errorFactory().syntaxError(token);
            }
            try {
                this.messageParser.parseSuffix(tokenizer);
                return false;
            }
            catch (MessageParser.MessageContextException e) {
                throw this.errorFactory().messageParseError(e);
            }
        }
    }

    public static class EmbeddedArrayParser
    extends RootParser {
        private final MessageParser messageParser;

        public EmbeddedArrayParser(JsonStructureParser structParser, MessageParser messageParser) {
            super(structParser);
            this.messageParser = messageParser;
        }

        @Override
        public boolean parseRoot(TokenIterator tokenizer) {
            JsonToken token = tokenizer.requireNext();
            switch (token) {
                case END_ARRAY: {
                    break;
                }
                case START_OBJECT: {
                    return this.parseRootObject(token, tokenizer);
                }
                default: {
                    throw this.errorFactory().syntaxError(token);
                }
            }
            try {
                this.messageParser.parseSuffix(tokenizer);
                return false;
            }
            catch (MessageParser.MessageContextException e) {
                throw this.errorFactory().messageParseError(e);
            }
        }
    }

    public static class RootArrayParser
    extends RootParser {
        public RootArrayParser(JsonStructureParser structParser) {
            super(structParser);
        }

        @Override
        public boolean parseRoot(TokenIterator tokenizer) {
            JsonToken token = tokenizer.next();
            if (token == null) {
                logger.warn("Failed to close outer array. {}", (Object)tokenizer.context());
                return false;
            }
            switch (token) {
                case END_ARRAY: {
                    return false;
                }
                case START_OBJECT: {
                    return this.parseRootObject(token, tokenizer);
                }
            }
            throw this.errorFactory().syntaxError(token);
        }
    }

    public static class RootObjectParser
    extends RootParser {
        public RootObjectParser(JsonStructureParser structParser) {
            super(structParser);
        }

        @Override
        public boolean parseRoot(TokenIterator tokenizer) {
            JsonToken token = tokenizer.next();
            if (token == null) {
                return false;
            }
            if (token == JsonToken.START_OBJECT) {
                return this.parseRootObject(token, tokenizer);
            }
            throw this.errorFactory().syntaxError(token);
        }
    }
}

