/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.parser;

import com.fasterxml.jackson.core.JsonToken;
import org.apache.drill.exec.store.easy.json.parser.JsonStructureParser;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.parser.ValueListener;
import org.apache.drill.exec.store.easy.json.parser.ValueParser;

public class JsonValueParser
extends ValueParser {
    private final StringBuilder json = new StringBuilder();

    protected JsonValueParser(JsonStructureParser structParser, ValueListener listener) {
        super(structParser, listener);
    }

    @Override
    public void parse(TokenIterator tokenizer) {
        JsonToken token = tokenizer.requireNext();
        this.json.setLength(0);
        this.parseValue(tokenizer, token);
        this.listener.onText(this.json.toString());
        this.json.setLength(0);
    }

    private void parseValue(TokenIterator tokenizer, JsonToken token) {
        String textValue = tokenizer.textValue();
        switch (token) {
            case START_ARRAY: {
                this.json.append(token.asString());
                this.parseArrayTail(tokenizer);
                break;
            }
            case START_OBJECT: {
                this.json.append(token.asString());
                this.parseObjectTail(tokenizer);
                break;
            }
            case VALUE_STRING: {
                this.json.append(textValue);
                break;
            }
            default: {
                this.json.append(textValue);
            }
        }
    }

    public void parseArrayTail(TokenIterator tokenizer) {
        boolean first = true;
        while (true) {
            JsonToken token;
            if ((token = tokenizer.requireNext()) == JsonToken.END_ARRAY) {
                this.json.append(token.asString());
                return;
            }
            if (!first) {
                this.json.append(", ");
            }
            first = false;
            this.parseValue(tokenizer, token);
        }
    }

    public void parseObjectTail(TokenIterator tokenizer) {
        boolean first = true;
        while (true) {
            JsonToken token;
            if ((token = tokenizer.requireNext()) == JsonToken.END_OBJECT) {
                this.json.append(token.asString());
                return;
            }
            if (!first) {
                this.json.append(", ");
            }
            first = false;
            if (token != JsonToken.FIELD_NAME) {
                throw this.errorFactory().syntaxError(token);
            }
            this.json.append("\"");
            this.json.append(tokenizer.textValue());
            this.json.append("\": ");
            this.parseValue(tokenizer, tokenizer.requireNext());
        }
    }
}

