/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.parser;

import com.fasterxml.jackson.core.JsonToken;
import org.apache.drill.exec.store.easy.json.parser.AbstractElementParser;
import org.apache.drill.exec.store.easy.json.parser.ArrayParser;
import org.apache.drill.exec.store.easy.json.parser.JsonStructureParser;
import org.apache.drill.exec.store.easy.json.parser.ObjectParser;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;

public abstract class FullValueParser
extends AbstractElementParser {
    private ObjectParser objectParser;
    private ArrayParser arrayParser;

    public FullValueParser(JsonStructureParser structParser) {
        super(structParser);
    }

    @Override
    public void parse(TokenIterator tokenizer) {
        JsonToken token = tokenizer.requireNext();
        switch (token) {
            case START_OBJECT: {
                if (this.objectParser == null) {
                    this.objectParser = this.buildObjectParser(tokenizer);
                }
                this.objectParser.parse(tokenizer);
                break;
            }
            case START_ARRAY: {
                if (this.arrayParser == null) {
                    this.arrayParser = this.buildArrayParser(tokenizer);
                }
                this.arrayParser.parse(tokenizer);
                break;
            }
            default: {
                this.onValue(token, tokenizer);
            }
        }
    }

    protected abstract void onValue(JsonToken var1, TokenIterator var2);

    protected abstract ObjectParser buildObjectParser(TokenIterator var1);

    protected abstract ArrayParser buildArrayParser(TokenIterator var1);
}

